/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.thesis;

import java.util.Locale;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisEvaluationParticipant;
import org.fenixedu.academic.report.thesis.ThesisDocument;

public class ApproveJuryDocument
extends ThesisDocument {
    private static final long serialVersionUID = 1L;

    public ApproveJuryDocument(Thesis thesis) {
        super(thesis);
    }

    @Override
    protected void fillGeneric() {
        String author;
        String date;
        String ccAuthor;
        String ccDate;
        super.fillGeneric();
        Thesis thesis = this.getThesis();
        ThesisEvaluationParticipant thesisEvaluationParticipant = thesis.getProposalApprover();
        if (thesisEvaluationParticipant == null) {
            ccDate = "";
            ccAuthor = "";
            date = "";
            author = "";
        } else {
            Person person = thesisEvaluationParticipant.getPerson();
            boolean isDegreeCoordinator = this.checkCoordinator(thesis, person);
            if (person != null && !isDegreeCoordinator) {
                date = "";
                author = "";
                ccAuthor = thesisEvaluationParticipant.getName();
                ccDate = String.format(new Locale("pt"), "%1$td de %1$tB de %1$tY", thesis.getApproval().toDate());
            } else {
                ccDate = "";
                ccAuthor = "";
                author = thesisEvaluationParticipant.getName();
                date = String.format(new Locale("pt"), "%1$td de %1$tB de %1$tY", thesis.getApproval().toDate());
            }
        }
        this.addParameter("author", author);
        this.addParameter("date", date);
        this.addParameter("ccAuthor", ccAuthor);
        this.addParameter("ccDate", ccDate);
    }

    private boolean checkCoordinator(Thesis thesis, Person person) {
        return thesis.getDegree().getCurrentCoordinators().stream().map(coordinator -> coordinator.getPerson()).anyMatch(coord -> coord.equals((Object)person));
    }

    @Override
    public String getReportFileName() {
        Thesis thesis = this.getThesis();
        return "pedido-homologacao-aluno-" + thesis.getStudent().getNumber();
    }
}

