/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.candidacy.erasmus;

import java.util.Locale;
import java.util.TreeSet;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusApplyForSemesterType;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.report.FenixReport;
import org.fenixedu.academic.util.FenixStringTools;
import org.fenixedu.academic.util.MultiLanguageString;
import org.jsoup.helper.StringUtil;

public class LearningAgreementDocument
extends FenixReport {
    MobilityIndividualApplicationProcess process;
    protected static final char END_CHAR = ' ';
    protected static final int LINE_LENGTH = 70;
    protected static final String LINE_BREAK = "\n";
    protected static final String YEAR_TEXT = "Y.";
    protected static final String SEMESTER_TEXT = "Sem.";

    public LearningAgreementDocument(MobilityIndividualApplicationProcess process2) {
        this.process = process2;
        this.fillReport();
    }

    public LearningAgreementDocument(MobilityIndividualApplicationProcess process2, Locale locale) {
        super(locale);
        this.process = process2;
        this.fillReport();
    }

    @Override
    protected void fillReport() {
        this.addParameter("mobilityProgram", this.process.getMobilityProgram().getName().getContent(MultiLanguageString.en));
        this.addParameter("academicYear", this.process.getCandidacyExecutionInterval().getName());
        this.addParameter("studentName", this.process.getPersonalDetails().getName());
        this.addParameter("sendingInstitution", this.process.getCandidacy().getMobilityStudentData().getSelectedOpening().getMobilityAgreement().getUniversityUnit().getNameI18n().getContent());
        this.addParameter("desiredEnrollments", this.getChosenSubjectsInformation());
    }

    private String getChosenSubjectsInformation() {
        StringBuilder result = new StringBuilder();
        for (CurricularCourse course : this.process.getCandidacy().getCurricularCoursesSet()) {
            String yearAndSemester = this.buildYearAndSemester(course);
            result.append(FenixStringTools.multipleLineRightPadWithSuffix(course.getNameI18N().getContent(MultiLanguageString.en) + " (" + course.getDegree().getSigla() + ")" + yearAndSemester, 70, ' ', course.getEctsCredits().toString())).append(LINE_BREAK);
        }
        return result.toString();
    }

    private String buildYearAndSemester(CurricularCourse course) {
        TreeSet<Integer> years;
        String year = "";
        String semester = "";
        if (course.getParentContextsSet().size() > 1 && ((MobilityApplicationProcess)((Object)this.process.getCandidacyProcess())).getForSemester().equals((Object)ErasmusApplyForSemesterType.SECOND_SEMESTER)) {
            years = new TreeSet();
            for (Context context : course.getParentContextsSet()) {
                years.add(context.getCurricularYear());
            }
            if (years.size() == 1) {
                year = YEAR_TEXT + years.iterator().next();
            }
            semester = "Sem.2";
        } else if (course.getParentContextsSet().size() == 1) {
            Context context = (Context)course.getParentContextsSet().iterator().next();
            year = YEAR_TEXT + context.getCurricularYear();
            semester = SEMESTER_TEXT + (context.containsSemester(1) ? "1" : "2");
        } else {
            years = new TreeSet<Integer>();
            TreeSet<Integer> semesters = new TreeSet<Integer>();
            for (Context context : course.getParentContextsSet()) {
                years.add(context.getCurricularYear());
                semesters.add(context.containsSemester(1) ? 1 : 2);
            }
            if (years.size() == 1) {
                year = YEAR_TEXT + years.iterator().next();
            }
            if (semesters.size() == 1) {
                semester = SEMESTER_TEXT + semesters.iterator().next();
            }
        }
        String yearAndSemester = year + (StringUtil.isBlank((String)semester) || StringUtil.isBlank((String)year) ? "" : " - ") + semester;
        yearAndSemester = (StringUtil.isBlank((String)yearAndSemester) ? "" : " - ") + yearAndSemester;
        return yearAndSemester;
    }

    @Override
    public String getReportFileName() {
        return "learning_agreement_" + this.process.getCandidacy().getPersonalDetails().getDocumentIdNumber();
    }
}

