/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student;

import java.io.Serializable;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.dto.student.IRegistrationBean;
import org.fenixedu.academic.dto.student.RegistrationSelectExecutionYearBean;
import org.joda.time.YearMonthDay;

public class RegistrationCurriculumBean
extends RegistrationSelectExecutionYearBean
implements Serializable,
IRegistrationBean {
    private static final long serialVersionUID = 5825221957160251388L;
    private ProgramConclusion programConclusion;

    public RegistrationCurriculumBean(Registration registration) {
        this.setRegistration(registration);
    }

    public ProgramConclusion getProgramConclusion() {
        return this.programConclusion;
    }

    public void setProgramConclusion(ProgramConclusion programConclusion) {
        this.programConclusion = programConclusion;
    }

    public CurriculumGroup getCurriculumGroup() {
        return this.getProgramConclusion() == null ? null : (CurriculumGroup)this.getProgramConclusion().groupFor(this.getRegistration()).orElse(null);
    }

    public void setCurriculumGroup(CurriculumGroup curriculumGroup) {
        if (curriculumGroup.getDegreeModule().getProgramConclusion() != null) {
            this.setProgramConclusion(curriculumGroup.getDegreeModule().getProgramConclusion());
        } else {
            this.setProgramConclusion(null);
        }
    }

    public boolean hasCurriculumGroup() {
        return this.getCurriculumGroup() != null;
    }

    public Grade getFinalGrade() {
        if (this.hasCurriculumGroup() && this.getCurriculumGroup().isConclusionProcessed()) {
            return this.getCurriculumGroup().getFinalGrade();
        }
        if (this.getRegistration().isRegistrationConclusionProcessed()) {
            return this.getRegistration().getFinalGrade();
        }
        return null;
    }

    public Grade getRawGrade() {
        return this.hasCurriculumGroup() ? this.getCurriculumGroup().calculateRawGrade() : this.getRegistration().calculateRawGrade();
    }

    public YearMonthDay getConclusionDate() {
        if (this.hasCurriculumGroup() && this.getCurriculumGroup().isConclusionProcessed()) {
            return this.getCurriculumGroup().getConclusionDate();
        }
        if (this.getRegistration().isRegistrationConclusionProcessed()) {
            return this.getRegistration().getConclusionDate();
        }
        return null;
    }

    public double getEctsCredits() {
        return this.hasCurriculumGroup() ? this.getCurriculumGroup().getCreditsConcluded().doubleValue() : this.getRegistration().getEctsCredits();
    }

    public ICurriculum getCurriculum(ExecutionYear executionYear) {
        return this.hasCurriculumGroup() ? this.getCurriculumGroup().getCurriculum(executionYear) : this.getRegistration().getCurriculum(executionYear);
    }

    public ICurriculum getCurriculum() {
        return this.hasCurriculumGroup() ? this.getCurriculumGroup().getCurriculum() : this.getRegistration().getCurriculum();
    }

    public boolean isConcluded() {
        return this.hasCurriculumGroup() ? this.getCurriculumGroup().isConcluded() : this.getRegistration().hasConcluded();
    }

    public boolean isConclusionProcessed() {
        return this.hasCurriculumGroup() ? this.getCurriculumGroup().isConclusionProcessed() : this.getRegistration().isRegistrationConclusionProcessed();
    }
}

