/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.department;

import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import org.fenixedu.academic.domain.curriculum.IGrade;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public abstract class CourseStatisticsDTO
implements Serializable,
Comparable<CourseStatisticsDTO> {
    private static final long serialVersionUID = 1L;
    private String externalId;
    private String name;
    private int firstEnrolledCount;
    private int firstApprovedCount;
    private IGrade firstApprovedAverage;
    private int restEnrolledCount;
    private int restApprovedCount;
    private IGrade restApprovedAverage;
    private int totalEnrolledCount;
    private int totalApprovedCount;
    private IGrade totalApprovedAverage;
    private String NOT_AVAILABLE;
    public static final Comparator<CourseStatisticsDTO> COURSE_STATISTICS_COMPARATOR_BY_NAME = new Comparator<CourseStatisticsDTO>(){

        @Override
        public int compare(CourseStatisticsDTO o1, CourseStatisticsDTO o2) {
            return Collator.getInstance(I18N.getLocale()).compare(o1.getName(), o2.getName());
        }
    };

    public CourseStatisticsDTO() {
        this.NOT_AVAILABLE = BundleUtil.getString((String)"resources.DepartmentMemberResources", (String)"label.common.notAvailable", (String[])new String[0]);
    }

    public CourseStatisticsDTO(String externalId, String name, int firstEnrolledCount, int firstApprovedCount, IGrade firstApprovedAverage, int restEnrolledCount, int restApprovedCount, IGrade restApprovedAverage, int totalEnrolledCount, int totalApprovedCount, IGrade totalApprovedAverage) {
        this.externalId = externalId;
        this.name = name;
        this.firstEnrolledCount = firstEnrolledCount;
        this.firstApprovedCount = firstApprovedCount;
        this.firstApprovedAverage = firstApprovedAverage;
        this.restEnrolledCount = restEnrolledCount;
        this.restApprovedCount = restApprovedCount;
        this.restApprovedAverage = restApprovedAverage;
        this.totalEnrolledCount = totalEnrolledCount;
        this.totalApprovedCount = totalApprovedCount;
        this.totalApprovedAverage = totalApprovedAverage;
    }

    public IGrade getFirstApprovedAverage() {
        return this.firstApprovedAverage;
    }

    public String getFirstApprovedAveragex() {
        return this.firstApprovedCount != 0 ? this.firstApprovedAverage.getGradeValue().toString() : this.NOT_AVAILABLE;
    }

    public void setFirstApprovedAverage(IGrade firstApprovedAverage) {
        this.firstApprovedAverage = firstApprovedAverage;
    }

    public int getFirstApprovedCount() {
        return this.firstApprovedCount;
    }

    public void setFirstApprovedCount(int firstApprovedCount) {
        this.firstApprovedCount = firstApprovedCount;
    }

    public int getFirstEnrolledCount() {
        return this.firstEnrolledCount;
    }

    public void setFirstEnrolledCount(int firstEnrolledCount) {
        this.firstEnrolledCount = firstEnrolledCount;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IGrade getRestApprovedAverage() {
        return this.restApprovedAverage;
    }

    public String getRestApprovedAveragex() {
        return this.restApprovedCount != 0 ? this.restApprovedAverage.getGradeValue().toString() : this.NOT_AVAILABLE;
    }

    public void setRestApprovedAverage(IGrade restApprovedAverage) {
        this.restApprovedAverage = restApprovedAverage;
    }

    public int getRestApprovedCount() {
        return this.restApprovedCount;
    }

    public void setRestApprovedCount(int restApprovedCount) {
        this.restApprovedCount = restApprovedCount;
    }

    public int getRestEnrolledCount() {
        return this.restEnrolledCount;
    }

    public void setRestEnrolledCount(int restEnrolledCount) {
        this.restEnrolledCount = restEnrolledCount;
    }

    public IGrade getTotalApprovedAverage() {
        return this.totalApprovedAverage;
    }

    public String getTotalApprovedAveragex() {
        return this.totalApprovedCount != 0 ? this.totalApprovedAverage.getGradeValue().toString() : this.NOT_AVAILABLE;
    }

    public void setTotalApprovedAverage(IGrade totalApprovedAverage) {
        this.totalApprovedAverage = totalApprovedAverage;
    }

    public int getTotalApprovedCount() {
        return this.totalApprovedCount;
    }

    public void setTotalApprovedCount(int totalApprovedCount) {
        this.totalApprovedCount = totalApprovedCount;
    }

    public int getTotalEnrolledCount() {
        return this.totalEnrolledCount;
    }

    public void setTotalEnrolledCount(int totalEnrolledCount) {
        this.totalEnrolledCount = totalEnrolledCount;
    }

    public String getApprovedPercentage() {
        if (this.totalEnrolledCount == 0) {
            return this.NOT_AVAILABLE;
        }
        String result = "";
        result = String.format("%.2f%%", (double)this.totalApprovedCount * 100.0 / (double)this.totalEnrolledCount);
        return result;
    }

    @Override
    public int compareTo(CourseStatisticsDTO o) {
        return Collator.getInstance(I18N.getLocale()).compare(this.getName(), o.getName());
    }
}

