/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.commons.curriculumHistoric;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class InfoEnrolmentHistoricReport
implements Serializable {
    private Enrolment enrolment;

    public Enrolment getEnrolment() {
        return this.enrolment;
    }

    private void setEnrolment(Enrolment enrolment) {
        this.enrolment = enrolment;
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.getEnrolment().getStudentCurricularPlan();
    }

    public InfoEnrolmentHistoricReport(Enrolment enrolment) {
        this.setEnrolment(enrolment);
    }

    public List<String> getEvaluationGrades() {
        return EvaluationSeason.all().sorted().map(s -> this.enrolment.getLatestEnrolmentEvaluationBySeason((EvaluationSeason)s)).map(InfoEnrolmentHistoricReport::printGrade).collect(Collectors.toList());
    }

    private static String printGrade(EnrolmentEvaluation evaluation) {
        if (evaluation == null) {
            return "--";
        }
        Grade grade = evaluation.getGrade();
        if (!evaluation.isFinal()) {
            return BundleUtil.getString((String)"resources.EnumerationResources", (String)"msg.enrolled", (String[])new String[0]);
        }
        if (grade.isEmpty() || grade.isNotEvaluated()) {
            return BundleUtil.getString((String)"resources.EnumerationResources", (String)"msg.notEvaluated", (String[])new String[0]);
        }
        if (grade.isNotApproved()) {
            return BundleUtil.getString((String)"resources.EnumerationResources", (String)"msg.notApproved", (String[])new String[0]);
        }
        if (!grade.isNumeric() && grade.isApproved()) {
            return BundleUtil.getString((String)"resources.EnumerationResources", (String)"msg.approved", (String[])new String[0]);
        }
        return grade.getValue();
    }

    public String getLatestEnrolmentEvaluationInformation() {
        if (this.getEnrolment().isApproved()) {
            Grade grade = this.getEnrolment().getGrade();
            if (grade.getGradeScale() == GradeScale.TYPEAP) {
                return BundleUtil.getString((String)"resources.EnumerationResources", (String)"msg.approved", (String[])new String[0]);
            }
            return grade.getValue();
        }
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)this.getEnrolment().getEnrollmentState().name(), (String[])new String[0]);
    }
}

