/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.util.email;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Installation;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.util.email.CurrentUserReplyTo;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.PersonReplyTo;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.ReplyTo;
import org.fenixedu.academic.domain.util.email.Sender$callable$getConcreteReplyTos;
import org.fenixedu.academic.domain.util.email.Sender_Base;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Sender
extends Sender_Base {
    public static Comparator<Sender> COMPARATOR_BY_FROM_NAME;
    public static final Advice advice$getConcreteReplyTos;

    public Sender() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public Sender(String fromName, String fromAddress, Group members) {
        this();
        this.setFromName(fromName);
        this.setFromAddress(fromAddress);
        this.setMembers(members);
    }

    public Group getMembers() {
        return this.getMembersGroup().toGroup();
    }

    public void setMembers(Group members) {
        this.setMembersGroup(members.toPersistentGroup());
    }

    public void delete() {
        for (Message message : this.getMessagesSet()) {
            message.delete();
        }
        for (Recipient recipient : this.getRecipientsSet()) {
            if (recipient.getSendersSet().size() == 1) {
                recipient.delete();
                continue;
            }
            this.removeRecipients(recipient);
        }
        for (ReplyTo replyTo : this.getReplyTosSet()) {
            this.removeReplyTos(replyTo);
            replyTo.safeDelete();
        }
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public static String getNoreplyMail() {
        return Installation.getInstance().getInstituitionalEmailAddress("noreply");
    }

    public static boolean hasAvailableSender() {
        User userView = Authenticate.getUser();
        if (userView != null) {
            if (RoleType.MANAGER.isMember(userView.getPerson().getUser())) {
                return true;
            }
            Person person = userView.getPerson();
            if (person != null && !person.getMessagesSet().isEmpty()) {
                return true;
            }
            for (Sender sender : Bennu.getInstance().getUtilEmailSendersSet()) {
                if (!sender.allows(userView)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean allows(User userView) {
        return this.getMembers().isMember(userView);
    }

    public static Set<Sender> getAvailableSenders() {
        User userView = Authenticate.getUser();
        TreeSet<Sender> senders = new TreeSet<Sender>(COMPARATOR_BY_FROM_NAME);
        for (Sender sender : Bennu.getInstance().getUtilEmailSendersSet()) {
            if (!sender.getMembers().isMember(userView) && (userView == null || !RoleType.MANAGER.isMember(userView.getPerson().getUser()))) continue;
            senders.add(sender);
        }
        return senders;
    }

    public List<ReplyTo> getConcreteReplyTos() {
        return (List)advice$getConcreteReplyTos.perform((Callable)new Sender$callable$getConcreteReplyTos(this));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ List advised$getConcreteReplyTos(Sender this_) {
        ArrayList<Object> replyTos = new ArrayList<Object>();
        for (ReplyTo replyTo : this_.getReplyTosSet()) {
            if (replyTo instanceof CurrentUserReplyTo) {
                if (AccessControl.getPerson().getReplyTo() == null) {
                    PersonReplyTo concreteReplyTo = new PersonReplyTo(AccessControl.getPerson());
                    replyTos.add((Object)concreteReplyTo);
                    continue;
                }
                replyTos.add((Object)AccessControl.getPerson().getReplyTo());
                continue;
            }
            replyTos.add((Object)replyTo);
        }
        return replyTos;
    }

    public int deleteOldMessages() {
        int deletedCounter = 0;
        TreeSet<Message> messages = new TreeSet<Message>(Message.COMPARATOR_BY_CREATED_DATE_OLDER_LAST);
        messages.addAll(this.getMessagesSet());
        int sentCounter = 0;
        for (Message message : messages) {
            if (message.getSent() == null || ++sentCounter <= 500) continue;
            ++deletedCounter;
            message.delete();
        }
        return deletedCounter;
    }

    static {
        advice$getConcreteReplyTos = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_FROM_NAME = new Comparator<Sender>(){

            @Override
            public int compare(Sender sender1, Sender sender2) {
                int c = sender1.getFromName().compareTo(sender2.getFromName());
                return c == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)sender1, (DomainObject)sender2) : c;
            }
        };
    }
}

