/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ProgramConclusionProcess_Base;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.LocalDate;

public class ProgramConclusionProcess
extends ProgramConclusionProcess_Base {
    public ProgramConclusionProcess(RegistrationConclusionBean bean) {
        super.setRootDomainObject(Bennu.getInstance());
        CurriculumGroup group = bean.getCurriculumGroup();
        ExecutionYear conclusionYear = bean.getConclusionYear();
        if (group == null) {
            throw new DomainException("error.CycleConclusionProcess.argument.must.not.be.null", new String[0]);
        }
        if (conclusionYear == null) {
            throw new DomainException("error.CycleConclusionProcess.argument.must.not.be.null", new String[0]);
        }
        super.setGroup(group);
        super.setConclusionYear(conclusionYear);
        this.addVersions(bean);
    }

    public void update(RegistrationConclusionBean bean) {
        this.addVersions(bean);
    }

    public final void update(Person responsible, Grade finalGrade, Grade rawGrade, Grade descriptiveGrade, LocalDate conclusionDate, String notes) {
        this.addVersions(new RegistrationConclusionBean(this.getRegistration(), this.getGroup()));
        this.getLastVersion().update(responsible, finalGrade, rawGrade, descriptiveGrade, conclusionDate, notes);
    }

    protected void addSpecificVersionInfo() {
        Enrolment dissertationEnrolment = this.getRegistration().getDissertationEnrolment();
        if (dissertationEnrolment != null) {
            this.getLastVersion().setDissertationEnrolment(dissertationEnrolment);
        }
    }

    public void setRootDomainObject(Bennu rootDomainObject) {
        throw new DomainException("error.ConclusionProcess.method.not.allowed", new String[0]);
    }

    public void setConclusionYear(ExecutionYear conclusionYear) {
        throw new DomainException("error.ConclusionProcess.method.not.allowed", new String[0]);
    }

    public Registration getRegistration() {
        return this.getGroup().getRegistration();
    }
}

