/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.space;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.FrequencyType;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.space.WrittenEvaluationSpaceOccupation_Base;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.SpacePredicates;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.academic.util.HourMinuteSecond;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class WrittenEvaluationSpaceOccupation
extends WrittenEvaluationSpaceOccupation_Base {
    public WrittenEvaluationSpaceOccupation(Space allocatableSpace) {
        this.setResource(allocatableSpace);
    }

    public void edit(WrittenEvaluation writtenEvaluation) {
        if (this.getWrittenEvaluationsSet().contains((Object)writtenEvaluation)) {
            this.removeWrittenEvaluations(writtenEvaluation);
        }
        if (!writtenEvaluation.canBeAssociatedToRoom(this.getRoom())) {
            throw new DomainException("error.roomOccupied", this.getRoom().getName());
        }
        this.addWrittenEvaluations(writtenEvaluation);
    }

    public void delete() {
        AccessControl.check(this, SpacePredicates.checkPermissionsToManageWrittenEvaluationSpaceOccupations);
        if (this.getDeletionBlockers().isEmpty()) {
            super.delete();
        }
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getWrittenEvaluationsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.cannotDeleteWrittenEvaluationSpaceOccupation", (String[])new String[0]));
        }
    }

    public List<Interval> getEventSpaceOccupationIntervals(YearMonthDay startDateToSearch, YearMonthDay endDateToSearch) {
        ArrayList<Interval> result = new ArrayList<Interval>();
        Set writtenEvaluations = this.getWrittenEvaluationsSet();
        for (WrittenEvaluation writtenEvaluation : writtenEvaluations) {
            YearMonthDay writtenEvaluationDay = writtenEvaluation.getDayDateYearMonthDay();
            if (startDateToSearch != null && (writtenEvaluationDay.isBefore((ReadablePartial)startDateToSearch) || writtenEvaluationDay.isAfter((ReadablePartial)endDateToSearch))) continue;
            result.add(WrittenEvaluationSpaceOccupation.createNewInterval((YearMonthDay)writtenEvaluationDay, (YearMonthDay)writtenEvaluationDay, (HourMinuteSecond)writtenEvaluation.getBeginningDateHourMinuteSecond(), (HourMinuteSecond)writtenEvaluation.getEndDateHourMinuteSecond()));
        }
        return result;
    }

    protected boolean intersects(YearMonthDay startDate, YearMonthDay endDate) {
        return true;
    }

    public Group getAccessGroup() {
        return this.getSpace().getOccupationsGroupWithChainOfResponsability();
    }

    public YearMonthDay getBeginDate() {
        return null;
    }

    public YearMonthDay getEndDate() {
        return null;
    }

    public HourMinuteSecond getStartTimeDateHourMinuteSecond() {
        return null;
    }

    public HourMinuteSecond getEndTimeDateHourMinuteSecond() {
        return null;
    }

    public Boolean getDailyFrequencyMarkSaturday() {
        return null;
    }

    public Boolean getDailyFrequencyMarkSunday() {
        return null;
    }

    public DiaSemana getDayOfWeek() {
        return null;
    }

    public FrequencyType getFrequency() {
        return null;
    }

    public boolean isOccupiedByExecutionCourse(ExecutionCourse executionCourse, DateTime start, DateTime end) {
        for (WrittenEvaluation writtenEvaluation : this.getWrittenEvaluationsSet()) {
            if (!writtenEvaluation.getAssociatedExecutionCoursesSet().contains((Object)executionCourse) || !start.isBefore((ReadableInstant)writtenEvaluation.getEndDateTime()) || !end.isAfter((ReadableInstant)writtenEvaluation.getBeginningDateTime())) continue;
            return true;
        }
        return false;
    }

    public String getPresentationString() {
        if (this.getWrittenEvaluationsSet().isEmpty()) {
            return "";
        }
        WrittenEvaluation eval = (WrittenEvaluation)((Object)this.getWrittenEvaluationsSet().iterator().next());
        return String.format("(%s) %s", eval.getEvaluationType(), eval.getName());
    }

    protected boolean overlaps(Interval interval) {
        for (WrittenEvaluation writtenEvaluation : this.getWrittenEvaluationsSet()) {
            Interval evaluationInterval = writtenEvaluation.getInterval();
            if (!interval.overlaps((ReadableInterval)evaluationInterval)) continue;
            return true;
        }
        return false;
    }
}

