/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import java.util.Collections;
import java.util.Set;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ExternalProgramCertificateRequest_Base;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;

public class ExternalProgramCertificateRequest
extends ExternalProgramCertificateRequest_Base {
    protected ExternalProgramCertificateRequest() {
    }

    public ExternalProgramCertificateRequest(DocumentRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
        super.setNumberOfPrograms(bean.getNumberOfPrograms());
        super.setInstitution(bean.getInstitution());
    }

    protected void checkParameters(DocumentRequestCreateBean bean) {
        if (bean.getNumberOfPrograms() == null || bean.getNumberOfPrograms() == 0) {
            throw new DomainException("error.ExternalProgramCertificateRequest.invalid.numberOfPrograms", new String[0]);
        }
        if (bean.getInstitution() == null) {
            throw new DomainException("error.ExternalProgramCertificateRequest.invalid.institution", new String[0]);
        }
    }

    public Set<Enrolment> getEnrolmentsSet() {
        return Collections.unmodifiableSet(super.getEnrolmentsSet());
    }

    public void addEnrolments(Enrolment enrolments) {
        throw new DomainException("error.ExternalProgramCertificateRequest.cannot.add.enrolments", new String[0]);
    }

    public void removeEnrolments(Enrolment enrolments) {
        throw new DomainException("error.ExternalProgramCertificateRequest.cannot.remove.enrolments", new String[0]);
    }

    public DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.EXTERNAL_PROGRAM_CERTIFICATE;
    }

    public EventType getEventType() {
        return EventType.EXTERNAL_PROGRAM_CERTIFICATE_REQUEST;
    }

    protected void disconnect() {
        super.setInstitution(null);
        super.disconnect();
    }
}

