/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import java.util.Collection;
import java.util.Collections;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestYear_Base;
import org.fenixedu.bennu.core.domain.Bennu;

public class AcademicServiceRequestYear
extends AcademicServiceRequestYear_Base {
    private AcademicServiceRequestYear(int year) {
        super.setRootDomainObject(Bennu.getInstance());
        this.setYear(year);
        this.setLatestServiceRequestNumber(0);
    }

    public static final AcademicServiceRequestYear readByYear(int year, boolean create2) {
        for (AcademicServiceRequestYear requestYear : Bennu.getInstance().getAcademicServiceRequestYearsSet()) {
            if (requestYear.getYear() != year) continue;
            return requestYear;
        }
        if (create2) {
            return new AcademicServiceRequestYear(year);
        }
        return null;
    }

    public static Collection<AcademicServiceRequest> getAcademicServiceRequests(int year) {
        AcademicServiceRequestYear requestYear = AcademicServiceRequestYear.readByYear(year, false);
        if (requestYear == null) {
            return Collections.emptySet();
        }
        return requestYear.getAcademicServiceRequestsSet();
    }

    protected Integer generateServiceRequestNumber() {
        this.setLatestServiceRequestNumber(this.getLatestServiceRequestNumber() + 1);
        return this.getLatestServiceRequestNumber();
    }
}

