/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.raides;

import java.util.ArrayList;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.raides.DegreeClassification;
import org.fenixedu.academic.domain.raides.DegreeDesignation_Base;
import org.fenixedu.bennu.core.domain.Bennu;

public class DegreeDesignation
extends DegreeDesignation_Base {
    public DegreeDesignation(String code, String description, DegreeClassification degreeClassification) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setCode(code);
        this.setDescription(description);
        this.setDegreeClassification(degreeClassification);
    }

    public static DegreeDesignation readByNameAndSchoolLevel(String degreeDesignationName, SchoolLevelType schoolLevel) {
        if (schoolLevel == null || degreeDesignationName == null) {
            return null;
        }
        ArrayList<DegreeClassification> possibleClassifications = new ArrayList<DegreeClassification>();
        for (String code : schoolLevel.getEquivalentDegreeClassifications()) {
            possibleClassifications.add(DegreeClassification.readByCode(code));
        }
        ArrayList possibleDesignations = new ArrayList();
        for (DegreeClassification classification : possibleClassifications) {
            if (classification.getDegreeDesignationsSet().isEmpty()) continue;
            possibleDesignations.addAll(classification.getDegreeDesignationsSet());
        }
        for (DegreeDesignation degreeDesignation : possibleDesignations) {
            if (!degreeDesignation.getDescription().equalsIgnoreCase(degreeDesignationName)) continue;
            return degreeDesignation;
        }
        return null;
    }

    public void delete() {
        for (Unit institution : this.getInstitutionUnitSet()) {
            this.removeInstitutionUnit(institution);
        }
        this.setDegreeClassification(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }
}

