/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.meeting;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcess;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public enum PhdMeetingSchedulingProcessStateType implements PhdProcessStateType
{
    WAITING_FIRST_THESIS_MEETING_REQUEST,
    WAITING_FIRST_THESIS_MEETING_SCHEDULE,
    WITHOUT_THESIS_MEETING_REQUEST,
    WAITING_THESIS_MEETING_SCHEDULE;


    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getLocalizedName() {
        return this.getLocalizedName(I18N.getLocale());
    }

    @Override
    public String getLocalizedName(Locale locale) {
        return BundleUtil.getString((String)"resources.PhdResources", (Locale)locale, (String)this.getQualifiedName(), (String[])new String[0]);
    }

    private String getQualifiedName() {
        return this.getClass().getSimpleName() + "." + this.name();
    }

    public static List<PhdMeetingSchedulingProcessStateType> getPossibleNextStates(PhdMeetingSchedulingProcess process2) {
        PhdMeetingSchedulingProcessStateType activeState = process2.getActiveState();
        return PhdMeetingSchedulingProcessStateType.getPossibleNextStates(activeState);
    }

    public static List<PhdMeetingSchedulingProcessStateType> getPossibleNextStates(PhdMeetingSchedulingProcessStateType type) {
        if (type == null) {
            return Arrays.asList(WAITING_FIRST_THESIS_MEETING_REQUEST, WITHOUT_THESIS_MEETING_REQUEST);
        }
        switch (type) {
            case WAITING_FIRST_THESIS_MEETING_REQUEST: {
                return Collections.singletonList(WAITING_FIRST_THESIS_MEETING_SCHEDULE);
            }
            case WAITING_FIRST_THESIS_MEETING_SCHEDULE: {
                return Collections.singletonList(WITHOUT_THESIS_MEETING_REQUEST);
            }
            case WITHOUT_THESIS_MEETING_REQUEST: {
                return Collections.singletonList(WAITING_THESIS_MEETING_SCHEDULE);
            }
            case WAITING_THESIS_MEETING_SCHEDULE: {
                return Collections.singletonList(WITHOUT_THESIS_MEETING_REQUEST);
            }
        }
        return Collections.EMPTY_LIST;
    }
}

