/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public enum PhdThesisProcessStateType implements PhdProcessStateType
{
    NEW,
    WAITING_FOR_JURY_CONSTITUTION,
    JURY_WAITING_FOR_VALIDATION,
    JURY_VALIDATED,
    WAITING_FOR_JURY_REPORTER_FEEDBACK,
    WAITING_FOR_THESIS_MEETING_SCHEDULING,
    WAITING_FOR_THESIS_DISCUSSION_DATE_SCHEDULING,
    THESIS_DISCUSSION_DATE_SCHECULED,
    WAITING_FOR_THESIS_RATIFICATION,
    WAITING_FOR_FINAL_GRADE,
    CONCLUDED;


    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getLocalizedName() {
        return this.getLocalizedName(I18N.getLocale());
    }

    @Override
    public String getLocalizedName(Locale locale) {
        return BundleUtil.getString((String)"resources.PhdResources", (Locale)locale, (String)this.getQualifiedName(), (String[])new String[0]);
    }

    private String getQualifiedName() {
        return this.getClass().getSimpleName() + "." + this.name();
    }

    public static List<PhdThesisProcessStateType> getPossibleNextStates(PhdThesisProcess process2) {
        PhdThesisProcessStateType currentState = process2.getActiveState();
        return PhdThesisProcessStateType.getPossibleNextStates(currentState);
    }

    public static List<PhdThesisProcessStateType> getPossibleNextStates(PhdThesisProcessStateType type) {
        if (type == null) {
            return Collections.singletonList(NEW);
        }
        switch (type) {
            case NEW: {
                return Arrays.asList(WAITING_FOR_JURY_CONSTITUTION, WAITING_FOR_JURY_REPORTER_FEEDBACK);
            }
            case WAITING_FOR_JURY_CONSTITUTION: {
                return Arrays.asList(JURY_WAITING_FOR_VALIDATION, JURY_VALIDATED, WAITING_FOR_JURY_REPORTER_FEEDBACK);
            }
            case JURY_WAITING_FOR_VALIDATION: {
                return Arrays.asList(JURY_VALIDATED, WAITING_FOR_JURY_REPORTER_FEEDBACK);
            }
            case JURY_VALIDATED: {
                return Collections.singletonList(WAITING_FOR_JURY_REPORTER_FEEDBACK);
            }
            case WAITING_FOR_JURY_REPORTER_FEEDBACK: {
                return Collections.singletonList(WAITING_FOR_THESIS_MEETING_SCHEDULING);
            }
            case WAITING_FOR_THESIS_MEETING_SCHEDULING: {
                return Collections.singletonList(WAITING_FOR_THESIS_DISCUSSION_DATE_SCHEDULING);
            }
            case WAITING_FOR_THESIS_DISCUSSION_DATE_SCHEDULING: {
                return Collections.singletonList(THESIS_DISCUSSION_DATE_SCHECULED);
            }
            case THESIS_DISCUSSION_DATE_SCHECULED: {
                return Collections.singletonList(WAITING_FOR_THESIS_RATIFICATION);
            }
            case WAITING_FOR_THESIS_RATIFICATION: {
                return Collections.singletonList(WAITING_FOR_FINAL_GRADE);
            }
            case WAITING_FOR_FINAL_GRADE: {
                return Collections.singletonList(CONCLUDED);
            }
        }
        return Collections.EMPTY_LIST;
    }
}

