/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.period;

import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneCandidacyProcess;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.StandaloneCandidacyPeriod_Base;
import org.joda.time.DateTime;

public class StandaloneCandidacyPeriod
extends StandaloneCandidacyPeriod_Base {
    private StandaloneCandidacyPeriod() {
    }

    public StandaloneCandidacyPeriod(StandaloneCandidacyProcess candidacyProcess, ExecutionSemester executionSemester, DateTime start, DateTime end) {
        this();
        this.init(candidacyProcess, (ExecutionInterval)((Object)executionSemester), start, end);
    }

    private void init(StandaloneCandidacyProcess candidacyProcess, ExecutionInterval executionInterval, DateTime start, DateTime end) {
        this.checkParameters(candidacyProcess);
        this.checkIfCanCreate(executionInterval, start, end);
        super.init(executionInterval, start, end);
        this.addCandidacyProcesses((CandidacyProcess)((Object)candidacyProcess));
    }

    private void checkParameters(StandaloneCandidacyProcess candidacyProcess) {
        if (candidacyProcess == null) {
            throw new DomainException("error.StandaloneCandidacyProcess.invalid.candidacy.process", new String[0]);
        }
    }

    private void checkIfCanCreate(ExecutionInterval executionInterval, DateTime start, DateTime end) {
        for (StandaloneCandidacyPeriod candidacyPeriod : executionInterval.getStandaloneCandidacyPeriods()) {
            if (!candidacyPeriod.intercept(start, end)) continue;
            throw new DomainException("error.StandaloneCandidacyPeriod.interception", executionInterval.getName(), start.toString("dd/MM/yyyy HH:mm"), end.toString("dd/MM/yyyy HH:mm"));
        }
    }

    public StandaloneCandidacyProcess getStandaloneCandidacyProcess() {
        return (StandaloneCandidacyProcess)((Object)(!this.getCandidacyProcessesSet().isEmpty() ? (CandidacyProcess)((Object)this.getCandidacyProcessesSet().iterator().next()) : null));
    }

    public ExecutionSemester getExecutionInterval() {
        return (ExecutionSemester)((Object)super.getExecutionInterval());
    }

    public String getPresentationName() {
        return this.getStart().toString("dd/MM/yyyy") + " - " + this.getEnd().toString("dd/MM/yyyy");
    }

    public void edit(DateTime start, DateTime end) {
        this.checkDates(start, end);
        this.checkIfCandEdit(start, end);
        super.setStart(start);
        super.setEnd(end);
    }

    private void checkIfCandEdit(DateTime start, DateTime end) {
        for (StandaloneCandidacyPeriod StandaloneCandidacyPeriod2 : this.getExecutionInterval().getStandaloneCandidacyPeriods()) {
            if (StandaloneCandidacyPeriod2 == this || !StandaloneCandidacyPeriod2.intercept(start, end)) continue;
            throw new DomainException("error.StandaloneCandidacyPeriod.interception", this.getExecutionInterval().getName(), start.toString("dd/MM/yyyy HH:mm"), end.toString("dd/MM/yyyy HH:mm"));
        }
    }
}

