/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.executionCourse;

import java.io.Serializable;
import java.util.Collection;
import java.util.TreeSet;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;

public class ExecutionCourseSearchBean
implements Serializable {
    private ExecutionSemester executionPeriodDomainReference;
    private ExecutionDegree executionDegreeDomainReference;

    public ExecutionDegree getExecutionDegree() {
        return this.executionDegreeDomainReference;
    }

    public void setExecutionDegree(ExecutionDegree executionDegree) {
        this.executionDegreeDomainReference = executionDegree;
    }

    public ExecutionSemester getExecutionPeriod() {
        return this.executionPeriodDomainReference;
    }

    public void setExecutionPeriod(ExecutionSemester executionSemester) {
        this.executionPeriodDomainReference = executionSemester;
    }

    public Collection<ExecutionCourse> search(Collection<ExecutionCourse> result) {
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        ExecutionDegree executionDegree = this.getExecutionDegree();
        if (executionSemester == null || executionDegree == null) {
            return null;
        }
        for (ExecutionCourse executionCourse : executionSemester.getAssociatedExecutionCoursesSet()) {
            if (!this.matchesCriteria(executionSemester, executionDegree, executionCourse)) continue;
            result.add(executionCourse);
        }
        return result;
    }

    public Collection<ExecutionCourse> search() {
        TreeSet<ExecutionCourse> executionCourses = new TreeSet<ExecutionCourse>(ExecutionCourse.EXECUTION_COURSE_NAME_COMPARATOR);
        return this.search(executionCourses);
    }

    protected boolean matchesCriteria(ExecutionSemester executionSemester, ExecutionDegree executionDegree, ExecutionCourse executionCourse) {
        return this.matchExecutionPeriod(executionSemester, executionCourse) && this.matchExecutionDegree(executionDegree, executionCourse);
    }

    private boolean matchExecutionPeriod(ExecutionSemester executionSemester, ExecutionCourse executionCourse) {
        return executionSemester == executionCourse.getExecutionPeriod();
    }

    private boolean matchExecutionDegree(ExecutionDegree executionDegree, ExecutionCourse executionCourse) {
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            DegreeCurricularPlan degreeCurricularPlan = curricularCourse.getDegreeCurricularPlan();
            if (degreeCurricularPlan != executionDegree.getDegreeCurricularPlan()) continue;
            return true;
        }
        return false;
    }
}

