/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import java.util.Collection;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.RestrictionBetweenDegreeModules;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;

public class RestrictionBetweenDegreeModulesExecutor
extends CurricularRuleExecutor {
    @Override
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        RestrictionBetweenDegreeModules rule = (RestrictionBetweenDegreeModules)((Object)curricularRule);
        if (!this.canApplyRule(enrolmentContext, (ICurricularRule)((Object)rule))) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        DegreeModule precedenceDegreeModule = rule.getPrecedenceDegreeModule();
        if (this.isEnrolling(enrolmentContext, precedenceDegreeModule)) {
            return rule.hasMinimumCredits() ? this.createFalseRuleResultWithInvalidEcts(rule, sourceDegreeModuleToEvaluate) : RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (this.isEnroled(enrolmentContext, precedenceDegreeModule)) {
            CurriculumModule curriculumModule = this.searchCurriculumModule(enrolmentContext, precedenceDegreeModule);
            if (!rule.hasMinimumCredits() || rule.allowCredits(curriculumModule.getAprovedEctsCredits())) {
                return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
            }
            if (sourceDegreeModuleToEvaluate.isEnroled() && sourceDegreeModuleToEvaluate.isLeaf()) {
                return this.createImpossibleRuleResultWithInvalidEcts(rule, sourceDegreeModuleToEvaluate);
            }
            return this.createFalseRuleResultWithInvalidEcts(rule, sourceDegreeModuleToEvaluate);
        }
        return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.RestrictionBetweenDegreeModulesExecutor.student.has.not.precedence.degreeModule", rule.getDegreeModuleToApplyRule().getName(), rule.getPrecedenceDegreeModule().getName());
    }

    @Override
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        RestrictionBetweenDegreeModules rule = (RestrictionBetweenDegreeModules)((Object)curricularRule);
        if (!this.canApplyRule(enrolmentContext, (ICurricularRule)((Object)rule))) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        DegreeModule precedenceDegreeModule = rule.getPrecedenceDegreeModule();
        if (this.isEnrolling(enrolmentContext, precedenceDegreeModule)) {
            return rule.hasMinimumCredits() ? this.createFalseRuleResultWithInvalidEcts(rule, sourceDegreeModuleToEvaluate) : RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (this.isEnroled(enrolmentContext, precedenceDegreeModule)) {
            if (!rule.hasMinimumCredits()) {
                return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
            }
            CurriculumModule curriculumModule = this.searchCurriculumModule(enrolmentContext, precedenceDegreeModule);
            Double ectsCredits = curriculumModule.getAprovedEctsCredits();
            if (rule.allowCredits(ectsCredits)) {
                return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
            }
            if (rule.allowCredits(ectsCredits = Double.valueOf(ectsCredits + this.calculatePreviousPeriodEnroledEctsCredits(enrolmentContext, curriculumModule)))) {
                return RuleResult.createTrue(EnrolmentResultType.TEMPORARY, sourceDegreeModuleToEvaluate.getDegreeModule());
            }
            if (sourceDegreeModuleToEvaluate.isEnroled() && sourceDegreeModuleToEvaluate.isLeaf()) {
                return this.createImpossibleRuleResultWithInvalidEcts(rule, sourceDegreeModuleToEvaluate);
            }
            return this.createFalseRuleResultWithInvalidEcts(rule, sourceDegreeModuleToEvaluate);
        }
        return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.RestrictionBetweenDegreeModulesExecutor.student.has.not.precedence.degreeModule", rule.getDegreeModuleToApplyRule().getName(), rule.getPrecedenceDegreeModule().getName());
    }

    protected Double calculatePreviousPeriodEnroledEctsCredits(EnrolmentContext enrolmentContext, CurriculumModule curriculumModule) {
        return enrolmentContext.isToEvaluateRulesByYear() ? curriculumModule.getEnroledEctsCredits(enrolmentContext.getExecutionYear().getPreviousExecutionYear()) : curriculumModule.getEnroledEctsCredits(enrolmentContext.getExecutionPeriod().getPreviousExecutionPeriod());
    }

    private RuleResult createFalseRuleResultWithInvalidEcts(RestrictionBetweenDegreeModules rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.RestrictionBetweenDegreeModulesExecutor.invalid.ects.credits.in.precedence.degreeModule", rule.getDegreeModuleToApplyRule().getName(), rule.getPrecedenceDegreeModule().getName(), rule.getMinimumCredits().toString());
    }

    private RuleResult createImpossibleRuleResultWithInvalidEcts(RestrictionBetweenDegreeModules rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        return RuleResult.createImpossible(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.RestrictionBetweenDegreeModulesExecutor.invalid.ects.credits.in.precedence.degreeModule", rule.getDegreeModuleToApplyRule().getName(), rule.getPrecedenceDegreeModule().getName(), rule.getMinimumCredits().toString());
    }

    @Override
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        RestrictionBetweenDegreeModules restrictionBetweenDegreeModules = (RestrictionBetweenDegreeModules)((Object)curricularRule);
        Collection<CycleCourseGroup> cycleCourseGroups = restrictionBetweenDegreeModules.getPrecedenceDegreeModule().getParentCycleCourseGroups();
        for (CycleCourseGroup cycleCourseGroup : cycleCourseGroups) {
            CycleCurriculumGroup cycleCurriculumGroup = (CycleCurriculumGroup)((Object)enrolmentContext.getStudentCurricularPlan().findCurriculumGroupFor((CourseGroup)((Object)cycleCourseGroup)));
            if (cycleCurriculumGroup == null) continue;
            return true;
        }
        return false;
    }
}

