/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.alumni;

import java.lang.annotation.Annotation;
import java.text.Collator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.CerimonyInquiryGroup;
import org.fenixedu.academic.domain.alumni.CerimonyInquiry$callable$addPeople;
import org.fenixedu.academic.domain.alumni.CerimonyInquiry$callable$createNew;
import org.fenixedu.academic.domain.alumni.CerimonyInquiry$callable$createNewAnswer;
import org.fenixedu.academic.domain.alumni.CerimonyInquiry$callable$delete;
import org.fenixedu.academic.domain.alumni.CerimonyInquiry$callable$toggleObservationFlag;
import org.fenixedu.academic.domain.alumni.CerimonyInquiryAnswer;
import org.fenixedu.academic.domain.alumni.CerimonyInquiryPerson;
import org.fenixedu.academic.domain.alumni.CerimonyInquiry_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CerimonyInquiry
extends CerimonyInquiry_Base
implements Comparable<CerimonyInquiry> {
    public static final Advice advice$createNew = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createNewAnswer = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$addPeople = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$toggleObservationFlag = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public CerimonyInquiry() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setBegin(new DateTime().plusDays(1));
        this.setEnd(this.getBegin().plusDays(15));
    }

    @Override
    public int compareTo(CerimonyInquiry cerimonyInquiry) {
        if (this.getDescription() == null || cerimonyInquiry.getDescription() == null) {
            return 1;
        }
        int c = Collator.getInstance().compare(this.getDescription(), cerimonyInquiry.getDescription());
        return c == 0 ? this.getExternalId().compareTo(cerimonyInquiry.getExternalId()) : c;
    }

    public SortedSet<CerimonyInquiryAnswer> getOrderedCerimonyInquiryAnswer() {
        return new TreeSet<CerimonyInquiryAnswer>(this.getCerimonyInquiryAnswerSet());
    }

    public static CerimonyInquiry createNew() {
        return (CerimonyInquiry)advice$createNew.perform((Callable)new CerimonyInquiry$callable$createNew());
    }

    static /* synthetic */ CerimonyInquiry advised$createNew() {
        return new CerimonyInquiry();
    }

    public CerimonyInquiryAnswer createNewAnswer() {
        return (CerimonyInquiryAnswer)advice$createNewAnswer.perform((Callable)new CerimonyInquiry$callable$createNewAnswer(this));
    }

    static /* synthetic */ CerimonyInquiryAnswer advised$createNewAnswer(CerimonyInquiry this_) {
        return new CerimonyInquiryAnswer(this_);
    }

    public void addPeople(Set<String> set) {
        Object object = advice$addPeople.perform((Callable)new CerimonyInquiry$callable$addPeople(this, set));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$addPeople(CerimonyInquiry this_, Set usernames) {
        for (String username : usernames) {
            Person person;
            User user = User.findByUsername((String)username);
            if (user == null || this_.containsPerson(person = user.getPerson())) continue;
            new CerimonyInquiryPerson(this_, person);
        }
    }

    private boolean containsPerson(Person person) {
        for (CerimonyInquiryPerson cerimonyInquiryPerson : person.getCerimonyInquiryPersonSet()) {
            if (cerimonyInquiryPerson.getCerimonyInquiry() != this) continue;
            return true;
        }
        return false;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new CerimonyInquiry$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(CerimonyInquiry this_) {
        if (this_.getGroup() != null) {
            throw new DomainException("error.cerimonyInquiry.cannotDeleteCerimonyInquiryUsedInAccessControl", new String[0]);
        }
        for (CerimonyInquiryAnswer cerimonyInquiryAnswer : this_.getCerimonyInquiryAnswerSet()) {
            cerimonyInquiryAnswer.delete();
        }
        for (CerimonyInquiryPerson cerimonyInquiryPerson : this_.getCerimonyInquiryPersonSet()) {
            cerimonyInquiryPerson.delete();
        }
        this_.setRootDomainObject(null);
        this_.deleteDomainObject();
    }

    public boolean isOpen() {
        return this.getBegin() != null && this.getBegin().isBeforeNow() && (this.getEnd() == null || this.getEnd().isAfterNow());
    }

    public Recipient createRecipient() {
        return Recipient.newInstance("Inquiridos: " + this.getDescription(), (Group)CerimonyInquiryGroup.get(this));
    }

    public void toggleObservationFlag() {
        Object object = advice$toggleObservationFlag.perform((Callable)new CerimonyInquiry$callable$toggleObservationFlag(this));
    }

    static /* synthetic */ void advised$toggleObservationFlag(CerimonyInquiry this_) {
        Boolean allowComments = this_.getAllowComments();
        boolean value = allowComments == null || allowComments == false;
        this_.setAllowComments(value);
    }
}

