/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.gratuity;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.SpecializationDegreeGratuityEvent;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.IGratuityPR;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.SpecializationDegreeGratuityPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

public abstract class SpecializationDegreeGratuityPR
extends SpecializationDegreeGratuityPR_Base
implements IGratuityPR {
    protected SpecializationDegreeGratuityPR() {
    }

    public SpecializationDegreeGratuityPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money specializationDegreeTotalAmount, BigDecimal specializationDegreePartialAcceptedPercentage) {
        this.init(EntryType.GRATUITY_FEE, EventType.GRATUITY, startDate, endDate, serviceAgreementTemplate, specializationDegreeTotalAmount, specializationDegreePartialAcceptedPercentage);
    }

    protected void init(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money specializationDegreeTotalAmount, BigDecimal specializationDegreePartialAcceptedPercentage) {
        super.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate);
        this.checkParameters(specializationDegreeTotalAmount, specializationDegreePartialAcceptedPercentage);
        super.setSpecializationDegreeTotalAmount(specializationDegreeTotalAmount);
        super.setSpecializationDegreePartialAcceptedPercentage(specializationDegreePartialAcceptedPercentage);
    }

    private void checkParameters(Money specializationDegreeTotalAmount, BigDecimal specializationDegreePartialAcceptedPercentage) {
        if (specializationDegreeTotalAmount == null) {
            throw new DomainException("error.accounting.postingRules.gratuity.SpecializationDegreeGratuityPR.specializationDegreeTotalAmount.cannot.be.null", new String[0]);
        }
        if (specializationDegreePartialAcceptedPercentage == null) {
            throw new DomainException("error.accounting.postingRules.gratuity.SpecializationDegreeGratuityPR.specializationDegreePartialAcceptedPercentage.cannot.be.null", new String[0]);
        }
    }

    public void setSpecializationDegreeTotalAmount(Money specializationDegreeTotalAmount) {
        throw new DomainException("error.accounting.postingRules.gratuity.SpecializationDegreeGratuityPR.cannot.modify.specializationDegreeTotalAmount", new String[0]);
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        if (entryDTOs.size() != 1) {
            throw new DomainException("error.accounting.postingRules.gratuity.SpecializationDegreeGratuityPR.invalid.number.of.entryDTOs", new String[0]);
        }
        this.checkIfCanAddAmount(entryDTOs.iterator().next().getAmountToPay(), event, transactionDetail.getWhenRegistered());
        return Collections.singleton(this.makeAccountingTransaction(user, event, fromAccount, toAccount, this.getEntryType(), entryDTOs.iterator().next().getAmountToPay(), transactionDetail));
    }

    private void checkIfCanAddAmount(Money amountToAdd, Event event, DateTime when) {
        if (((GratuityEvent)((Object)event)).isCustomEnrolmentModel()) {
            this.checkIfCanAddAmountForCustomEnrolmentModel(event, when, amountToAdd);
        } else {
            this.checkIfCanAddAmountForCompleteEnrolmentModel(amountToAdd, event, when);
        }
    }

    private void checkIfCanAddAmountForCustomEnrolmentModel(Event event, DateTime when, Money amountToAdd) {
        if (event.calculateAmountToPay(when).greaterThan(amountToAdd)) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.gratuity.SpecializationDegreeGratuityPR.amount.being.payed.must.be.equal.to.amout.in.debt", event.getDescriptionForEntryType(this.getEntryType()));
        }
    }

    private void checkIfCanAddAmountForCompleteEnrolmentModel(Money amountToAdd, Event event, DateTime when) {
        if (this.hasAlreadyPayedAnyAmount(event, when)) {
            Money totalFinalAmount = event.getPayedAmount().add(amountToAdd);
            if (!totalFinalAmount.greaterOrEqualThan(this.calculateTotalAmountToPay(event, when)) && !totalFinalAmount.equals(this.getPartialPaymentAmount(event, when))) {
                throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.gratuity.SpecializationDegreeGratuityPR.amount.being.payed.must.be.equal.to.amout.in.debt", event.getDescriptionForEntryType(this.getEntryType()));
            }
        } else if (!this.isPayingTotalAmount(event, when, amountToAdd) && !this.isPayingPartialAmount(event, when, amountToAdd)) {
            LabelFormatter percentageLabelFormatter = new LabelFormatter();
            percentageLabelFormatter.appendLabel(this.getSpecializationDegreePartialAcceptedPercentage().multiply(BigDecimal.valueOf(100L)).toString());
            throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.gratuity.SpecializationDegreeGratuityPR.invalid.partial.payment.value", event.getDescriptionForEntryType(this.getEntryType()), percentageLabelFormatter);
        }
    }

    private boolean isPayingTotalAmount(Event event, DateTime when, Money amountToAdd) {
        return amountToAdd.greaterOrEqualThan(event.calculateAmountToPay(when));
    }

    private boolean isPayingPartialAmount(Event event, DateTime when, Money amountToAdd) {
        return amountToAdd.equals(this.getPartialPaymentAmount(event, when));
    }

    private boolean hasAlreadyPayedAnyAmount(Event event, DateTime when) {
        return !this.calculateTotalAmountToPay(event, when).equals(event.calculateAmountToPay(when));
    }

    private Money getPartialPaymentAmount(Event event, DateTime when) {
        return this.calculateTotalAmountToPay(event, when).multiply(this.getSpecializationDegreePartialAcceptedPercentage());
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        Money result = ((GratuityEvent)((Object)event)).isCustomEnrolmentModel() ? this.calculateSpecializationDegreeGratuityTotalAmountToPay(event) : this.getSpecializationDegreeTotalAmount();
        return result;
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        BigDecimal discountPercentage = applyDiscount ? this.getDiscountPercentage(event, amountToPay) : BigDecimal.ZERO;
        return amountToPay.multiply(BigDecimal.ONE.subtract(discountPercentage));
    }

    protected abstract Money calculateSpecializationDegreeGratuityTotalAmountToPay(Event var1);

    private BigDecimal getDiscountPercentage(Event event, Money amount) {
        return ((SpecializationDegreeGratuityEvent)((Object)event)).calculateDiscountPercentage(amount);
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        return Collections.singletonList(new EntryDTO(this.getEntryType(), event, this.calculateTotalAmountToPay(event, when), event.getPayedAmount(), event.calculateAmountToPay(when), event.getDescriptionForEntryType(this.getEntryType()), event.calculateAmountToPay(when)));
    }

    @Override
    public Money getDefaultGratuityAmount(ExecutionYear executionYear) {
        return this.getSpecializationDegreeTotalAmount();
    }
}

