/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.gratuity.exemption.penalty;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.Installment;
import org.fenixedu.academic.domain.accounting.events.PenaltyExemptionJustificationType;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEventWithPaymentPlan;
import org.fenixedu.academic.domain.accounting.events.gratuity.exemption.penalty.InstallmentPenaltyExemption_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class InstallmentPenaltyExemption
extends InstallmentPenaltyExemption_Base {
    protected InstallmentPenaltyExemption() {
    }

    public InstallmentPenaltyExemption(PenaltyExemptionJustificationType penaltyExemptionType, GratuityEventWithPaymentPlan gratuityEventWithPaymentPlan, Person responsible, Installment installment, String comments, YearMonthDay directiveCouncilDispatchDate) {
        this();
        this.init(penaltyExemptionType, gratuityEventWithPaymentPlan, responsible, installment, comments, directiveCouncilDispatchDate);
    }

    protected void init(PenaltyExemptionJustificationType penaltyExemptionType, GratuityEventWithPaymentPlan gratuityEventWithPaymentPlan, Person responsible, Installment installment, String comments, YearMonthDay directiveCouncilDispatchDate) {
        super.init(penaltyExemptionType, (Event)((Object)gratuityEventWithPaymentPlan), responsible, comments, directiveCouncilDispatchDate);
        this.checkParameters(installment);
        this.checkRulesToCreate(gratuityEventWithPaymentPlan, installment);
        super.setInstallment(installment);
    }

    private void checkRulesToCreate(GratuityEventWithPaymentPlan gratuityEventWithPaymentPlan, Installment installment) {
        if (gratuityEventWithPaymentPlan.hasPenaltyExemptionFor(installment)) {
            throw new DomainException("error.accounting.events.gratuity.exemption.penalty.InstallmentPenaltyExemption.event.already.has.penalty.exemption.for.installment", new String[0]);
        }
    }

    private void checkParameters(Installment installment) {
        if (installment == null) {
            throw new DomainException("error.accounting.events.gratuity.exemption.penalty.InstallmentPenaltyExemption.installment.cannot.be.null", new String[0]);
        }
    }

    public void setInstallment(Installment installment) {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        super.setInstallment(installment);
    }

    public void delete() {
        super.setInstallment(null);
        super.delete();
    }

    static {
        InstallmentPenaltyExemption.getRelationExemptionEvent().addListener((RelationListener)new RelationAdapter<Exemption, Event>(){

            public void beforeAdd(Exemption exemption, Event event) {
                if (exemption != null && event != null && exemption instanceof InstallmentPenaltyExemption && !(event instanceof GratuityEventWithPaymentPlan)) {
                    throw new DomainException("error.accounting.events.gratuity.exemption.penalty.InstallmentPenaltyExemption.cannot.add.installment.penalty.exemption.to.events.without.payment.plan", new String[0]);
                }
            }
        });
    }
}

