/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.gratuity;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EventState;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemptionJustificationType;
import org.fenixedu.academic.domain.accounting.events.gratuity.ValueGratuityExemption_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public class ValueGratuityExemption
extends ValueGratuityExemption_Base {
    public ValueGratuityExemption(Person responsible, GratuityEvent gratuityEvent, GratuityExemptionJustificationType gratuityExemptionType, String reason, YearMonthDay dispatchDate, Money value) {
        this.init(responsible, gratuityEvent, gratuityExemptionType, reason, dispatchDate, value);
    }

    public ValueGratuityExemption(GratuityEvent gratuityEvent, GratuityExemptionJustificationType gratuityExemptionType, String reason, YearMonthDay dispatchDate, Money value) {
        this(null, gratuityEvent, gratuityExemptionType, reason, dispatchDate, value);
    }

    protected void init(Person responsible, GratuityEvent gratuityEvent, GratuityExemptionJustificationType exemptionType, String reason, YearMonthDay dispatchDate, Money value) {
        this.checkParameters(value);
        super.setValue(value);
        super.init(responsible, gratuityEvent, exemptionType, reason, dispatchDate);
    }

    private void checkParameters(Money value) {
        if (value == null) {
            throw new DomainException("error.accounting.events.gratuity.ValueGratuityExemption.value.cannot.be.null", new String[0]);
        }
    }

    public void setValue(Money value) {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        super.setValue(value);
        DateTime now = new DateTime();
        this.getGratuityEvent().forceChangeState(EventState.OPEN, now);
        this.getGratuityEvent().recalculateState(now);
    }

    public BigDecimal calculateDiscountPercentage(Money amount) {
        BigDecimal amountToDiscount = new BigDecimal(this.getValue().toString());
        return amountToDiscount.divide(amount.getAmount(), 10, RoundingMode.HALF_EVEN);
    }

    public boolean isValueExemption() {
        return true;
    }
}

