/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.CreditNoteEntry;
import org.fenixedu.academic.domain.accounting.CreditNoteState;
import org.fenixedu.academic.domain.accounting.CreditNote_Base;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.PaymentMode;
import org.fenixedu.academic.domain.accounting.Receipt;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.dto.accounting.CreditNoteEntryDTO;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public class CreditNote
extends CreditNote_Base {
    public static Comparator<CreditNote> COMPARATOR_BY_NUMBER = new Comparator<CreditNote>(){

        @Override
        public int compare(CreditNote leftCreditNote, CreditNote rightCreditNote) {
            int comparationResult = leftCreditNote.getNumber().compareTo(rightCreditNote.getNumber());
            return comparationResult == 0 ? leftCreditNote.getExternalId().compareTo(rightCreditNote.getExternalId()) : comparationResult;
        }
    };

    private CreditNote() {
        Integer year = new DateTime().getYear();
        super.setNumber(this.generateCreditNoteNumber(year));
        super.setRootDomainObject(Bennu.getInstance());
        super.setWhenCreated(new DateTime());
        super.setYear(year);
    }

    private CreditNote(Receipt receipt, Person responsible) {
        this();
        this.init(receipt, responsible);
    }

    private void init(Receipt receipt, Person responsible) {
        this.checkParameters(receipt, responsible);
        this.checkRulesToCreate(receipt);
        super.setReceipt(receipt);
        this.internalChangeState(responsible, CreditNoteState.EMITTED);
    }

    private void checkRulesToCreate(Receipt receipt) {
        if (receipt.isAnnulled()) {
            throw new DomainException("error.accounting.CreditNote.cannot.be.created.for.annulled.receipts", new String[0]);
        }
    }

    private void checkParameters(Receipt receipt, Person responsible) {
        if (receipt == null) {
            throw new DomainException("error.accounting.CreditNote.receipt.cannot.be.null", new String[0]);
        }
        if (responsible == null) {
            throw new DomainException("error.accounting.CreditNote.responsible.cannot.be.null", new String[0]);
        }
    }

    private Integer generateCreditNoteNumber(Integer year) {
        List<CreditNote> creditNotes = this.getCreditNotesForYear(year);
        return creditNotes.isEmpty() ? Integer.valueOf(1) : Collections.max(creditNotes, COMPARATOR_BY_NUMBER).getNumber() + 1;
    }

    private List<CreditNote> getCreditNotesForYear(Integer year) {
        ArrayList<CreditNote> result = new ArrayList<CreditNote>();
        for (CreditNote creditNote : Bennu.getInstance().getCreditNotesSet()) {
            if (!creditNote.getYear().equals(year)) continue;
            result.add(creditNote);
        }
        return result;
    }

    public void setReceipt(Receipt receipt) {
        throw new DomainException("error.accounting.CreditNote.cannot.modify.receipt", new String[0]);
    }

    public void setResponsible(Person responsible) {
        throw new DomainException("error.accounting.CreditNote.cannot.modify.responsible", new String[0]);
    }

    public void setNumber(Integer number) {
        throw new DomainException("error.accounting.CreditNote.cannot.modify.number", new String[0]);
    }

    public void setYear(Integer year) {
        throw new DomainException("error.accounting.CreditNote.cannot.modify.year", new String[0]);
    }

    public void setWhenCreated(DateTime whenCreated) {
        throw new DomainException("error.accounting.CreditNote.cannot.modify.whenCreated", new String[0]);
    }

    public void addCreditNoteEntries(CreditNoteEntry creditNoteEntry) {
        throw new DomainException("error.accounting.CreditNote.cannot.add.creditNoteEntry", new String[0]);
    }

    public Set<CreditNoteEntry> getCreditNoteEntriesSet() {
        return Collections.unmodifiableSet(super.getCreditNoteEntriesSet());
    }

    public void removeCreditNoteEntries(CreditNoteEntry creditNoteEntry) {
        throw new DomainException("error.accounting.CreditNote.cannot.remove.creditNoteEntry", new String[0]);
    }

    public void setWhenUpdated(DateTime whenUpdated) {
        throw new DomainException("error.accounting.CreditNote.cannot.modify.whenUpdated", new String[0]);
    }

    public void setState(CreditNoteState state) {
        throw new DomainException("error.accounting.CreditNote.cannot.modify.state", new String[0]);
    }

    private void internalChangeState(Person responsible, CreditNoteState state) {
        super.setWhenUpdated(new DateTime());
        if (this.getState() != null && this.getState() != CreditNoteState.EMITTED) {
            throw new DomainException("error.accounting.CreditNote.only.emitted.credit.notes.can.be.changed", new String[0]);
        }
        super.setState(state);
        super.setResponsible(responsible);
    }

    public void confirm(Person responsible, PaymentMode paymentMode) {
        this.internalChangeState(responsible, CreditNoteState.PAYED);
        for (CreditNoteEntry creditNoteEntry : this.getCreditNoteEntriesSet()) {
            creditNoteEntry.createAdjustmentAccountingEntry(responsible.getUser(), paymentMode);
        }
    }

    public void annul(Person responsible) {
        this.internalChangeState(responsible, CreditNoteState.ANNULLED);
    }

    public void changeState(Person responsible, PaymentMode paymentMode, CreditNoteState state) {
        if (this.getState() == state) {
            return;
        }
        if (state == CreditNoteState.ANNULLED) {
            this.annul(responsible);
        } else if (state == CreditNoteState.PAYED) {
            this.confirm(responsible, paymentMode);
        } else {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.CreditNote.cannot.change.to.given.state", new String[0]);
        }
    }

    public static CreditNote create(Receipt receipt, Person responsible, List<CreditNoteEntryDTO> entryDTOs) {
        CreditNote creditNote = new CreditNote(receipt, responsible);
        if (entryDTOs == null || entryDTOs.isEmpty()) {
            throw new DomainException("error.accounting.CreditNote.cannot.be.created.without.entries", new String[0]);
        }
        for (CreditNoteEntryDTO entryDTO : entryDTOs) {
            if (!entryDTO.getEntry().canApplyReimbursement(entryDTO.getAmountToPay().negate())) {
                throw new DomainExceptionWithLabelFormatter("error.accounting.CreditNoteEntry.amount.to.reimburse.exceeds.entry.amount", entryDTO.getEntry().getDescription());
            }
            new CreditNoteEntry(creditNote, entryDTO.getEntry(), entryDTO.getAmountToPay());
        }
        CreditNote.checkIfEmittedCreditNotesExceedEventsMaxReimbursableAmounts(receipt);
        return creditNote;
    }

    private static void checkIfEmittedCreditNotesExceedEventsMaxReimbursableAmounts(Receipt receipt) {
        for (Map.Entry<Event, Money> each : CreditNote.calculateAmountsToReimburseByEvent(receipt).entrySet()) {
            if (each.getKey().canApplyReimbursement(each.getValue())) continue;
            throw new DomainExceptionWithLabelFormatter("error.accounting.CreditNote.the.sum.credit.notes.in.emitted.state.exceeds.event.reimbursable.amount", each.getKey().getDescription(), new LabelFormatter(each.getKey().getReimbursableAmount().toPlainString()));
        }
    }

    private static Map<Event, Money> calculateAmountsToReimburseByEvent(Receipt receipt) {
        HashMap<Event, Money> amountToReimburseByEvent = new HashMap<Event, Money>();
        for (CreditNote creditNote : receipt.getEmittedCreditNotes()) {
            for (CreditNoteEntry creditNoteEntry : creditNote.getCreditNoteEntriesSet()) {
                Event event = creditNoteEntry.getAccountingEntry().getAccountingTransaction().getEvent();
                Money amountToReimburse = creditNoteEntry.getAmount();
                if (amountToReimburseByEvent.containsKey((Object)event)) {
                    amountToReimburseByEvent.put(event, ((Money)amountToReimburseByEvent.get((Object)event)).add(amountToReimburse));
                    continue;
                }
                amountToReimburseByEvent.put(event, amountToReimburse);
            }
        }
        return amountToReimburseByEvent;
    }

    public boolean isEmitted() {
        return this.getState() == CreditNoteState.EMITTED;
    }

    public boolean isAnnulled() {
        return this.getState() == CreditNoteState.ANNULLED;
    }

    public boolean isPayed() {
        return this.getState() == CreditNoteState.PAYED;
    }

    public boolean isAllowedToChangeState() {
        return this.isEmitted();
    }

    public Money getTotalAmount() {
        Money totalAmount = Money.ZERO;
        for (CreditNoteEntry creditNoteEntry : this.getCreditNoteEntriesSet()) {
            totalAmount = totalAmount.add(creditNoteEntry.getAmount());
        }
        return totalAmount;
    }
}

