/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl.academicAdministration;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule_Base;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.accessControl.rules.AccessRule;
import org.fenixedu.academic.domain.accessControl.rules.AccessRuleSystem;
import org.fenixedu.academic.domain.accessControl.rules.AccessTarget;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.joda.time.DateTime;

public class AcademicAccessRule
extends AcademicAccessRule_Base
implements Comparable<AcademicAccessRule> {
    public AcademicAccessRule(AcademicOperationType operation, Group whoCanAccess, Set<AcademicAccessTarget> whatCanAffect) {
        this.setOperation(operation);
        this.setPersistentGroup(whoCanAccess.toPersistentGroup());
        for (AcademicAccessTarget target : whatCanAffect) {
            target.write(this, operation);
        }
    }

    public AcademicOperationType getOperation() {
        return (AcademicOperationType)super.getOperation();
    }

    public Set<AdministrativeOffice> getOfficeSet() {
        return super.getOfficeSet();
    }

    public Set<AcademicProgram> getProgramSet() {
        return super.getProgramSet();
    }

    public <T extends AccessTarget> Set<T> getWhatCanAffect() {
        return Stream.concat(this.getProgramSet().stream().map(AcademicProgramAccessTarget::new), this.getOfficeSet().stream().map(AdministrativeOfficeAccessTarget::new)).collect(Collectors.toSet());
    }

    public AcademicAccessRule changeProgramsAndOffices(Set<AcademicProgram> programs, Set<AdministrativeOffice> offices) {
        HashSet targets = new HashSet();
        if (programs != null) {
            programs.stream().forEach(p -> targets.add(new AcademicProgramAccessTarget((AcademicProgram)((Object)p))));
        }
        if (offices != null) {
            offices.stream().forEach(p -> targets.add(new AdministrativeOfficeAccessTarget((AdministrativeOffice)((Object)p))));
        }
        return (AcademicAccessRule)this.changeWhatCanAffect(targets).get();
    }

    public Stream<AcademicProgram> getFullProgramSet() {
        Stream managed = this.getOfficeSet().stream().flatMap(o -> o.getManagedAcademicProgramSet().stream());
        return Stream.concat(Stream.concat(this.getProgramSet().stream(), managed), Stream.of(Degree.readEmptyDegree()));
    }

    public static Stream<AcademicAccessRule> accessRules() {
        return AccessRuleSystem.accessRules().filter(r -> r instanceof AcademicAccessRule).map(r -> (AcademicAccessRule)((Object)r));
    }

    public static Stream<AcademicAccessRule> accessRules(DateTime when) {
        return AccessRuleSystem.accessRules(when).filter(r -> r instanceof AcademicAccessRule).map(r -> (AcademicAccessRule)((Object)r));
    }

    protected static Stream<AcademicAccessRule> filter(AcademicOperationType function) {
        return AcademicAccessRule.accessRules().filter(r -> r.getOperation().equals(function));
    }

    protected static Stream<AcademicAccessRule> filter(AcademicOperationType function, DateTime when) {
        return AcademicAccessRule.accessRules(when).filter(r -> r.getOperation().equals(function));
    }

    protected static Stream<AcademicAccessRule> filter(AcademicOperationType function, Set<AcademicProgram> programs, Set<AdministrativeOffice> offices) {
        Stream<AcademicAccessRule> stream = AcademicAccessRule.filter(function);
        if (programs != null && !programs.isEmpty()) {
            stream = stream.filter(r -> r.getFullProgramSet().collect(Collectors.toSet()).containsAll(programs));
        }
        if (offices != null && !offices.isEmpty()) {
            stream = stream.filter(r -> r.getOfficeSet().containsAll(offices));
        }
        return stream;
    }

    protected static Stream<AcademicAccessRule> filter(AcademicOperationType function, Set<AcademicProgram> programs, Set<AdministrativeOffice> offices, DateTime when) {
        Stream<AcademicAccessRule> stream = AcademicAccessRule.filter(function, when);
        if (programs != null && !programs.isEmpty()) {
            stream = stream.filter(r -> r.getFullProgramSet().collect(Collectors.toSet()).containsAll(programs));
        }
        if (offices != null && !offices.isEmpty()) {
            stream = stream.filter(r -> r.getOfficeSet().containsAll(offices));
        }
        return stream;
    }

    public static Set<User> getMembers(Predicate<? super AcademicAccessRule> filter) {
        return AcademicAccessRule.accessRules().filter(filter).map(AccessRule::getWhoCanAccess).flatMap(group -> group.getMembers().stream()).collect(Collectors.toSet());
    }

    public static Set<User> getMembers(AcademicOperationType function, Set<AcademicProgram> programs, Set<AdministrativeOffice> offices) {
        return AcademicAccessRule.filter(function, programs, offices).map(AccessRule::getWhoCanAccess).flatMap(group -> group.getMembers().stream()).collect(Collectors.toSet());
    }

    public static Set<User> getMembers(Predicate<? super AcademicAccessRule> filter, DateTime when) {
        return AcademicAccessRule.accessRules(when).filter(filter).map(AccessRule::getWhoCanAccess).flatMap(group -> group.getMembers(when).stream()).collect(Collectors.toSet());
    }

    public static Set<User> getMembers(AcademicOperationType function, Set<AcademicProgram> programs, Set<AdministrativeOffice> offices, DateTime when) {
        return AcademicAccessRule.filter(function, programs, offices, when).map(AccessRule::getWhoCanAccess).flatMap(group -> group.getMembers(when).stream()).collect(Collectors.toSet());
    }

    public static boolean isMember(User user, Predicate<? super AcademicAccessRule> filter) {
        return AcademicAccessRule.accessRules().filter(filter).anyMatch(group -> group.isMember(user));
    }

    public static boolean isMember(User user, AcademicOperationType function, Set<AcademicProgram> programs, Set<AdministrativeOffice> offices) {
        return AcademicAccessRule.filter(function, programs, offices).anyMatch(group -> group.isMember(user));
    }

    public static boolean isMember(User user, Predicate<? super AcademicAccessRule> filter, DateTime when) {
        return AcademicAccessRule.accessRules(when).filter(filter).anyMatch(group -> group.isMember(user, when));
    }

    public static boolean isMember(User user, AcademicOperationType function, Set<AcademicProgram> programs, Set<AdministrativeOffice> offices, DateTime when) {
        return AcademicAccessRule.filter(function, programs, offices, when).anyMatch(group -> group.isMember(user, when));
    }

    public static Stream<AcademicProgram> getProgramsAccessibleToFunction(AcademicOperationType function, User user) {
        return AcademicAccessRule.filter(function).filter(r -> r.getWhoCanAccess().isMember(user)).flatMap(r -> r.getFullProgramSet());
    }

    public static boolean isProgramAccessibleToFunction(AcademicOperationType function, AcademicProgram program, User user) {
        return AcademicAccessRule.filter(function).filter(r -> r.getWhoCanAccess().isMember(user)).flatMap(r -> r.getFullProgramSet()).anyMatch(p -> p.equals((Object)program));
    }

    public static Stream<Degree> getDegreesAccessibleToFunction(AcademicOperationType function, User user) {
        return AcademicAccessRule.getProgramsAccessibleToFunction(function, user).filter(p -> p instanceof Degree).map(p -> (Degree)((Object)p));
    }

    public static Stream<PhdProgram> getPhdProgramsAccessibleToFunction(AcademicOperationType function, User user) {
        return AcademicAccessRule.getProgramsAccessibleToFunction(function, user).filter(p -> p instanceof PhdProgram).map(p -> (PhdProgram)((Object)((Object)p)));
    }

    public static Stream<DegreeType> getDegreeTypesAccessibleToFunction(AcademicOperationType function, User user) {
        return AcademicAccessRule.getProgramsAccessibleToFunction(function, user).map(p -> p.getDegreeType()).filter(Objects::nonNull);
    }

    public static Stream<AdministrativeOffice> getOfficesAccessibleToFunction(AcademicOperationType function, User user) {
        return AcademicAccessRule.filter(function).filter(r -> r.getWhoCanAccess().isMember(user)).flatMap(r -> r.getOfficeSet().stream());
    }

    @Override
    public int compareTo(AcademicAccessRule o) {
        int op = this.getOperation().compareTo(o.getOperation());
        if (op != 0) {
            return op;
        }
        int group = this.getWhoCanAccess().compareTo(o.getWhoCanAccess());
        if (group != 0) {
            return group;
        }
        return this.getExternalId().compareTo(o.getExternalId());
    }

    public static class AdministrativeOfficeAccessTarget
    extends AcademicAccessTarget {
        private final AdministrativeOffice office;

        public AdministrativeOfficeAccessTarget(AdministrativeOffice office) {
            this.office = office;
        }

        public AdministrativeOffice getOffice() {
            return this.office;
        }

        @Override
        public void write(AcademicAccessRule academicAccessRule, AcademicOperationType operation) {
            if (!operation.isOfficeAllowedAsTarget()) {
                throw new DomainException("error.persistent.authorization.group.does.not.allow.offices", new String[0]);
            }
            academicAccessRule.addOffice(this.office);
        }
    }

    public static class AcademicProgramAccessTarget
    extends AcademicAccessTarget {
        private final AcademicProgram program;

        public AcademicProgramAccessTarget(AcademicProgram program) {
            this.program = program;
        }

        public AcademicProgram getProgram() {
            return this.program;
        }

        @Override
        public void write(AcademicAccessRule academicAccessRule, AcademicOperationType operation) {
            if (!operation.isProgramAllowedAsTarget()) {
                throw new DomainException("error.persistent.authorization.group.does.not.allow.offices", new String[0]);
            }
            academicAccessRule.addProgram(this.program);
        }
    }

    public static abstract class AcademicAccessTarget
    implements AccessTarget {
        public abstract void write(AcademicAccessRule var1, AcademicOperationType var2);
    }
}

