/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.PersistentTeacherGroup_Base;
import org.fenixedu.academic.domain.accessControl.TeacherGroup;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.spaces.domain.Space;

public class PersistentTeacherGroup
extends PersistentTeacherGroup_Base {
    protected PersistentTeacherGroup(Degree degree, ExecutionCourse executionCourse, Space campus, Department department, ExecutionYear executionYear) {
        this.setDegree(degree);
        this.setExecutionCourse(executionCourse);
        this.setCampus(campus);
        this.setDepartment(department);
        this.setExecutionYear(executionYear);
    }

    public Group toGroup() {
        return TeacherGroup.get(this.getDegree(), this.getExecutionCourse(), this.getCampus(), this.getDepartment(), this.getExecutionYear());
    }

    protected void gc() {
        this.setDegree(null);
        this.setExecutionCourse(null);
        this.setCampus(null);
        this.setDepartment(null);
        this.setExecutionYear(null);
        super.gc();
    }

    public static PersistentTeacherGroup getInstance(Degree degree) {
        return PersistentTeacherGroup.getInstance(() -> degree.getTeacherGroupSet().stream(), degree, null, null, null, null);
    }

    public static PersistentTeacherGroup getInstance(Space campus) {
        return PersistentTeacherGroup.getInstance(() -> campus.getTeacherGroupSet().stream(), null, null, campus, null, null);
    }

    public static PersistentTeacherGroup getInstance(Department department, ExecutionYear executionYear) {
        return PersistentTeacherGroup.getInstance(() -> department.getTeacherGroupSet().stream(), null, null, null, department, executionYear);
    }

    public static PersistentTeacherGroup getInstance(ExecutionCourse executionCourse) {
        return PersistentTeacherGroup.getInstance(() -> executionCourse.getTeacherGroupSet().stream(), null, executionCourse, null, null, null);
    }

    public static PersistentTeacherGroup getInstance(Degree degree, ExecutionCourse executionCourse, Space campus, Department department, ExecutionYear executionYear) {
        if (degree != null) {
            return PersistentTeacherGroup.getInstance(degree);
        }
        if (campus != null) {
            return PersistentTeacherGroup.getInstance(campus);
        }
        if (executionCourse != null) {
            return PersistentTeacherGroup.getInstance(executionCourse);
        }
        if (department != null) {
            return PersistentTeacherGroup.getInstance(department, executionYear);
        }
        return null;
    }

    private static PersistentTeacherGroup getInstance(Supplier<Stream<PersistentTeacherGroup>> options, Degree degree, ExecutionCourse executionCourse, Space campus, Department department, ExecutionYear executionYear) {
        return (PersistentTeacherGroup)PersistentTeacherGroup.singleton(() -> ((Stream)options.get()).filter(group -> Objects.equals(group.getDegree(), degree) && Objects.equals((Object)group.getExecutionCourse(), (Object)executionCourse) && Objects.equals(group.getCampus(), campus) && Objects.equals((Object)group.getDepartment(), (Object)department) && Objects.equals(group.getExecutionYear(), executionYear)).findAny(), () -> new PersistentTeacherGroup(degree, executionCourse, campus, department, executionYear));
    }
}

