/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Person_Base;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess_Base;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.Student_Base;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.GroupStrategy;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

@GroupOperator(value="activeStudents")
public class ActiveStudentsGroup
extends GroupStrategy {
    private static final long serialVersionUID = 2139482012047494196L;

    public String getPresentationName() {
        return BundleUtil.getString((String)"resources.GroupNameResources", (String)"label.name.ActiveStudentsGroup", (String[])new String[0]);
    }

    public Set<User> getMembers() {
        return Stream.concat(Bennu.getInstance().getPhdProgramsSet().stream().flatMap(program -> program.getIndividualProgramProcessesSet().stream()).filter(PhdIndividualProgramProcess::isProcessActive).map(PhdIndividualProgramProcess_Base::getPerson), Bennu.getInstance().getStudentsSet().stream().filter(Student::hasActiveRegistrations).map(Student_Base::getPerson)).map(Person_Base::getUser).collect(Collectors.toSet());
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        if (user == null || user.getPerson() == null) {
            return false;
        }
        return user.getPerson().getStudent() != null && user.getPerson().getStudent().hasActiveRegistrations() || user.getPerson().getPhdIndividualProgramProcessesSet().stream().anyMatch(PhdIndividualProgramProcess::isProcessActive);
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }
}

