/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import jvstm.cps.ConsistencyPredicate;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularCourseScope;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.EvaluationManagementLog;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.WrittenEvaluationEnrolment;
import org.fenixedu.academic.domain.WrittenEvaluation_Base;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.domain.space.WrittenEvaluationSpaceOccupation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.util.icalendar.EvaluationEventBean;
import org.fenixedu.academic.util.DateFormatUtil;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.academic.util.EvaluationType;
import org.fenixedu.academic.util.HourMinuteSecond;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.DomainObject;

public abstract class WrittenEvaluation
extends WrittenEvaluation_Base {
    public static final Comparator<WrittenEvaluation> COMPARATOR_BY_BEGIN_DATE = new Comparator<WrittenEvaluation>(){

        @Override
        public int compare(WrittenEvaluation o1, WrittenEvaluation o2) {
            int c1 = o1.getDayDateYearMonthDay().compareTo((ReadablePartial)o2.getDayDateYearMonthDay());
            if (c1 != 0) {
                return c1;
            }
            int c2 = o1.getBeginningDateHourMinuteSecond().compareTo(o2.getBeginningDateHourMinuteSecond());
            return c2 == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2) : c2;
        }
    };

    public static List<WrittenEvaluation> readWrittenEvaluations() {
        ArrayList<WrittenEvaluation> result = new ArrayList<WrittenEvaluation>();
        for (Evaluation evaluation : Bennu.getInstance().getEvaluationsSet()) {
            if (!(evaluation instanceof Evaluation)) continue;
            result.add((WrittenEvaluation)((Object)evaluation));
        }
        return result;
    }

    protected WrittenEvaluation() {
    }

    public String getName() {
        Set courses = this.getAssociatedExecutionCoursesSet();
        String name = "";
        int i = 0;
        for (ExecutionCourse course : courses) {
            if (i > 0) {
                name = name + ", ";
            }
            name = name + " " + course.getSigla();
            ++i;
        }
        return name;
    }

    public String getFullName() {
        Set courses = this.getAssociatedExecutionCoursesSet();
        String fullName = "";
        int i = 0;
        for (ExecutionCourse course : courses) {
            if (i > 0) {
                fullName = fullName + ", ";
            }
            fullName = fullName + " " + course.getNome();
            ++i;
        }
        return fullName;
    }

    public Space getCampus() {
        List<Space> rooms = this.getAssociatedRooms();
        if (rooms.size() > 0) {
            return SpaceUtils.getSpaceCampus(rooms.iterator().next());
        }
        return null;
    }

    public ExecutionYear getExecutionYear() {
        return ((ExecutionCourse)((Object)this.getAssociatedExecutionCoursesSet().iterator().next())).getExecutionYear();
    }

    public ExecutionDegree getExecutionDegree() {
        for (ExecutionCourse cource : this.getAssociatedExecutionCoursesSet()) {
            Iterator iterator = cource.getAssociatedCurricularCoursesSet().iterator();
            if (!iterator.hasNext()) continue;
            CurricularCourse curricularCource = (CurricularCourse)((Object)iterator.next());
            return curricularCource.getExecutionDegreeFor(this.getExecutionYear().getAcademicInterval());
        }
        return null;
    }

    public Boolean getIsAfterCurrentDate() {
        DateTime currentDate = new DateTime();
        return currentDate.isBefore((ReadableInstant)this.getBeginningDateTime());
    }

    public DateTime getBeginningDateTime() {
        HourMinuteSecond begin = this.getBeginningDateHourMinuteSecond();
        YearMonthDay yearMonthDay = this.getDayDateYearMonthDay();
        return new DateTime(yearMonthDay.getYear(), yearMonthDay.getMonthOfYear(), yearMonthDay.getDayOfMonth(), begin.getHour(), begin.getMinuteOfHour(), 0, 0);
    }

    public DateTime getEndDateTime() {
        HourMinuteSecond end = this.getEndDateHourMinuteSecond();
        YearMonthDay yearMonthDay = this.getDayDateYearMonthDay();
        return new DateTime(yearMonthDay.getYear(), yearMonthDay.getMonthOfYear(), yearMonthDay.getDayOfMonth(), end.getHour(), end.getMinuteOfHour(), 0, 0);
    }

    public EvaluationType getEvaluationType() {
        return EvaluationType.EXAM_TYPE;
    }

    public Calendar getBeginning() {
        if (this.getBeginningDate() != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getBeginningDate());
            return result;
        }
        return null;
    }

    public void setBeginning(Calendar calendar) {
        if (calendar != null) {
            this.setBeginningDate(calendar.getTime());
        } else {
            this.setBeginningDate(null);
        }
    }

    public Calendar getDay() {
        if (this.getDayDate() != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getDayDate());
            return result;
        }
        return null;
    }

    public void setDay(Calendar calendar) {
        if (calendar != null) {
            this.setDayDate(calendar.getTime());
        } else {
            this.setDayDate(null);
        }
    }

    public List<Space> getAssociatedRooms() {
        ArrayList<Space> result = new ArrayList<Space>();
        for (WrittenEvaluationSpaceOccupation roomOccupation : this.getWrittenEvaluationSpaceOccupationsSet()) {
            result.add(roomOccupation.getRoom());
        }
        return result;
    }

    protected void checkIntervalBetweenEvaluations() {
        User userView = Authenticate.getUser();
        if (userView == null || !RoleType.RESOURCE_ALLOCATION_MANAGER.isMember(userView.getPerson().getUser())) {
            this.checkIntervalBetweenEvaluationsCondition();
        }
    }

    public void checkIntervalBetweenEvaluationsCondition() {
        if (this.getDayDateYearMonthDay() != null && this.getBeginningDateHourMinuteSecond() != null) {
            for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
                for (Evaluation evaluation : executionCourse.getAssociatedEvaluationsSet()) {
                    WrittenEvaluation writtenEvaluation;
                    if (evaluation == this || !(evaluation instanceof WrittenEvaluation) || !this.isIntervalBetweenEvaluationsIsLessThan48Hours(this, writtenEvaluation = (WrittenEvaluation)((Object)evaluation)) || !this.hasMatchingCurricularCourseScopeOrContext(writtenEvaluation)) continue;
                    throw new DomainException("two.evaluations.cannot.occur.withing.48.hours", new String[0]);
                }
            }
        }
    }

    private boolean hasMatchingCurricularCourseScopeOrContext(WrittenEvaluation writtenEvaluation) {
        for (CurricularCourseScope curricularCourseScope : this.getAssociatedCurricularCourseScopeSet()) {
            if (!writtenEvaluation.getAssociatedCurricularCourseScopeSet().contains((Object)curricularCourseScope)) continue;
            return true;
        }
        for (Context context : this.getAssociatedContextsSet()) {
            if (!writtenEvaluation.getAssociatedContextsSet().contains(context)) continue;
            return true;
        }
        return false;
    }

    private boolean isIntervalBetweenEvaluationsIsLessThan48Hours(WrittenEvaluation writtenEvaluation1, WrittenEvaluation writtenEvaluation2) {
        if (writtenEvaluation1.getBeginningDateTime().isBefore((ReadableInstant)writtenEvaluation2.getBeginningDateTime())) {
            return !writtenEvaluation1.getBeginningDateTime().plusHours(48).isBefore((ReadableInstant)writtenEvaluation2.getBeginningDateTime());
        }
        return !writtenEvaluation2.getBeginningDateTime().plusHours(48).isBefore((ReadableInstant)writtenEvaluation1.getBeginningDateTime());
    }

    public Calendar getEnd() {
        if (this.getEndDate() != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getEndDate());
            return result;
        }
        return null;
    }

    public void setEnd(Calendar calendar) {
        if (calendar != null) {
            this.setEndDate(calendar.getTime());
        } else {
            this.setEndDate(null);
        }
    }

    public Calendar getEnrollmentBeginDay() {
        if (this.getEnrollmentBeginDayDate() != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getEnrollmentBeginDayDate());
            return result;
        }
        return null;
    }

    public void setEnrollmentBeginDay(Calendar calendar) {
        if (calendar != null) {
            this.setEnrollmentBeginDayDate(calendar.getTime());
        } else {
            this.setEnrollmentBeginDayDate(null);
        }
    }

    public Calendar getEnrollmentBeginTime() {
        if (this.getEnrollmentBeginTimeDate() != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getEnrollmentBeginTimeDate());
            return result;
        }
        return null;
    }

    public void setEnrollmentBeginTime(Calendar calendar) {
        if (calendar != null) {
            this.setEnrollmentBeginTimeDate(calendar.getTime());
        } else {
            this.setEnrollmentBeginTimeDate(null);
        }
    }

    public Calendar getEnrollmentEndDay() {
        if (this.getEnrollmentEndDayDate() != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getEnrollmentEndDayDate());
            return result;
        }
        return null;
    }

    public void setEnrollmentEndDay(Calendar calendar) {
        if (calendar != null) {
            this.setEnrollmentEndDayDate(calendar.getTime());
        } else {
            this.setEnrollmentEndDayDate(null);
        }
    }

    public Calendar getEnrollmentEndTime() {
        if (this.getEnrollmentEndTimeDate() != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getEnrollmentEndTimeDate());
            return result;
        }
        return null;
    }

    public void setEnrollmentEndTime(Calendar calendar) {
        if (calendar != null) {
            this.setEnrollmentEndTimeDate(calendar.getTime());
        } else {
            this.setEnrollmentEndTimeDate(null);
        }
    }

    protected void setAttributesAndAssociateRooms(Date day, Date beginning, Date end, List<ExecutionCourse> executionCoursesToAssociate, List<DegreeModuleScope> curricularCourseScopesToAssociate, List<Space> rooms) {
        if (rooms == null) {
            rooms = new ArrayList<Space>(0);
        }
        this.checkValidHours(beginning, end);
        this.getAssociatedExecutionCoursesSet().addAll(executionCoursesToAssociate);
        for (DegreeModuleScope degreeModuleScope : curricularCourseScopesToAssociate) {
            if (degreeModuleScope instanceof CurricularCourseScope.DegreeModuleScopeCurricularCourseScope) {
                this.addAssociatedCurricularCourseScope(((CurricularCourseScope.DegreeModuleScopeCurricularCourseScope)degreeModuleScope).getCurricularCourseScope());
                continue;
            }
            if (!(degreeModuleScope instanceof Context.DegreeModuleScopeContext)) continue;
            this.addAssociatedContexts(((Context.DegreeModuleScopeContext)degreeModuleScope).getContext());
        }
        this.setDayDate(day);
        this.setBeginningDate(beginning);
        this.setEndDate(end);
        List<WrittenEvaluationSpaceOccupation> newOccupations = this.associateNewRooms(rooms);
        HashSet<WrittenEvaluationSpaceOccupation> roomOccupationsToDelete = new HashSet<WrittenEvaluationSpaceOccupation>();
        for (WrittenEvaluationSpaceOccupation roomOccupation : this.getWrittenEvaluationSpaceOccupationsSet()) {
            if (newOccupations.contains((Object)roomOccupation)) continue;
            Space room = roomOccupation.getRoom();
            if (!rooms.contains(room)) {
                roomOccupationsToDelete.add(roomOccupation);
                continue;
            }
            roomOccupation.edit(this);
        }
        Iterator iter = roomOccupationsToDelete.iterator();
        while (iter.hasNext()) {
            WrittenEvaluationSpaceOccupation occupation = (WrittenEvaluationSpaceOccupation)((Object)iter.next());
            occupation.removeWrittenEvaluations(this);
            iter.remove();
            occupation.delete();
        }
    }

    private boolean checkValidHours(Date beginning, Date end) {
        if (beginning.after(end)) {
            throw new DomainException("error.data.exame.invalida", new String[0]);
        }
        return true;
    }

    private void deleteAllRoomOccupations() {
        while (!this.getWrittenEvaluationSpaceOccupationsSet().isEmpty()) {
            WrittenEvaluationSpaceOccupation occupation = (WrittenEvaluationSpaceOccupation)((Object)this.getWrittenEvaluationSpaceOccupationsSet().iterator().next());
            occupation.removeWrittenEvaluations(this);
            occupation.delete();
        }
    }

    public void removeRoomOccupation(Space room) {
        if (this.hasOccupationForRoom(room)) {
            WrittenEvaluationSpaceOccupation occupation = (WrittenEvaluationSpaceOccupation)SpaceUtils.getFirstOccurrenceOfResourceAllocationByClass(room, this);
            this.removeWrittenEvaluationSpaceOccupations(occupation);
        }
    }

    protected List<WrittenEvaluationSpaceOccupation> associateNewRooms(List<Space> rooms) {
        ArrayList<WrittenEvaluationSpaceOccupation> newInsertedOccupations = new ArrayList<WrittenEvaluationSpaceOccupation>();
        for (Space room : rooms) {
            WrittenEvaluationSpaceOccupation spaceOccupation = this.associateNewRoom(room);
            if (spaceOccupation == null) continue;
            newInsertedOccupations.add(spaceOccupation);
        }
        return newInsertedOccupations;
    }

    protected WrittenEvaluationSpaceOccupation associateNewRoom(Space room) {
        if (!this.hasOccupationForRoom(room)) {
            WrittenEvaluationSpaceOccupation occupation = (WrittenEvaluationSpaceOccupation)SpaceUtils.getFirstOccurrenceOfResourceAllocationByClass(room, this);
            occupation = occupation == null ? new WrittenEvaluationSpaceOccupation(room) : occupation;
            occupation.edit(this);
            return occupation;
        }
        return null;
    }

    private boolean hasOccupationForRoom(Space room) {
        for (WrittenEvaluationSpaceOccupation roomOccupation : this.getWrittenEvaluationSpaceOccupationsSet()) {
            if (roomOccupation.getRoom() != room) continue;
            return true;
        }
        return false;
    }

    protected void edit(Date day, Date beginning, Date end, List<ExecutionCourse> executionCoursesToAssociate, List<DegreeModuleScope> curricularCourseScopesToAssociate, List<Space> rooms, GradeScale gradeScale) {
        this.setAttributesAndAssociateRooms(day, beginning, end, executionCoursesToAssociate, curricularCourseScopesToAssociate, rooms);
        if (this.getGradeScale() != gradeScale) {
            if (gradeScale != null) {
                this.setGradeScale(gradeScale);
            } else {
                this.setGradeScale(GradeScale.TYPE20);
            }
        }
        this.checkIntervalBetweenEvaluations();
    }

    public void delete() {
        if (!this.getWrittenEvaluationEnrolmentsSet().isEmpty()) {
            throw new DomainException("error.notAuthorizedWrittenEvaluationDelete.withStudent", new String[0]);
        }
        this.logRemove();
        this.deleteAllRoomOccupations();
        this.getAssociatedCurricularCourseScopeSet().clear();
        this.getAssociatedContextsSet().clear();
        super.delete();
    }

    public void editEnrolmentPeriod(Date enrolmentBeginDay, Date enrolmentEndDay, Date enrolmentBeginTime, Date enrolmentEndTime) throws DomainException {
        this.checkEnrolmentDates(enrolmentBeginDay, enrolmentEndDay, enrolmentBeginTime, enrolmentEndTime);
        this.setEnrollmentBeginDayDate(enrolmentBeginDay);
        this.setEnrollmentEndDayDate(enrolmentEndDay);
        this.setEnrollmentBeginTimeDate(enrolmentBeginTime);
        this.setEnrollmentEndTimeDate(enrolmentEndTime);
        for (ExecutionCourse ec : this.getAssociatedExecutionCoursesSet()) {
            EvaluationManagementLog.createLog(ec, "resources.MessagingResources", "log.executionCourse.evaluation.generic.edited.enrolment", this.getPresentationName(), ec.getName(), ec.getDegreePresentationString());
        }
    }

    private void checkEnrolmentDates(Date enrolmentBeginDay, Date enrolmentEndDay, Date enrolmentBeginTime, Date enrolmentEndTime) throws DomainException {
        DateTime enrolmentBeginDate = this.createDate(enrolmentBeginDay, enrolmentBeginTime);
        DateTime enrolmentEndDate = this.createDate(enrolmentEndDay, enrolmentEndTime);
        if (this.getEnrollmentBeginDayDate() == null && enrolmentBeginDate.isBeforeNow()) {
            throw new DomainException("error.beginDate.sooner.today", new String[0]);
        }
        if (enrolmentEndDate.isBefore((ReadableInstant)enrolmentBeginDate)) {
            throw new DomainException("error.endDate.sooner.beginDate", new String[0]);
        }
        if (this.getBeginningDateTime().isBefore((ReadableInstant)enrolmentEndDate)) {
            throw new DomainException("error.examDate.sooner.endDate", new String[0]);
        }
    }

    private DateTime createDate(Date dateDay, Date dateTime) {
        Calendar day = Calendar.getInstance();
        day.setTime(dateDay);
        Calendar time = Calendar.getInstance();
        time.setTime(dateTime);
        return new DateTime(day.get(1), day.get(2) + 1, day.get(5), time.get(11), time.get(12), 0, 0);
    }

    public void enrolStudent(Registration registration) {
        for (WrittenEvaluationEnrolment writtenEvaluationEnrolment : registration.getWrittenEvaluationEnrolmentsSet()) {
            if (writtenEvaluationEnrolment.getWrittenEvaluation() != this) continue;
            throw new DomainException("error.alreadyEnrolledError", new String[0]);
        }
        new WrittenEvaluationEnrolment(this, registration);
    }

    public void unEnrolStudent(Registration registration) {
        if (!this.validUnEnrollment()) {
            throw new DomainException("error.notAuthorizedUnEnrollment", new String[0]);
        }
        WrittenEvaluationEnrolment writtenEvaluationEnrolmentToDelete = this.getWrittenEvaluationEnrolmentFor(registration);
        if (writtenEvaluationEnrolmentToDelete == null) {
            throw new DomainException("error.studentNotEnroled", new String[0]);
        }
        writtenEvaluationEnrolmentToDelete.delete();
    }

    private boolean validUnEnrollment() {
        DateTime enrolmentEnd;
        return this.getEnrollmentEndDay() != null && this.getEnrollmentEndTime() != null && (enrolmentEnd = this.createDate(this.getEnrollmentEndDayDate(), this.getEnrollmentEndTimeDate())).isAfterNow();
    }

    public void distributeStudentsByRooms(List<Registration> studentsToDistribute, List<Space> selectedRooms) {
        this.checkIfCanDistributeStudentsByRooms();
        this.checkRoomsCapacityForStudents(selectedRooms, studentsToDistribute.size());
        for (Space room : selectedRooms) {
            Integer examCapacity = room.getMetadata("examCapacity").orElse(0);
            for (int numberOfStudentsInserted = 0; numberOfStudentsInserted < examCapacity && !studentsToDistribute.isEmpty(); ++numberOfStudentsInserted) {
                Registration registration = this.getRandomStudentFromList(studentsToDistribute);
                WrittenEvaluationEnrolment writtenEvaluationEnrolment = this.getWrittenEvaluationEnrolmentFor(registration);
                if (writtenEvaluationEnrolment == null) {
                    new WrittenEvaluationEnrolment(this, registration, room);
                    continue;
                }
                writtenEvaluationEnrolment.setRoom(room);
            }
            if (!studentsToDistribute.isEmpty()) continue;
            break;
        }
        for (ExecutionCourse ec : this.getAssociatedExecutionCoursesSet()) {
            EvaluationManagementLog.createLog(ec, "resources.MessagingResources", "log.executionCourse.evaluation.generic.edited.rooms.distributed", this.getPresentationName(), ec.getName(), ec.getDegreePresentationString());
        }
    }

    public void checkIfCanDistributeStudentsByRooms() {
        Date evaluationDateAndTime;
        if (this.getWrittenEvaluationSpaceOccupationsSet().isEmpty()) {
            throw new DomainException("error.no.roms.associated", new String[0]);
        }
        Date todayDate = Calendar.getInstance().getTime();
        try {
            evaluationDateAndTime = DateFormatUtil.parse("yyyy/MM/dd HH:mm", DateFormatUtil.format("yyyy/MM/dd ", this.getDayDate()) + DateFormatUtil.format("HH:mm", this.getBeginningDate()));
        }
        catch (ParseException e) {
            throw new Error(e);
        }
        DateTime enrolmentEndDate = null;
        if (this.getEnrollmentEndDayDate() != null && this.getEnrollmentEndTimeDate() != null) {
            enrolmentEndDate = this.createDate(this.getEnrollmentEndDayDate(), this.getEnrollmentEndTimeDate());
        }
        if (DateFormatUtil.isBefore("yyyy/MM/dd HH:mm", evaluationDateAndTime, todayDate) || enrolmentEndDate != null && enrolmentEndDate.isAfterNow()) {
            throw new DomainException("error.out.of.period.enrollment.period", new String[0]);
        }
    }

    private void checkRoomsCapacityForStudents(List<Space> selectedRooms, int studentsToDistributeSize) {
        int totalCapacity = selectedRooms.stream().mapToInt(room -> room.getMetadata("examCapacity").orElse(0)).sum();
        if (studentsToDistributeSize > totalCapacity) {
            throw new DomainException("error.not.enough.room.space", new String[0]);
        }
    }

    private Registration getRandomStudentFromList(List<Registration> studentsToDistribute) {
        Random randomizer = new Random();
        int pos = randomizer.nextInt(Math.abs(randomizer.nextInt()));
        return studentsToDistribute.remove(pos % studentsToDistribute.size());
    }

    public WrittenEvaluationEnrolment getWrittenEvaluationEnrolmentFor(Registration registration) {
        for (WrittenEvaluationEnrolment writtenEvaluationEnrolment : registration.getWrittenEvaluationEnrolmentsSet()) {
            if (writtenEvaluationEnrolment.getWrittenEvaluation() != this) continue;
            return writtenEvaluationEnrolment;
        }
        return null;
    }

    public WrittenEvaluationEnrolment getWrittenEvaluationEnrolmentFor(Student student) {
        for (Registration registration : student.getActiveRegistrations()) {
            WrittenEvaluationEnrolment evaluationEnrolment = this.getWrittenEvaluationEnrolmentFor(registration);
            if (evaluationEnrolment == null) continue;
            return evaluationEnrolment;
        }
        return null;
    }

    public boolean isInEnrolmentPeriod() {
        if (this.getEnrollmentBeginDayDate() == null || this.getEnrollmentBeginTimeDate() == null || this.getEnrollmentEndDayDate() == null || this.getEnrollmentEndTimeDate() == null) {
            throw new DomainException("error.enrolmentPeriodNotDefined", new String[0]);
        }
        DateTime enrolmentBeginDate = this.createDate(this.getEnrollmentBeginDayDate(), this.getEnrollmentBeginTimeDate());
        DateTime enrolmentEndDate = this.createDate(this.getEnrollmentEndDayDate(), this.getEnrollmentEndTimeDate());
        return enrolmentBeginDate.isBeforeNow() && enrolmentEndDate.isAfterNow();
    }

    public boolean getIsInEnrolmentPeriod() {
        try {
            return this.isInEnrolmentPeriod();
        }
        catch (DomainException e) {
            return false;
        }
    }

    public Integer getCountStudentsEnroledAttendingExecutionCourses() {
        int i = 0;
        for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
            for (Attends attends : executionCourse.getAttendsSet()) {
                if (attends.getEnrolment() == null) continue;
                ++i;
            }
        }
        return i;
    }

    public Integer getCountNumberReservedSeats() {
        return this.getWrittenEvaluationSpaceOccupationsSet().stream().mapToInt(occupation -> occupation.getRoom().getMetadata("examCapacity").orElse(0)).sum();
    }

    public Integer getCountVacancies() {
        int writtenEvaluationEnrolmentsCount = this.getWrittenEvaluationEnrolmentsSet().size();
        int countNumberReservedSeats = this.getCountNumberReservedSeats();
        return countNumberReservedSeats - writtenEvaluationEnrolmentsCount;
    }

    public List<DegreeModuleScope> getDegreeModuleScopes() {
        return DegreeModuleScope.getDegreeModuleScopes(this);
    }

    public String getDegreesAsString() {
        HashSet<Degree> degrees = new HashSet<Degree>();
        for (ExecutionCourse course : this.getAssociatedExecutionCoursesSet()) {
            degrees.addAll(course.getDegreesSortedByDegreeName());
        }
        String degreesAsString = "";
        int i = 0;
        for (Degree degree : degrees) {
            if (i > 0) {
                degreesAsString = degreesAsString + ", ";
            }
            degreesAsString = degreesAsString + degree.getSigla();
            ++i;
        }
        return degreesAsString;
    }

    public String getAssociatedRoomsAsString() {
        String rooms = "";
        for (Space room : this.getAssociatedRooms()) {
            rooms = rooms + room.getName() + "\n";
        }
        return rooms;
    }

    public boolean hasScopeFor(Integer year, Integer semester, DegreeCurricularPlan degreeCurricularPlan) {
        for (DegreeModuleScope degreeModuleScope : this.getDegreeModuleScopes()) {
            if (!degreeModuleScope.getCurricularYear().equals(year) || !degreeModuleScope.getCurricularSemester().equals(semester) || !degreeModuleScope.getCurricularCourse().getDegreeCurricularPlan().equals((Object)degreeCurricularPlan)) continue;
            return true;
        }
        return false;
    }

    public boolean hasScopeOrContextFor(List<Integer> curricularYears, DegreeCurricularPlan degreeCurricularPlan) {
        if (curricularYears != null && degreeCurricularPlan != null) {
            for (DegreeModuleScope scope : this.getDegreeModuleScopes()) {
                if (!curricularYears.contains(scope.getCurricularYear()) || !degreeCurricularPlan.equals((Object)scope.getCurricularCourse().getDegreeCurricularPlan())) continue;
                return true;
            }
        }
        return false;
    }

    public DiaSemana getDayOfWeek() {
        return new DiaSemana(DiaSemana.getDiaSemana(this.getDayDateYearMonthDay()));
    }

    @ConsistencyPredicate
    protected boolean checkRequiredParameters() {
        HourMinuteSecond beginTime = this.getBeginningDateHourMinuteSecond();
        HourMinuteSecond endTime = this.getEndDateHourMinuteSecond();
        return this.getDayDateYearMonthDay() != null && beginTime != null && endTime != null && endTime.isAfter(beginTime);
    }

    public boolean isExam() {
        return false;
    }

    public boolean contains(CurricularCourse curricularCourse) {
        for (DegreeModuleScope each : this.getDegreeModuleScopes()) {
            if (each.getCurricularCourse() != curricularCourse) continue;
            return true;
        }
        return false;
    }

    public Set<DegreeModuleScope> getDegreeModuleScopesFor(CurricularCourse curricularCourse) {
        HashSet<DegreeModuleScope> result = new HashSet<DegreeModuleScope>();
        for (DegreeModuleScope each : this.getDegreeModuleScopes()) {
            if (each.getCurricularCourse() != curricularCourse) continue;
            result.add(each);
        }
        return result;
    }

    public abstract boolean canBeAssociatedToRoom(Space var1);

    private DateTime convertTimes(YearMonthDay yearMonthDay, HourMinuteSecond hourMinuteSecond) {
        return new DateTime(yearMonthDay.getYear(), yearMonthDay.getMonthOfYear(), yearMonthDay.getDayOfMonth(), hourMinuteSecond.getHour(), hourMinuteSecond.getMinuteOfHour(), hourMinuteSecond.getSecondOfMinute(), 0);
    }

    protected List<EvaluationEventBean> getAllEvents(String description, Registration registration) {
        ArrayList<EvaluationEventBean> result = new ArrayList<EvaluationEventBean>();
        String url = CoreConfiguration.getConfiguration().applicationUrl();
        HashSet<ExecutionCourse> executionCourses = new HashSet<ExecutionCourse>();
        executionCourses.addAll(this.getAttendingExecutionCoursesFor(registration));
        if (this.getEnrollmentBeginDayDateYearMonthDay() != null) {
            DateTime enrollmentBegin = this.convertTimes(this.getEnrollmentBeginDayDateYearMonthDay(), this.getEnrollmentBeginTimeDateHourMinuteSecond());
            DateTime enrollmentEnd = this.convertTimes(this.getEnrollmentEndDayDateYearMonthDay(), this.getEnrollmentEndTimeDateHourMinuteSecond());
            result.add(new EvaluationEventBean("Inicio das inscri\u00e7\u00f5es para " + description, enrollmentBegin, enrollmentBegin.plusHours(1), false, null, url + "/login", null, executionCourses));
            result.add(new EvaluationEventBean("Fim das inscri\u00e7\u00f5es para " + description, enrollmentEnd.minusHours(1), enrollmentEnd, false, null, url + "/login", null, executionCourses));
        }
        HashSet<Space> rooms = new HashSet<Space>();
        if (registration.getRoomFor(this) != null) {
            rooms.add(registration.getRoomFor(this));
        } else {
            for (WrittenEvaluationSpaceOccupation weSpaceOcupation : this.getWrittenEvaluationSpaceOccupationsSet()) {
                rooms.add(weSpaceOcupation.getRoom());
            }
        }
        WrittenEvaluationEnrolment writtenEvaluationEnrolment = this.getWrittenEvaluationEnrolmentFor(registration);
        Space assignedRoom = null;
        if (writtenEvaluationEnrolment != null) {
            assignedRoom = writtenEvaluationEnrolment.getRoom();
        }
        result.add(new EvaluationEventBean(description, this.getBeginningDateTime(), this.getEndDateTime(), false, assignedRoom, rooms, ((ExecutionCourse)((Object)executionCourses.iterator().next())).getSiteUrl(), null, executionCourses));
        return result;
    }

    public Set<Person> getTeachers() {
        HashSet<Person> persons = new HashSet<Person>();
        for (ExecutionCourse course : this.getAssociatedExecutionCoursesSet()) {
            for (Professorship professorship : course.getProfessorshipsSet()) {
                persons.add(professorship.getPerson());
            }
        }
        return persons;
    }

    public abstract List<EvaluationEventBean> getAllEvents(Registration var1);

    public String getAssociatedRoomsAsStringList() {
        StringBuilder builder = new StringBuilder("(");
        Iterator<Space> iterator = this.getAssociatedRooms().iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next().getName());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(")");
        return builder.toString();
    }

    public Interval getDurationInterval() {
        return new Interval((ReadableInstant)this.getBeginningDateTime(), (ReadableInstant)this.getEndDateTime());
    }

    @Deprecated
    public Date getBeginningDate() {
        HourMinuteSecond hms = this.getBeginningDateHourMinuteSecond();
        return hms == null ? null : new Date(0, 0, 1, hms.getHour(), hms.getMinuteOfHour(), hms.getSecondOfMinute());
    }

    @Deprecated
    public void setBeginningDate(Date date) {
        if (date == null) {
            this.setBeginningDateHourMinuteSecond(null);
        } else {
            this.setBeginningDateHourMinuteSecond(HourMinuteSecond.fromDateFields(date));
        }
    }

    @Deprecated
    public Date getDayDate() {
        YearMonthDay ymd = this.getDayDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setDayDate(Date date) {
        if (date == null) {
            this.setDayDateYearMonthDay(null);
        } else {
            this.setDayDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getEndDate() {
        HourMinuteSecond hms = this.getEndDateHourMinuteSecond();
        return hms == null ? null : new Date(0, 0, 1, hms.getHour(), hms.getMinuteOfHour(), hms.getSecondOfMinute());
    }

    @Deprecated
    public void setEndDate(Date date) {
        if (date == null) {
            this.setEndDateHourMinuteSecond(null);
        } else {
            this.setEndDateHourMinuteSecond(HourMinuteSecond.fromDateFields(date));
        }
    }

    @Deprecated
    public Date getEnrollmentBeginDayDate() {
        YearMonthDay ymd = this.getEnrollmentBeginDayDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setEnrollmentBeginDayDate(Date date) {
        if (date == null) {
            this.setEnrollmentBeginDayDateYearMonthDay(null);
        } else {
            this.setEnrollmentBeginDayDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getEnrollmentBeginTimeDate() {
        HourMinuteSecond hms = this.getEnrollmentBeginTimeDateHourMinuteSecond();
        return hms == null ? null : new Date(0, 0, 1, hms.getHour(), hms.getMinuteOfHour(), hms.getSecondOfMinute());
    }

    @Deprecated
    public void setEnrollmentBeginTimeDate(Date date) {
        if (date == null) {
            this.setEnrollmentBeginTimeDateHourMinuteSecond(null);
        } else {
            this.setEnrollmentBeginTimeDateHourMinuteSecond(HourMinuteSecond.fromDateFields(date));
        }
    }

    @Deprecated
    public Date getEnrollmentEndDayDate() {
        YearMonthDay ymd = this.getEnrollmentEndDayDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setEnrollmentEndDayDate(Date date) {
        if (date == null) {
            this.setEnrollmentEndDayDateYearMonthDay(null);
        } else {
            this.setEnrollmentEndDayDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getEnrollmentEndTimeDate() {
        HourMinuteSecond hms = this.getEnrollmentEndTimeDateHourMinuteSecond();
        return hms == null ? null : new Date(0, 0, 1, hms.getHour(), hms.getMinuteOfHour(), hms.getSecondOfMinute());
    }

    @Deprecated
    public void setEnrollmentEndTimeDate(Date date) {
        if (date == null) {
            this.setEnrollmentEndTimeDateHourMinuteSecond(null);
        } else {
            this.setEnrollmentEndTimeDateHourMinuteSecond(HourMinuteSecond.fromDateFields(date));
        }
    }

    public DateTime getEnrolmentPeriodStart() {
        YearMonthDay yearMonthDay = this.getEnrollmentBeginDayDateYearMonthDay();
        HourMinuteSecond hourMinuteSecond = this.getEnrollmentBeginTimeDateHourMinuteSecond();
        return this.toDateTime(yearMonthDay, hourMinuteSecond);
    }

    public DateTime getEnrolmentPeriodEnd() {
        YearMonthDay yearMonthDay = this.getEnrollmentEndDayDateYearMonthDay();
        HourMinuteSecond hourMinuteSecond = this.getEnrollmentEndTimeDateHourMinuteSecond();
        return this.toDateTime(yearMonthDay, hourMinuteSecond);
    }

    private DateTime toDateTime(YearMonthDay yearMonthDay, HourMinuteSecond hourMinuteSecond) {
        if (yearMonthDay == null || hourMinuteSecond == null) {
            return null;
        }
        return new DateTime(yearMonthDay.getYear(), yearMonthDay.getMonthOfYear(), yearMonthDay.getDayOfMonth(), hourMinuteSecond.getHour(), hourMinuteSecond.getMinuteOfHour(), hourMinuteSecond.getSecondOfMinute(), 0);
    }

    public Interval getInterval() {
        return new Interval((ReadableInstant)this.getBeginningDateTime(), (ReadableInstant)this.getEndDateTime());
    }

    public Date getEvaluationDate() {
        return this.getDayDate();
    }
}

