/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Comparator;
import java.util.Set;
import org.fenixedu.academic.domain.CurricularSemester;
import org.fenixedu.academic.domain.CurricularYear_Base;
import org.fenixedu.bennu.core.domain.Bennu;

public class CurricularYear
extends CurricularYear_Base
implements Comparable<CurricularYear> {
    public static Comparator<CurricularYear> CURRICULAR_YEAR_COMPARATORY_BY_YEAR = new Comparator<CurricularYear>(){

        @Override
        public int compare(CurricularYear o1, CurricularYear o2) {
            return o1.getYear().compareTo(o2.getYear());
        }
    };

    public CurricularYear() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public CurricularYear(Integer year, int numberOfSemesters) {
        this();
        this.setYear(year);
        for (int i = 1; i <= numberOfSemesters; ++i) {
            new CurricularSemester(this, i);
        }
    }

    @Override
    public int compareTo(CurricularYear curricularYear) {
        return this.getYear().compareTo(curricularYear.getYear());
    }

    public CurricularSemester getCurricularSemester(Integer semester) {
        for (CurricularSemester curricularSemester : this.getCurricularSemestersSet()) {
            if (!curricularSemester.getSemester().equals(semester)) continue;
            return curricularSemester;
        }
        return null;
    }

    public static CurricularYear readByYear(Integer year) {
        Set curricularYears = Bennu.getInstance().getCurricularYearsSet();
        for (CurricularYear curricularYear : curricularYears) {
            if (!curricularYear.getYear().equals(year)) continue;
            return curricularYear;
        }
        return null;
    }
}

