/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.bootstrap;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.Installation;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.AdministrativeOfficeServiceAgreementTemplate;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.PartyContactValidationState;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.AggregateUnit;
import org.fenixedu.academic.domain.organizationalStructure.CompetenceCourseGroupUnit;
import org.fenixedu.academic.domain.organizationalStructure.CountryUnit;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.PartyType;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.PlanetUnit;
import org.fenixedu.academic.domain.organizationalStructure.SchoolUnit;
import org.fenixedu.academic.domain.organizationalStructure.ScientificAreaUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.serviceRequests.InstitutionRegistryCodeGenerator;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestCategory;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.bootstrap.AdminUserBootstrapper;
import org.fenixedu.bennu.core.bootstrap.BootstrapError;
import org.fenixedu.bennu.core.bootstrap.annotations.Bootstrap;
import org.fenixedu.bennu.core.bootstrap.annotations.Bootstrapper;
import org.fenixedu.bennu.core.bootstrap.annotations.Field;
import org.fenixedu.bennu.core.bootstrap.annotations.Section;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.portal.domain.PortalBootstrapper;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.spaces.domain.SpaceClassification;
import org.joda.time.YearMonthDay;
import pt.ist.standards.geographic.Country;
import pt.ist.standards.geographic.Planet;

@Bootstrapper(sections={SchoolSetupSection.class, PortalBootstrapper.PortalSection.class, AdminUserBootstrapper.AdminUserSection.class}, name="bootstrapper.name", bundle="resources.ApplicationResources", after={PortalBootstrapper.class})
public class FenixBootstrapper {
    static final Locale PT = new Locale("pt");
    static final Locale EN = new Locale("en");

    @Bootstrap
    public static List<BootstrapError> boostrap(SchoolSetupSection schoolSetupSection, PortalBootstrapper.PortalSection portalSection, AdminUserBootstrapper.AdminUserSection adminSection) {
        if (Planet.getEarth().getByAlfa3(schoolSetupSection.getCountryCode()) == null || !Planet.getEarth().getByAlfa3((String)schoolSetupSection.getCountryCode()).alpha3.equals(schoolSetupSection.getCountryCode())) {
            return Collections.singletonList(new BootstrapError(SchoolSetupSection.class, "getCountryCode", "bootstrapper.error.contry", "resources.ApplicationResources"));
        }
        FenixBootstrapper.createManagerUser(adminSection, schoolSetupSection);
        FenixBootstrapper.createAcademicSpaceClassifications();
        FenixBootstrapper.createPartyTypeEnums();
        FenixBootstrapper.createAccountabilityTypeEnums();
        FenixBootstrapper.createCountries(schoolSetupSection);
        FenixBootstrapper.createCurricularYearsAndSemesters();
        FenixBootstrapper.createDistrictAndDistrictSubdivision();
        FenixBootstrapper.createOrganizationalStructure();
        new CreateOrganizationalStructure().doIt(portalSection, schoolSetupSection);
        FenixBootstrapper.createEmptyDegreeAndEmptyDegreeCurricularPlan();
        FenixBootstrapper.createDefaultRegistrationProtocol();
        Installation installation = Installation.getInstance();
        installation.setInstituitionEmailDomain(schoolSetupSection.getSchoolEmailDomain());
        installation.setInstituitionURL(schoolSetupSection.getSchoolURL());
        if (Bennu.getInstance().getRootClassificationSet().isEmpty()) {
            LocalizedString.Builder schoolSpaces = new LocalizedString.Builder();
            CoreConfiguration.supportedLocales().stream().forEach(l -> schoolSpaces.with(l, "School Spaces"));
            SpaceClassification sc = new SpaceClassification("1", schoolSpaces.build());
            LocalizedString.Builder campus = new LocalizedString.Builder();
            CoreConfiguration.supportedLocales().stream().forEach(l -> campus.with(l, "Campus"));
            sc.addChildren(new SpaceClassification("1.1", campus.build()));
            LocalizedString.Builder building = new LocalizedString.Builder();
            CoreConfiguration.supportedLocales().stream().forEach(l -> building.with(l, "Building"));
            sc.addChildren(new SpaceClassification("1.2", building.build()));
            LocalizedString.Builder floor = new LocalizedString.Builder();
            CoreConfiguration.supportedLocales().stream().forEach(l -> floor.with(l, "Floor"));
            sc.addChildren(new SpaceClassification("1.3", floor.build()));
            LocalizedString.Builder roomSubdivision = new LocalizedString.Builder();
            CoreConfiguration.supportedLocales().stream().forEach(l -> roomSubdivision.with(l, "Room Subdivision"));
            sc.addChildren(new SpaceClassification("1.4", roomSubdivision.build()));
            LocalizedString.Builder room = new LocalizedString.Builder();
            CoreConfiguration.supportedLocales().stream().forEach(l -> room.with(l, "Room"));
            sc.addChildren(new SpaceClassification("1.4", room.build()));
        }
        FenixBootstrapper.createDefaultServiceRequestTypes();
        return Lists.newArrayList();
    }

    private static void createDefaultRegistrationProtocol() {
        LocalizedString description = LocalizedString.fromJson((JsonElement)new JsonParser().parse("{\"pt-PT\":\"Normal\",\"en-GB\":\"Normal\"}"));
        RegistrationProtocol registrationProtocol = new RegistrationProtocol("NORMAL", description, true, true, true, false, false, false, false, false, false, true, false);
    }

    private static void createEmptyDegreeAndEmptyDegreeCurricularPlan() {
    }

    private static void createCurricularYearsAndSemesters() {
        new CurricularYear(1, 2);
        new CurricularYear(2, 2);
        new CurricularYear(3, 2);
        new CurricularYear(4, 2);
        new CurricularYear(5, 2);
        new CurricularYear(6, 2);
    }

    private static org.fenixedu.academic.domain.Country createCountries(SchoolSetupSection schoolSection) {
        org.fenixedu.academic.domain.Country defaultCountry = null;
        for (Country metaData : Planet.getEarth().getPlaces()) {
            String localizedNamePT = null;
            try {
                localizedNamePT = metaData.getLocalizedName(PT);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            String localizedNameEN = null;
            try {
                localizedNameEN = metaData.getLocalizedName(EN);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            if (localizedNameEN == null && localizedNamePT == null) continue;
            if (localizedNamePT == null) {
                localizedNamePT = localizedNameEN;
            }
            if (localizedNameEN == null) {
                localizedNameEN = localizedNamePT;
            }
            String nationalityPT = null;
            try {
                nationalityPT = metaData.getNationality(PT);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            String nationalityEN = null;
            try {
                nationalityEN = metaData.getNationality(EN);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            if (nationalityPT == null) {
                nationalityPT = nationalityEN == null ? localizedNamePT : nationalityEN;
            }
            if (nationalityEN == null) {
                nationalityEN = nationalityPT == null ? localizedNameEN : nationalityPT;
            }
            MultiLanguageString countryName = new MultiLanguageString(MultiLanguageString.pt, localizedNamePT);
            countryName.append(new MultiLanguageString(MultiLanguageString.en, localizedNameEN));
            String code = metaData.alpha2;
            String threeLetterCode = metaData.alpha3;
            org.fenixedu.academic.domain.Country country = new org.fenixedu.academic.domain.Country(countryName, new MultiLanguageString(MultiLanguageString.pt, nationalityPT).append(new MultiLanguageString(MultiLanguageString.en, nationalityEN)), code, threeLetterCode);
            if (!StringUtils.equals((String)threeLetterCode, (String)schoolSection.getCountryCode().toUpperCase())) continue;
            defaultCountry = country;
        }
        defaultCountry.setDefaultCountry(Boolean.TRUE);
        return defaultCountry;
    }

    private static void createDistrictAndDistrictSubdivision() {
    }

    static void createManagerUser(AdminUserBootstrapper.AdminUserSection adminSection, SchoolSetupSection schoolSetupSection) {
        User adminUser = User.findByUsername((String)adminSection.getAdminUsername());
        Person person = new Person(adminUser.getProfile());
        RoleType.grant(RoleType.SCIENTIFIC_COUNCIL, adminUser);
        RoleType.grant(RoleType.SPACE_MANAGER, adminUser);
        RoleType.grant(RoleType.SPACE_MANAGER_SUPER_USER, adminUser);
        RoleType.grant(RoleType.ACADEMIC_ADMINISTRATIVE_OFFICE, adminUser);
        RoleType.grant(RoleType.BOLONHA_MANAGER, adminUser);
        person.setCountry(org.fenixedu.academic.domain.Country.readDefault());
        person.setCountryOfBirth(org.fenixedu.academic.domain.Country.readDefault());
        EmailAddress.createEmailAddress((Party)((Object)person), adminSection.getAdminUserEmail(), PartyContactType.PERSONAL, true, true, true, true);
        for (PartyContact partyContact : person.getPartyContactsSet()) {
            partyContact.setValid();
            partyContact.getPartyContactValidation().setState(PartyContactValidationState.VALID);
        }
        Authenticate.mock((User)adminUser);
        AcademicOperationType.MANAGE_AUTHORIZATIONS.grant(adminUser);
        AcademicOperationType.MANAGE_ACADEMIC_CALENDARS.grant(adminUser);
    }

    private static void createAcademicSpaceClassifications() {
        LocalizedString.Builder campusNameBuilder = new LocalizedString.Builder();
        CoreConfiguration.supportedLocales().stream().forEach(l -> campusNameBuilder.with(l, "Campus"));
        new SpaceClassification("1", campusNameBuilder.build());
    }

    private static void createPartyTypeEnums() {
        for (PartyTypeEnum partyTypeEnum : PartyTypeEnum.values()) {
            new PartyType(partyTypeEnum);
        }
    }

    private static void createAccountabilityTypeEnums() {
        for (AccountabilityTypeEnum accountabilityTypeEnum : AccountabilityTypeEnum.values()) {
            new AccountabilityType(accountabilityTypeEnum, new MultiLanguageString(Locale.getDefault(), accountabilityTypeEnum.getName()));
        }
    }

    private static void createOrganizationalStructure() {
        Bennu rootDomainObject = Bennu.getInstance();
        PlanetUnit planetUnit = PlanetUnit.createNewPlanetUnit(new MultiLanguageString(Locale.getDefault(), "Earth"), null, null, "E", new YearMonthDay(), null, null, null, null, false, null);
        rootDomainObject.setEarthUnit((Unit)((Object)planetUnit));
        FenixBootstrapper.createCountryUnits(rootDomainObject, planetUnit);
    }

    private static void createCountryUnits(Bennu rootDomainObject, PlanetUnit planetUnit) {
        for (org.fenixedu.academic.domain.Country country : org.fenixedu.academic.domain.Country.readDistinctCountries()) {
            CountryUnit.createNewCountryUnit(new MultiLanguageString(Locale.getDefault(), country.getName()), null, null, country.getCode(), new YearMonthDay(), null, (Unit)((Object)planetUnit), null, null, false, null);
        }
    }

    private static void createDefaultServiceRequestTypes() {
        for (AcademicServiceRequestType academicServiceRequestType : AcademicServiceRequestType.values()) {
            if (academicServiceRequestType == AcademicServiceRequestType.DOCUMENT) continue;
            if (academicServiceRequestType == AcademicServiceRequestType.DIPLOMA_REQUEST) {
                ServiceRequestType.createLegacy(academicServiceRequestType.name(), new LocalizedString(new Locale("PT", "pt"), academicServiceRequestType.getLocalizedName()), false, academicServiceRequestType, DocumentRequestType.DIPLOMA_REQUEST, true, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, ServiceRequestCategory.SERVICES);
                continue;
            }
            if (academicServiceRequestType == AcademicServiceRequestType.DIPLOMA_SUPPLEMENT_REQUEST) {
                ServiceRequestType.createLegacy(academicServiceRequestType.name(), new LocalizedString(new Locale("PT", "pt"), academicServiceRequestType.getLocalizedName()), false, academicServiceRequestType, DocumentRequestType.DIPLOMA_SUPPLEMENT_REQUEST, true, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, ServiceRequestCategory.SERVICES);
                continue;
            }
            if (academicServiceRequestType == AcademicServiceRequestType.REGISTRY_DIPLOMA_REQUEST) {
                ServiceRequestType.createLegacy(academicServiceRequestType.name(), new LocalizedString(new Locale("PT", "pt"), academicServiceRequestType.getLocalizedName()), false, academicServiceRequestType, DocumentRequestType.REGISTRY_DIPLOMA_REQUEST, true, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, ServiceRequestCategory.SERVICES);
                continue;
            }
            ServiceRequestType.createLegacy(academicServiceRequestType.name(), new LocalizedString(new Locale("PT", "pt"), academicServiceRequestType.getLocalizedName()), false, academicServiceRequestType, null, true, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, ServiceRequestCategory.SERVICES);
        }
        for (Enum enum_ : DocumentRequestType.values()) {
            if (enum_ == DocumentRequestType.DIPLOMA_REQUEST || enum_ == DocumentRequestType.DIPLOMA_SUPPLEMENT_REQUEST || enum_ == DocumentRequestType.REGISTRY_DIPLOMA_REQUEST) continue;
            ServiceRequestType.createLegacy(enum_.name(), BundleUtil.getLocalizedString((String)"resources.EnumerationResources", (String)("DocumentRequestType." + enum_.name()), (String[])new String[0]), false, AcademicServiceRequestType.DOCUMENT, (DocumentRequestType)enum_, true, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, ServiceRequestCategory.SERVICES);
        }
    }

    @Section(name="bootstrapper.schoolSetup.name", description="bootstrapper.schoolSetup.description", bundle="resources.ApplicationResources")
    public static interface SchoolSetupSection {
        @Field(name="bootstrapper.schoolSetup.universityName", hint="bootstrapper.schoolSetup.universityName.hint", order=1)
        public String getUniversityName();

        @Field(name="bootstrapper.schoolSetup.universityAcronym", hint="bootstrapper.schoolSetup.universityAcronym.hint", order=2)
        public String getUniversityAcronym();

        @Field(name="bootstrapper.schoolSetup.schoolAcronym", hint="bootstrapper.schoolSetup.schoolAcronym.hint", order=3)
        public String getSchoolAcronym();

        @Field(name="bootstrapper.schoolSetup.country", hint="bootstrapper.schoolSetup.country.hint", order=4)
        public String getCountryCode();

        @Field(name="bootstrapper.application.schoolDomain", hint="bootstrapper.application.schoolDomain.hint", order=5)
        public String getSchoolDomain();

        @Field(name="bootstrapper.application.schoolUrl", hint="bootstrapper.application.schoolUrl.hint", order=6)
        public String getSchoolURL();

        @Field(name="bootstrapper.application.schoolEmailDomain", hint="bootstrapper.application.schoolEmailDomain.hint", order=7)
        public String getSchoolEmailDomain();
    }

    public static class CreateOrganizationalStructure {
        private int areaCounter = 0;

        public void doIt(PortalBootstrapper.PortalSection portalSection, SchoolSetupSection schoolSetupSection) {
            CountryUnit countryUnit = this.getCountryUnit(org.fenixedu.academic.domain.Country.readDefault().getName());
            UniversityUnit universityUnit = this.createUniversityUnit(countryUnit, schoolSetupSection.getUniversityName(), schoolSetupSection.getUniversityAcronym());
            SchoolUnit institutionUnit = this.createSchoolUnit(universityUnit, portalSection.getOrganizationName(), schoolSetupSection.getSchoolAcronym());
            Bennu.getInstance().setInstitutionUnit((Unit)((Object)institutionUnit));
            this.setRegistryGenerator(institutionUnit);
            AggregateUnit serviceUnits = this.createAggregateUnit((Unit)((Object)institutionUnit), "Services");
            AggregateUnit departmentUnits = this.createAggregateUnit((Unit)((Object)institutionUnit), "Departments");
            AggregateUnit degreeUnits = this.createAggregateUnit((Unit)((Object)institutionUnit), "Degrees");
        }

        private void setRegistryGenerator(SchoolUnit institutionUnit) {
            institutionUnit.setRegistryCodeGenerator(new InstitutionRegistryCodeGenerator());
        }

        private CountryUnit getCountryUnit(String countryUnitName) {
            for (Party party : Bennu.getInstance().getPartysSet()) {
                CountryUnit countryUnit;
                if (!party.isCountryUnit() || !(countryUnit = (CountryUnit)((Object)party)).getName().equalsIgnoreCase(countryUnitName)) continue;
                return countryUnit;
            }
            return null;
        }

        private UniversityUnit createUniversityUnit(CountryUnit countryUnit, String universityName, String universityAcronym) {
            return UniversityUnit.createNewUniversityUnit(new MultiLanguageString(Locale.getDefault(), universityName), null, null, universityAcronym, new YearMonthDay(), null, (Unit)((Object)countryUnit), null, null, false, null);
        }

        private AggregateUnit createAggregateUnit(Unit parentUnit, String unitName) {
            return AggregateUnit.createNewAggregateUnit(new MultiLanguageString(Locale.getDefault(), unitName), null, null, null, new YearMonthDay(), null, parentUnit, AccountabilityType.readByType(AccountabilityTypeEnum.ORGANIZATIONAL_STRUCTURE), null, null, Boolean.FALSE, null);
        }

        private SchoolUnit createSchoolUnit(UniversityUnit universityUnit, String universityName, String universityAcronym) {
            return SchoolUnit.createNewSchoolUnit(new MultiLanguageString(Locale.getDefault(), universityName), null, null, universityAcronym, new YearMonthDay(), null, (Unit)((Object)universityUnit), null, null, Boolean.FALSE, null);
        }

        private void createServiceUnits(AggregateUnit serviceUnits) {
            AdministrativeOffice administrativeOffice = new AdministrativeOffice();
            Unit.createNewUnit(new MultiLanguageString(Locale.getDefault(), "Office"), null, null, null, new YearMonthDay(), null, (Unit)((Object)serviceUnits), AccountabilityType.readByType(AccountabilityTypeEnum.ADMINISTRATIVE_STRUCTURE), null, null, administrativeOffice, Boolean.FALSE, null);
            new AdministrativeOfficeServiceAgreementTemplate(administrativeOffice);
        }

        private void createDepartmentUnits(AggregateUnit departmentUnits) {
            for (int i = 0; i < 5; ++i) {
                this.createDepartment(departmentUnits, i);
            }
        }

        private void createDepartment(AggregateUnit departmentUnits, int i) {
            Department department = new Department();
            department.setCode(this.getDepartmentCode(i));
            String departmentName = this.getDepartmentName(i);
            department.setName(departmentName);
            department.setRealName(departmentName);
            department.setCompetenceCourseMembersGroup(this.getCompetenceCourseMembersGroup());
            DepartmentUnit departmentUnit = this.createDepartmentUnut(departmentUnits, 3020 + i, department);
            department.setDepartmentUnit(departmentUnit);
            this.createCompetenceCourseGroupUnit(departmentUnit);
        }

        private void createCompetenceCourseGroupUnit(DepartmentUnit departmentUnit) {
            ScientificAreaUnit scientificAreaUnit = ScientificAreaUnit.createNewInternalScientificArea(new MultiLanguageString(Locale.getDefault(), "Scientific Area"), null, null, "Code" + this.areaCounter++, new YearMonthDay(), null, (Unit)((Object)departmentUnit), AccountabilityType.readByType(AccountabilityTypeEnum.ACADEMIC_STRUCTURE), null, null, Boolean.FALSE, null);
            CompetenceCourseGroupUnit.createNewInternalCompetenceCourseGroupUnit(new MultiLanguageString(Locale.getDefault(), "Competence Courses"), null, null, null, new YearMonthDay(), null, (Unit)((Object)scientificAreaUnit), AccountabilityType.readByType(AccountabilityTypeEnum.ACADEMIC_STRUCTURE), null, null, Boolean.FALSE, null);
        }

        private DepartmentUnit createDepartmentUnut(AggregateUnit departmentUnits, int someNumber, Department department) {
            return DepartmentUnit.createNewInternalDepartmentUnit(new MultiLanguageString(Locale.getDefault(), "Department Name " + someNumber), null, 2100 + someNumber, "DU" + someNumber, new YearMonthDay().minusMonths(1), null, (Unit)((Object)departmentUnits), AccountabilityType.readByType(AccountabilityTypeEnum.ACADEMIC_STRUCTURE), null, department, null, Boolean.FALSE, null);
        }

        private Group getCompetenceCourseMembersGroup() {
            return RoleType.TEACHER.actualGroup().or(RoleType.MANAGER.actualGroup());
        }

        private String getDepartmentName(int i) {
            return "Department " + i;
        }

        private String getDepartmentCode(int i) {
            return "DEP" + i;
        }
    }
}

