/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.coordinator.providers;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCourses;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.phd.ManageEnrolmentsBean;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyArrayConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class PhdDegreeCurricularPlansProvider
implements DataProvider {
    public Converter getConverter() {
        return new DomainObjectKeyArrayConverter();
    }

    public Object provide(Object source, Object currentValue) {
        Set programs = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_PHD_ENROLMENT_PERIODS, Authenticate.getUser()).collect(Collectors.toSet());
        ManageEnrolmentsBean bean = (ManageEnrolmentsBean)source;
        ArrayList<DegreeCurricularPlan> result = new ArrayList<DegreeCurricularPlan>();
        for (ExecutionDegree executionDegree : bean.getSemester().getExecutionYear().getExecutionDegreesMatching(DegreeType::isAdvancedSpecializationDiploma)) {
            DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
            if (this.hasEnrolmentPeriod(degreeCurricularPlan, bean.getSemester()) || !programs.contains((Object)degreeCurricularPlan.getDegree().getPhdProgram())) continue;
            result.add(degreeCurricularPlan);
        }
        return result;
    }

    private boolean hasEnrolmentPeriod(DegreeCurricularPlan degreeCurricularPlan, ExecutionSemester semester) {
        return semester.getEnrolmentPeriod(EnrolmentPeriodInCurricularCourses.class, degreeCurricularPlan) != null;
    }
}

