/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.servlet;

import com.sun.mail.smtp.SMTPTransport;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.mail.Session;
import javax.mail.Transport;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServletRequest;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.Installation;
import org.fenixedu.academic.domain.organizationalStructure.UnitNamePart;
import org.fenixedu.academic.service.services.commons.ReadCurrentExecutionPeriod;
import org.fenixedu.academic.servlet.FenixInitializer$callable$contextInitialized;
import org.fenixedu.academic.ui.struts.action.externalServices.PhoneValidationUtils;
import org.fenixedu.bennu.core.rest.Healthcheck;
import org.fenixedu.bennu.core.rest.SystemResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.RequestChecksumFilter;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@WebListener
public class FenixInitializer
implements ServletContextListener {
    private static final Logger logger;
    public static final Advice advice$contextInitialized;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        Object object = advice$contextInitialized.perform((Callable)new FenixInitializer$callable$contextInitialized(this, servletContextEvent));
    }

    static /* synthetic */ void advised$contextInitialized(FenixInitializer this_, ServletContextEvent event) {
        ReadCurrentExecutionPeriod.run();
        Installation.ensureInstallation();
        this_.loadUnitNames();
        this_.startContactValidationServices();
        this_.registerChecksumFilterRules();
        this_.registerHealthchecks();
    }

    private void registerHealthchecks() {
        SystemResource.registerHealthcheck((Healthcheck)new Healthcheck(){

            public String getName() {
                return "SMTP";
            }

            protected Healthcheck.Result check() throws Exception {
                Properties properties = new Properties();
                properties.put("mail.transport.protocol", "smtp");
                Transport transport = Session.getInstance((Properties)properties).getTransport();
                transport.connect(FenixEduAcademicConfiguration.getConfiguration().getMailSmtpHost(), null, null);
                String response = ((SMTPTransport)transport).getLastServerResponse();
                transport.close();
                return Healthcheck.Result.healthy((String)("SMTP server returned response: " + response));
            }
        });
    }

    public void contextDestroyed(ServletContextEvent arg0) {
    }

    private void startContactValidationServices() {
        PhoneValidationUtils.getInstance();
    }

    private void loadUnitNames() {
        long start = System.currentTimeMillis();
        UnitNamePart.find("...PlaceANonExistingUnitNameHere...");
        long end = System.currentTimeMillis();
        logger.debug("Load of all unit names took: " + (end - start) + "ms.");
    }

    private void registerChecksumFilterRules() {
        RequestChecksumFilter.registerFilterRule((RequestChecksumFilter.ChecksumPredicate)new RequestChecksumFilter.ChecksumPredicate(){

            public boolean shouldFilter(HttpServletRequest request) {
                String uri = request.getRequestURI().substring(request.getContextPath().length());
                if (uri.indexOf("home.do") >= 0) {
                    return false;
                }
                if (uri.indexOf("/student/fillInquiries.do") >= 0) {
                    return false;
                }
                if ((uri.indexOf("/teacher/executionCourseForumManagement.do") >= 0 || uri.indexOf("/student/viewExecutionCourseForuns.do") >= 0) && request.getQueryString().indexOf("method=viewThread") >= 0) {
                    return false;
                }
                if (uri.indexOf("notAuthorized.do") >= 0) {
                    return false;
                }
                return uri.indexOf("external/") == -1 && uri.indexOf("login.do") == -1 && uri.indexOf("loginCAS.do") == -1 && uri.indexOf("logoff.do") == -1 && uri.indexOf("publico/") == -1 && uri.indexOf("siteMap.do") == -1;
            }
        });
    }

    static {
        advice$contextInitialized = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        logger = LoggerFactory.getLogger(FenixInitializer.class);
    }
}

