/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import java.util.HashMap;
import java.util.Map;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.reports.GepReportFile;
import org.fenixedu.academic.domain.reports.StatusAndApprovalReportFile_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.dto.student.StudentStatuteBean;
import org.fenixedu.commons.spreadsheet.Spreadsheet;

public class StatusAndApprovalReportFile
extends StatusAndApprovalReportFile_Base {
    public String getJobName() {
        return "Estatutos e aprova\u00e7\u00f5es desde 2003/2004";
    }

    protected String getPrefix() {
        return "statusAndAproval";
    }

    public void renderReport(Spreadsheet spreadsheet) throws Exception {
        spreadsheet.setHeader("n\u00famero aluno");
        spreadsheet.setHeader("ano lectivo");
        spreadsheet.setHeader("semestre");
        this.setDegreeHeaders(spreadsheet);
        spreadsheet.setHeader("estatuto");
        spreadsheet.setHeader("ciclo de estudos");
        spreadsheet.setHeader("regime");
        spreadsheet.setHeader("n\u00famero inscricoes");
        spreadsheet.setHeader("n\u00famero aprovacoes");
        ExecutionSemester firstExecutionSemester = ExecutionYear.readExecutionYearByName("2003/2004").getFirstExecutionPeriod();
        ExecutionSemester lastExecutionSemester = this.getExecutionYear().getLastExecutionPeriod();
        for (Degree degree : Degree.readNotEmptyDegrees()) {
            if (!StatusAndApprovalReportFile.checkDegreeType((DegreeType)this.getDegreeType(), (Degree)degree) || !this.isActive(degree)) continue;
            for (Registration registration : degree.getRegistrationsSet()) {
                if (!registration.isRegistered(this.getExecutionYear())) continue;
                EnrolmentAndAprovalCounterMap map = new EnrolmentAndAprovalCounterMap(firstExecutionSemester, lastExecutionSemester, registration);
                for (Map.Entry entry : map.entrySet()) {
                    ExecutionSemester executionSemester = (ExecutionSemester)entry.getKey();
                    EnrolmentAndAprovalCounter enrolmentAndAprovalCounter = (EnrolmentAndAprovalCounter)entry.getValue();
                    Spreadsheet.Row row = spreadsheet.addRow();
                    row.setCell(registration.getNumber().toString());
                    row.setCell(executionSemester.getExecutionYear().getYear());
                    row.setCell(executionSemester.getSemester().toString());
                    this.setDegreeCells(row, degree);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (StudentStatuteBean studentStatuteBean : registration.getStudent().getStatutes(executionSemester)) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(studentStatuteBean.getStudentStatute().getType().getName().getContent());
                    }
                    row.setCell(stringBuilder.toString());
                    CycleType cycleType = registration.getCycleType(executionSemester.getExecutionYear());
                    row.setCell(cycleType != null ? cycleType.getDescription() : "");
                    row.setCell(registration.getRegimeType(executionSemester.getExecutionYear()).getLocalizedName());
                    row.setCell(Integer.toString(enrolmentAndAprovalCounter.getEnrolments()));
                    row.setCell(Integer.toString(enrolmentAndAprovalCounter.getAprovals()));
                }
            }
        }
    }

    public static class EnrolmentAndAprovalCounterMap
    extends HashMap<ExecutionSemester, EnrolmentAndAprovalCounter> {
        private final ExecutionSemester firstExecutionSemester;
        private final ExecutionSemester lastExecutionSemester;

        public EnrolmentAndAprovalCounterMap(ExecutionSemester firstExecutionSemester, ExecutionSemester lastExecutionSemester) {
            this.firstExecutionSemester = firstExecutionSemester;
            this.lastExecutionSemester = lastExecutionSemester;
        }

        public EnrolmentAndAprovalCounterMap(ExecutionSemester firstExecutionSemester, ExecutionSemester lastExecutionSemester, Registration registration) {
            this(firstExecutionSemester, lastExecutionSemester);
            for (Registration current : GepReportFile.getFullRegistrationPath(registration)) {
                for (StudentCurricularPlan studentCurricularPlan : current.getStudentCurricularPlansSet()) {
                    for (Enrolment enrolment : studentCurricularPlan.getEnrolmentsSet()) {
                        this.count(enrolment);
                    }
                }
                for (RegistrationState state : current.getRegistrationStatesSet()) {
                    if (!state.isActive()) continue;
                    ExecutionSemester first = state.getExecutionYear().getFirstExecutionPeriod();
                    ExecutionSemester second = state.getExecutionYear().getLastExecutionPeriod();
                    if (firstExecutionSemester.isBeforeOrEquals(first) && first.isBeforeOrEquals(lastExecutionSemester)) {
                        this.get(first);
                    }
                    if (!firstExecutionSemester.isBeforeOrEquals(second) || !second.isBeforeOrEquals(lastExecutionSemester)) continue;
                    this.get(second);
                }
            }
        }

        public void count(Enrolment enrolment) {
            ExecutionSemester executionSemester = enrolment.getExecutionPeriod();
            if (this.firstExecutionSemester.isBeforeOrEquals(executionSemester) && executionSemester.isBeforeOrEquals(this.lastExecutionSemester)) {
                EnrolmentAndAprovalCounter enrolmentAndAprovalCounter = this.get(executionSemester);
                enrolmentAndAprovalCounter.count(enrolment);
            }
        }

        @Override
        public EnrolmentAndAprovalCounter get(Object key) {
            EnrolmentAndAprovalCounter enrolmentAndAprovalCounter = (EnrolmentAndAprovalCounter)super.get(key);
            if (enrolmentAndAprovalCounter == null) {
                enrolmentAndAprovalCounter = new EnrolmentAndAprovalCounter();
                this.put((ExecutionSemester)key, enrolmentAndAprovalCounter);
            }
            return enrolmentAndAprovalCounter;
        }
    }

    public static class EnrolmentAndAprovalCounter {
        private int enrolments = 0;
        private int aprovals = 0;

        public void count(Enrolment enrolment) {
            ++this.enrolments;
            if (enrolment.isApproved()) {
                ++this.aprovals;
            }
        }

        public int getEnrolments() {
            return this.enrolments;
        }

        public int getAprovals() {
            return this.aprovals;
        }
    }
}

