/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import java.io.IOException;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.reports.DissertationsWithExternalAffiliationsReportFile_Base;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisEvaluationParticipant;
import org.fenixedu.academic.domain.thesis.ThesisParticipationType;
import org.fenixedu.academic.ui.struts.action.coordinator.thesis.ThesisPresentationState;
import org.fenixedu.commons.spreadsheet.Spreadsheet;

public class DissertationsWithExternalAffiliationsReportFile
extends DissertationsWithExternalAffiliationsReportFile_Base {
    public String getJobName() {
        return "Listagem de disserta\u00e7\u00f5es com afilia\u00e7\u00f5es externas";
    }

    protected String getPrefix() {
        return "disserta\u00e7\u00f5es com afilia\u00e7\u00f5es externas";
    }

    public void renderReport(Spreadsheet spreadsheet) throws IOException {
        this.list(spreadsheet, this.getExecutionYear());
    }

    private void list(Spreadsheet spreadsheet, ExecutionYear executionYear) throws IOException {
        spreadsheet.setName("Dissertacoes " + executionYear.getYear().replace("/", ""));
        spreadsheet.setHeader("Numero aluno");
        spreadsheet.setHeader("Nome aluno");
        spreadsheet.setHeader("Tipo Curso");
        spreadsheet.setHeader("Curso");
        spreadsheet.setHeader("Sigla Curso");
        spreadsheet.setHeader("Tese");
        spreadsheet.setHeader("Estado da tese");
        spreadsheet.setHeader("Affiliacao Orientador");
        spreadsheet.setHeader("Distribuicao Creditos Orientador");
        spreadsheet.setHeader("Affiliacao Corientador");
        spreadsheet.setHeader("Distribuicao Creditos Corientador");
        for (Thesis thesis : this.getRootDomainObject().getThesesSet()) {
            Enrolment enrolment = thesis.getEnrolment();
            ExecutionSemester executionPeriod = enrolment.getExecutionPeriod();
            if (executionPeriod.getExecutionYear() != executionYear) continue;
            ThesisPresentationState thesisPresentationState = ThesisPresentationState.getThesisPresentationState(thesis);
            Degree degree = enrolment.getStudentCurricularPlan().getDegree();
            DegreeType degreeType = degree.getDegreeType();
            Spreadsheet.Row row = spreadsheet.addRow();
            row.setCell(thesis.getStudent().getNumber().toString());
            row.setCell(thesis.getStudent().getPerson().getName());
            row.setCell(degreeType.getName().getContent());
            row.setCell(degree.getPresentationName());
            row.setCell(degree.getSigla());
            row.setCell(thesis.getTitle().getContent());
            row.setCell(thesisPresentationState.getName());
            this.addTeacherRows(thesis, row, ThesisParticipationType.ORIENTATOR);
            this.addTeacherRows(thesis, row, ThesisParticipationType.COORIENTATOR);
        }
    }

    protected void addTeacherRows(Thesis thesis, Spreadsheet.Row row, ThesisParticipationType thesisParticipationType) {
        StringBuilder oasb = new StringBuilder();
        StringBuilder odsb = new StringBuilder();
        for (ThesisEvaluationParticipant thesisEvaluationParticipant : thesis.getAllParticipants(thesisParticipationType)) {
            String affiliation;
            if (oasb.length() > 0) {
                oasb.append(" ");
            }
            if ((affiliation = thesisEvaluationParticipant.getAffiliation()) != null) {
                oasb.append(affiliation);
            } else {
                oasb.append("--");
            }
            if (odsb.length() > 0) {
                odsb.append(" ");
            }
            double credistDistribution = this.getCreditsDistribution(thesisEvaluationParticipant);
            odsb.append(Double.toString(credistDistribution));
        }
        row.setCell(oasb.toString());
        row.setCell(odsb.toString());
    }

    private double getCreditsDistribution(ThesisEvaluationParticipant thesisEvaluationParticipant) {
        Thesis thesis = thesisEvaluationParticipant.getThesis();
        if (!thesis.hasCredits()) {
            return 0.0;
        }
        return thesisEvaluationParticipant.getPercentageDistribution().intValue();
    }
}

