/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.meeting.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeeting;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingBean;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcess;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.PhdMeetingSchedulingActivity;
import org.fenixedu.bennu.core.domain.User;

public class SubmitThesisMeetingMinutes
extends PhdMeetingSchedulingActivity {
    @Override
    protected void activityPreConditions(PhdMeetingSchedulingProcess process2, User userView) {
        if (!process2.isAllowedToManageProcess(userView)) {
            throw new PreConditionNotValidException();
        }
        if (!process2.hasState(PhdMeetingSchedulingProcessStateType.WITHOUT_THESIS_MEETING_REQUEST)) {
            throw new PreConditionNotValidException();
        }
        if (!process2.getThesisProcess().hasState(PhdThesisProcessStateType.WAITING_FOR_THESIS_DISCUSSION_DATE_SCHEDULING)) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdMeetingSchedulingProcess executeActivity(PhdMeetingSchedulingProcess process2, User userView, Object object) {
        PhdMeetingBean bean = (PhdMeetingBean)object;
        PhdMeeting meeting = bean.getMeeting();
        PhdProgramDocumentUploadBean document = bean.getDocument();
        if (document.hasAnyInformation()) {
            meeting.addDocument(document, userView.getPerson());
        }
        if (bean.isToNotify()) {
            // empty if block
        }
        return process2;
    }
}

