/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.access.PhdProcessAccessType;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.alert.PhdReporterReviewAlert;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.ThesisJuryElement;
import org.fenixedu.academic.domain.phd.thesis.activities.PhdThesisActivity;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcess;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class RequestJuryReviews
extends PhdThesisActivity {
    @Override
    protected void activityPreConditions(PhdThesisProcess process2, User userView) {
        if (!process2.isJuryValidated()) {
            throw new PreConditionNotValidException();
        }
        if (process2.hasState(PhdThesisProcessStateType.WAITING_FOR_JURY_REPORTER_FEEDBACK)) {
            throw new PreConditionNotValidException();
        }
        if (!process2.isAllowedToManageProcess(userView)) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdThesisProcess executeActivity(PhdThesisProcess process2, User userView, Object object) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)object;
        if (bean.isToNotify()) {
            this.notifyJuryElements(process2);
            this.sendAlertToJuryElement(process2.getIndividualProgramProcess(), process2.getPresidentJuryElement(), "message.phd.request.jury.reviews.external.access.jury.president.body");
        }
        if (process2.getActiveState() != PhdThesisProcessStateType.WAITING_FOR_JURY_REPORTER_FEEDBACK) {
            process2.createState(PhdThesisProcessStateType.WAITING_FOR_JURY_REPORTER_FEEDBACK, userView.getPerson(), "");
        }
        bean.setThesisProcess(process2);
        if (process2.getMeetingProcess() == null) {
            Process.createNewProcess(userView, PhdMeetingSchedulingProcess.class, (Object)bean);
        }
        return process2;
    }

    private void notifyJuryElements(PhdThesisProcess process2) {
        for (ThesisJuryElement juryElement : process2.getThesisJuryElementsSet()) {
            if (juryElement.isDocumentValidated()) continue;
            if (!juryElement.isInternal()) {
                this.createExternalAccess(juryElement);
            }
            if (juryElement.getReporter().booleanValue()) {
                this.sendInitialAlertToReporter(process2.getIndividualProgramProcess(), juryElement);
                continue;
            }
            this.sendAlertToJuryElement(process2.getIndividualProgramProcess(), juryElement, "message.phd.request.jury.reviews.external.access.jury.body");
        }
        for (ThesisJuryElement juryElement : process2.getThesisJuryElementsSet()) {
            PhdParticipant participant = juryElement.getParticipant();
            if (!juryElement.getReporter().booleanValue()) continue;
            new PhdReporterReviewAlert(process2.getIndividualProgramProcess(), participant);
        }
    }

    private void sendInitialAlertToReporter(PhdIndividualProgramProcess process2, ThesisJuryElement thesisJuryElement) {
        PhdParticipant participant = thesisJuryElement.getParticipant();
        if (!participant.isInternal()) {
            participant.ensureExternalAccess();
        }
        AlertService.AlertMessage subject = AlertService.AlertMessage.create(AlertService.AlertMessage.get("message.phd.request.jury.reviews.external.access.subject", process2.getPhdProgram().getName()), new Object[0]).isKey(false).withPrefix(false);
        AlertService.AlertMessage body = AlertService.AlertMessage.create(AlertService.AlertMessage.get("message.phd.request.jury.reviews.external.access.jury.body", process2.getPerson().getName(), process2.getProcessNumber()) + "\n\n" + AlertService.AlertMessage.get("message.phd.request.jury.reviews.reporter.body", this.getDaysLeftForReview(process2.getThesisProcess())) + "\n\n" + RequestJuryReviews.getAccessInformation(process2, participant, "message.phd.request.jury.reviews.coordinator.access", "message.phd.request.jury.reviews.teacher.access"), new Object[0]).isKey(false).withPrefix(false);
        AlertService.alertParticipants(process2, subject, body, participant);
    }

    private void sendAlertToJuryElement(PhdIndividualProgramProcess process2, ThesisJuryElement thesisJuryElement, String bodyMessage) {
        PhdParticipant participant = thesisJuryElement.getParticipant();
        if (!participant.isInternal()) {
            this.createExternalAccess(thesisJuryElement);
            participant.ensureExternalAccess();
        }
        AlertService.AlertMessage subject = AlertService.AlertMessage.create(AlertService.AlertMessage.get("message.phd.request.jury.reviews.external.access.subject", process2.getPhdProgram().getName()), new Object[0]).isKey(false).withPrefix(false);
        AlertService.AlertMessage body = AlertService.AlertMessage.create(AlertService.AlertMessage.get(bodyMessage, process2.getPerson().getName(), process2.getProcessNumber()) + "\n\n" + RequestJuryReviews.getAccessInformation(process2, participant, "message.phd.request.jury.reviews.coordinator.access", "message.phd.request.jury.reviews.teacher.access") + "\n\n" + AlertService.AlertMessage.get("message.phd.request.jury.external.access.reviews.body", this.getDaysLeftForReview(process2.getThesisProcess())), new Object[0]).isKey(false).withPrefix(false);
        AlertService.alertParticipants(process2, subject, body, participant);
    }

    private void createExternalAccess(ThesisJuryElement juryElement) {
        PhdParticipant participant = juryElement.getParticipant();
        participant.addAccessType(PhdProcessAccessType.JURY_DOCUMENTS_DOWNLOAD);
        if (juryElement.getReporter().booleanValue()) {
            participant.addAccessType(PhdProcessAccessType.JURY_REPORTER_FEEDBACK_UPLOAD);
        }
    }

    private int getDaysLeftForReview(PhdThesisProcess process2) {
        return Days.daysBetween((ReadablePartial)process2.getWhenJuryValidated().plusDays(PhdReporterReviewAlert.getReporterReviewDeadlineDays()), (ReadablePartial)new LocalDate()).getDays();
    }
}

