/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.util.List;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacy.CancelledCandidacySituation;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.NotAdmittedCandidacySituation;
import org.fenixedu.academic.domain.candidacy.RegisteredCandidacySituation;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.academic.domain.phd.PhdProgramProcessState_Base;
import org.fenixedu.academic.domain.phd.candidacy.PHDProgramCandidacy;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.ui.struts.action.phd.PhdProcessStateBean;
import org.joda.time.DateTime;

public class PhdProgramProcessState
extends PhdProgramProcessState_Base {
    private PhdProgramProcessState() {
    }

    public PhdProgramProcessState(PhdIndividualProgramProcess process2, PhdIndividualProgramProcessState type, Person person, String remarks, DateTime stateDate) {
        this();
        this.init(process2, type, person, remarks, stateDate);
        this.updateSituationOnPHDCandidacy();
    }

    public void updateSituationOnPHDCandidacy() {
        PhdIndividualProgramProcess process2 = this.getProcess();
        if (this.getStateDate() == null) {
            throw new DomainException("state.date.null", new String[0]);
        }
        PHDProgramCandidacy candidacy = process2.getCandidacyProcess().getCandidacy();
        Object situation = null;
        switch (this.getType()) {
            case WORK_DEVELOPMENT: {
                situation = new RegisteredCandidacySituation((Candidacy)((Object)candidacy));
                break;
            }
            case NOT_ADMITTED: {
                situation = new NotAdmittedCandidacySituation((Candidacy)((Object)candidacy));
                break;
            }
            case CANCELLED: {
                situation = new CancelledCandidacySituation((Candidacy)((Object)candidacy));
                break;
            }
        }
        if (situation != null) {
            situation.setSituationDate(this.getStateDate());
        }
    }

    public void editStateDate(PhdProcessStateBean bean) {
        super.editStateDate(bean);
        this.getProcess().getStudent().updateStudentRole();
    }

    protected void init(Person person, String remarks, DateTime stateDate) {
        throw new RuntimeException("invoke other init");
    }

    private void init(PhdIndividualProgramProcess process2, PhdIndividualProgramProcessState type, Person person, String remarks, DateTime stateDate) {
        this.check(process2, type);
        this.setProcess(process2);
        super.init(person, remarks, stateDate, (PhdProcessStateType)type);
        this.setType(type);
        if (process2.getStudent() != null) {
            process2.getStudent().updateStudentRole();
        }
    }

    private void check(PhdIndividualProgramProcess process2, PhdIndividualProgramProcessState type) {
        String[] args = new String[]{};
        if (process2 == null) {
            throw new DomainException("error.PhdProgramProcessState.invalid.process", args);
        }
        String[] args1 = new String[]{};
        if (type == null) {
            throw new DomainException("error.PhdProgramProcessState.invalid.type", args1);
        }
        this.checkType(process2, type);
    }

    private void checkType(PhdIndividualProgramProcess process2, PhdIndividualProgramProcessState type) {
        PhdIndividualProgramProcessState currentType = process2.getActiveState();
        if (currentType != null && currentType.equals(type)) {
            throw new PhdDomainOperationException("error.PhdProgramProcessState.equals.previous.state", type.getLocalizedName());
        }
    }

    protected void disconnect() {
        this.setProcess(null);
        super.disconnect();
    }

    public boolean isFlunked() {
        return PhdIndividualProgramProcessState.FLUNKED.equals(this.getType());
    }

    public boolean isSuspended() {
        return PhdIndividualProgramProcessState.SUSPENDED.equals(this.getType());
    }

    public boolean isCanceled() {
        return PhdIndividualProgramProcessState.CANCELLED.equals(this.getType());
    }

    public boolean isConcluded() {
        return PhdIndividualProgramProcessState.CONCLUDED.equals(this.getType());
    }

    public boolean isTransfered() {
        return PhdIndividualProgramProcessState.TRANSFERRED.equals(this.getType());
    }

    public boolean isNotAdmited() {
        return PhdIndividualProgramProcessState.NOT_ADMITTED.equals(this.getType());
    }

    public boolean isCandidacy() {
        return PhdIndividualProgramProcessState.CANDIDACY.equals(this.getType());
    }

    public void delete() {
        Student student = this.getProcess().getStudent();
        this.setProcess(null);
        super.delete();
        if (student != null) {
            student.updateStudentRole();
        }
    }

    public boolean isLast() {
        return this.getProcess().getMostRecentState() == this;
    }

    public static PhdProgramProcessState createWithInferredStateDate(PhdIndividualProgramProcess process2, PhdIndividualProgramProcessState type, Person person, String remarks) {
        DateTime stateDate = null;
        PhdProgramProcessState mostRecentState = process2.getMostRecentState();
        switch (type) {
            case CANDIDACY: {
                if (process2.getCandidacyProcess().getCandidacyDate() == null) {
                    throw new PhdDomainOperationException("error.phd.PhdProgramProcessState.candidacyDate.required", new String[0]);
                }
                stateDate = process2.getCandidacyProcess().getCandidacyDate().toDateTimeAtStartOfDay();
                break;
            }
            case WORK_DEVELOPMENT: {
                if (process2.getMostRecentStateByType(PhdIndividualProgramProcessState.WORK_DEVELOPMENT) != null) {
                    stateDate = mostRecentState.getStateDate().plusMinutes(1);
                    break;
                }
                if (process2.getWhenStartedStudies() == null) {
                    throw new PhdDomainOperationException("error.phd.PhdProgramProcessState.whenStartedStudies.required", new String[0]);
                }
                stateDate = process2.getWhenStartedStudies().toDateTimeAtStartOfDay();
                break;
            }
            case THESIS_DISCUSSION: {
                if (process2.getMostRecentStateByType(PhdIndividualProgramProcessState.THESIS_DISCUSSION) != null) {
                    stateDate = mostRecentState.getStateDate().plusMinutes(1);
                    break;
                }
                if (process2.getThesisProcess().getWhenThesisDiscussionRequired() == null) {
                    throw new PhdDomainOperationException("error.phd.PhdProgramProcessState.whenThesisDiscussionRequired.required", new String[0]);
                }
                stateDate = process2.getThesisProcess().getWhenThesisDiscussionRequired().toDateTimeAtStartOfDay();
                break;
            }
            case TRANSFERRED: {
                stateDate = mostRecentState.getStateDate().plusMinutes(1);
                break;
            }
            case CONCLUDED: {
                if (process2.getLastConclusionProcess() == null) {
                    throw new PhdDomainOperationException("error.phd.PhdProgramProcessState.conclusionProcess.required", new String[0]);
                }
                stateDate = process2.getLastConclusionProcess().getConclusionDate().toDateTimeAtStartOfDay();
                break;
            }
            case NOT_ADMITTED: 
            case CANCELLED: 
            case FLUNKED: 
            case SUSPENDED: {
                stateDate = mostRecentState.getStateDate().plusMinutes(1);
                break;
            }
            default: {
                throw new DomainException("Cant handle this", new String[0]);
            }
        }
        return PhdProgramProcessState.createWithGivenStateDate(process2, type, person, remarks, stateDate);
    }

    public static PhdProgramProcessState createWithGivenStateDate(PhdIndividualProgramProcess process2, PhdIndividualProgramProcessState type, Person person, String remarks, DateTime stateDate) {
        List<PhdIndividualProgramProcessState> stateList = PhdIndividualProgramProcessState.getPossibleNextStates(process2);
        if (!stateList.contains(type)) {
            String expectedStateDescription = PhdProgramProcessState.buildExpectedStatesDescription(stateList);
            throw new PhdDomainOperationException("error.phd.PhdIndividualProgramProcess.invalid.next.state", type.getLocalizedName(), expectedStateDescription);
        }
        return new PhdProgramProcessState(process2, type, person, remarks, stateDate);
    }
}

