/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degree.enrollment;

import java.util.Collection;
import java.util.HashSet;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularCourseEquivalence;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degree.enrollment.NotNeedToEnrollInCurricularCourse_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.bennu.core.domain.Bennu;

public class NotNeedToEnrollInCurricularCourse
extends NotNeedToEnrollInCurricularCourse_Base {
    public NotNeedToEnrollInCurricularCourse() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public NotNeedToEnrollInCurricularCourse(CurricularCourse curricularCourse, StudentCurricularPlan studentCurricularPlan) {
        this();
        this.setCurricularCourse(curricularCourse);
        this.setStudentCurricularPlan(studentCurricularPlan);
    }

    public void delete() {
        this.setStudentCurricularPlan(null);
        this.setCurricularCourse(null);
        this.setRootDomainObject(null);
        this.getEnrolmentsSet().clear();
        this.getExternalEnrolmentsSet().clear();
        super.deleteDomainObject();
    }

    public Double getEctsCredits() {
        if (this.isDueToEquivalence()) {
            return 0.0;
        }
        return this.getCurricularCourse().getEctsCredits();
    }

    private boolean isDueToEquivalence() {
        return this.isDueToOtherEnrolmentEquivalence() || this.isDueToGlobalEquivalence();
    }

    private boolean isDueToGlobalEquivalence() {
        for (CurricularCourseEquivalence curricularCourseEquivalence : this.getCurricularCourse().getCurricularCourseEquivalencesSet()) {
            if (!curricularCourseEquivalence.isSatisfied(this.getRegistration())) continue;
            return true;
        }
        return false;
    }

    private boolean isDueToOtherEnrolmentEquivalence() {
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (!this.getRegistration().hasEnrolments(enrolment)) continue;
            return true;
        }
        return false;
    }

    public Registration getRegistration() {
        return this.getStudentCurricularPlan().getRegistration();
    }

    public Collection<IEnrolment> getIEnrolments() {
        HashSet<IEnrolment> res = new HashSet<IEnrolment>(this.getEnrolmentsSet());
        res.addAll(this.getExternalEnrolmentsSet());
        return res;
    }
}

