/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountType;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.Discount;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventState;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.Event_Base;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeState;
import org.fenixedu.academic.domain.accounting.PaymentMode;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.events.PenaltyExemption;
import org.fenixedu.academic.domain.accounting.paymentCodes.AccountingEventPaymentCode;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.dto.accounting.SibsTransactionDetailDTO;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.DomainObject;

public abstract class Event
extends Event_Base {
    public static final Comparator<Event> COMPARATOR_BY_DATE = new Comparator<Event>(){

        @Override
        public int compare(Event e1, Event e2) {
            int i = e1.getWhenOccured().compareTo((ReadableInstant)e2.getWhenOccured());
            return i == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)e1, (DomainObject)e2) : i;
        }
    };

    protected Event() {
        throw new RuntimeException("Event is deprecated");
    }

    protected void init(EventType eventType, Person person) {
        this.checkParameters(eventType, (Party)((Object)person));
        super.setEventType(eventType);
        super.setParty((Party)((Object)person));
    }

    protected void init(EventType eventType, Party party) {
        this.checkParameters(eventType, party);
        super.setEventType(eventType);
        super.setParty(party);
    }

    private void checkParameters(EventType eventType, Party person) throws DomainException {
        if (eventType == null) {
            throw new DomainException("error.accounting.Event.invalid.eventType", new String[0]);
        }
        if (person == null) {
            throw new DomainException("error.accounting.person.cannot.be.null", new String[0]);
        }
    }

    public boolean isOpen() {
        return super.getEventState() == EventState.OPEN;
    }

    public boolean isInDebt() {
        return this.isOpen();
    }

    public boolean isClosed() {
        return super.getEventState() == EventState.CLOSED;
    }

    public boolean isPayed() {
        return this.isClosed();
    }

    public boolean isCancelled() {
        return super.getEventState() == EventState.CANCELLED;
    }

    public EventState getEventState() {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.Event.dot.not.call.this.method.directly.use.isInState.instead", new String[0]);
    }

    protected EventState getCurrentEventState() {
        return super.getEventState();
    }

    public boolean isInState(EventState eventState) {
        return super.getEventState() == eventState;
    }

    public final Set<Entry> process(User responsibleUser, Collection<EntryDTO> entryDTOs, AccountingTransactionDetailDTO transactionDetail) {
        if (entryDTOs.isEmpty()) {
            throw new DomainException("error.accounting.Event.process.requires.entries.to.be.processed", new String[0]);
        }
        this.checkConditionsToProcessEvent(transactionDetail);
        Set<Entry> result = this.internalProcess(responsibleUser, entryDTOs, transactionDetail);
        this.recalculateState(transactionDetail.getWhenRegistered());
        return result;
    }

    public final Set<Entry> process(User responsibleUser, AccountingEventPaymentCode paymentCode, Money amountToPay, SibsTransactionDetailDTO transactionDetailDTO) {
        this.checkConditionsToProcessEvent(transactionDetailDTO);
        Set<Entry> result = this.internalProcess(responsibleUser, paymentCode, amountToPay, transactionDetailDTO);
        this.recalculateState(transactionDetailDTO.getWhenRegistered());
        return result;
    }

    private void checkConditionsToProcessEvent(AccountingTransactionDetailDTO transactionDetail) {
        if (this.isClosed() && !this.isSibsTransaction(transactionDetail)) {
            throw new DomainException("error.accounting.Event.is.already.closed", new String[0]);
        }
    }

    private boolean isSibsTransaction(AccountingTransactionDetailDTO transactionDetail) {
        return transactionDetail instanceof SibsTransactionDetailDTO;
    }

    protected Set<Entry> internalProcess(User responsibleUser, AccountingEventPaymentCode paymentCode, Money amountToPay, SibsTransactionDetailDTO transactionDetail) {
        throw new UnsupportedOperationException("error.org.fenixedu.academic.domain.accounting.Event.operation.not.supported");
    }

    protected void closeEvent() {
        this.changeState(EventState.CLOSED, this.hasEventCloseDate() ? this.getEventCloseDate() : new DateTime());
    }

    public AccountingTransaction getLastNonAdjustingAccountingTransaction() {
        if (this.hasAnyNonAdjustingAccountingTransactions()) {
            return Collections.max(this.getNonAdjustingTransactions(), AccountingTransaction.COMPARATOR_BY_WHEN_REGISTERED);
        }
        return null;
    }

    public void addAccountingTransactions(AccountingTransaction accountingTransactions) {
        throw new DomainException("error.accounting.Event.cannot.add.accountingTransactions", new String[0]);
    }

    @Deprecated
    public Set<AccountingTransaction> getAccountingTransactionsSet() {
        return super.getAccountingTransactionsSet();
    }

    public void removeAccountingTransactions(AccountingTransaction accountingTransactions) {
        throw new DomainException("error.accounting.Event.cannot.remove.accountingTransactions", new String[0]);
    }

    public void setEventType(EventType eventType) {
        throw new DomainException("error.accounting.Event.cannot.modify.eventType", new String[0]);
    }

    public void setWhenOccured(DateTime whenOccured) {
        throw new DomainException("error.accounting.Event.cannot.modify.occuredDateTime", new String[0]);
    }

    public void setCreatedBy(String createdBy) {
        throw new DomainException("error.accounting.Event.cannot.modify.createdBy", new String[0]);
    }

    public void setPerson(Person person) {
        throw new DomainException("error.accounting.Event.cannot.modify.person", new String[0]);
    }

    public void setEventState(EventState eventState) {
        throw new DomainException("error.accounting.Event.cannot.modify.eventState", new String[0]);
    }

    public void setResponsibleForCancel(Person responsible) {
        throw new DomainException("error.accounting.Event.cannot.modify.employeeResponsibleForCancel", new String[0]);
    }

    public void setEventStateDate(DateTime eventStateDate) {
        AccessControl.check(this, AcademicPredicates.MANAGE_PAYMENTS);
        super.setEventStateDate(eventStateDate);
    }

    protected boolean canCloseEvent(DateTime whenRegistered) {
        return this.calculateAmountToPay(whenRegistered).lessOrEqualThan(Money.ZERO);
    }

    public Set<Entry> getPositiveEntries() {
        HashSet<Entry> result = new HashSet<Entry>();
        for (AccountingTransaction transaction : this.getNonAdjustingTransactions()) {
            if (!transaction.getToAccountEntry().getAmountWithAdjustment().isPositive()) continue;
            result.add(transaction.getToAccountEntry());
        }
        return result;
    }

    public Set<Entry> getEntriesWithoutReceipt() {
        HashSet<Entry> result = new HashSet<Entry>();
        for (AccountingTransaction transaction : this.getNonAdjustingTransactions()) {
            Entry entry;
            if (!transaction.isSourceAccountFromParty((Party)((Object)this.getPerson())) || (entry = transaction.getToAccountEntry()).isAssociatedToAnyActiveReceipt() || !entry.isAmountWithAdjustmentPositive()) continue;
            result.add(entry);
        }
        return result;
    }

    public List<AccountingTransaction> getNonAdjustingTransactions() {
        ArrayList<AccountingTransaction> result = new ArrayList<AccountingTransaction>();
        for (AccountingTransaction transaction : super.getAccountingTransactionsSet()) {
            if (transaction.isAdjustingTransaction() || !transaction.getAmountWithAdjustment().isPositive()) continue;
            result.add(transaction);
        }
        return result;
    }

    public List<AccountingTransaction> getAllAdjustedAccountingTransactions() {
        ArrayList<AccountingTransaction> result = new ArrayList<AccountingTransaction>();
        for (AccountingTransaction transaction : super.getAccountingTransactionsSet()) {
            if (!transaction.isAdjustingTransaction()) continue;
            result.add(transaction);
        }
        return result;
    }

    public List<AccountingTransaction> getAdjustedTransactions() {
        ArrayList<AccountingTransaction> result = new ArrayList<AccountingTransaction>();
        for (AccountingTransaction transaction : super.getAccountingTransactionsSet()) {
            if (transaction.isAdjustingTransaction()) continue;
            result.add(transaction);
        }
        return result;
    }

    public List<AccountingTransaction> getSortedNonAdjustingTransactions() {
        List<AccountingTransaction> result = this.getNonAdjustingTransactions();
        Collections.sort(result, AccountingTransaction.COMPARATOR_BY_WHEN_REGISTERED);
        return result;
    }

    public boolean hasNonAdjustingAccountingTransactions(AccountingTransaction accountingTransactions) {
        return this.getNonAdjustingTransactions().contains((Object)accountingTransactions);
    }

    public boolean hasAnyNonAdjustingAccountingTransactions() {
        return !this.getNonAdjustingTransactions().isEmpty();
    }

    public boolean hasAnyPayments() {
        return this.hasAnyNonAdjustingAccountingTransactions();
    }

    public Money getPayedAmount() {
        return this.getPayedAmount(null);
    }

    public Money getPayedAmountFor(EntryType entryType) {
        if (this.isCancelled()) {
            throw new DomainException("error.accounting.Event.cannot.calculatePayedAmount.on.invalid.events", new String[0]);
        }
        Money payedAmount = Money.ZERO;
        for (AccountingTransaction transaction : this.getNonAdjustingTransactions()) {
            if (!transaction.getToAccountEntry().getEntryType().equals((Object)entryType)) continue;
            payedAmount = payedAmount.add(transaction.getToAccountEntry().getAmountWithAdjustment());
        }
        return payedAmount;
    }

    public Money getPayedAmount(DateTime until) {
        if (this.isCancelled()) {
            throw new DomainException("error.accounting.Event.cannot.calculatePayedAmount.on.invalid.events", new String[0]);
        }
        Money payedAmount = Money.ZERO;
        for (AccountingTransaction transaction : this.getNonAdjustingTransactions()) {
            if (until != null && transaction.getWhenRegistered().isAfter((ReadableInstant)until)) continue;
            payedAmount = payedAmount.add(transaction.getToAccountEntry().getAmountWithAdjustment());
        }
        return payedAmount;
    }

    public Money getPayedAmountBetween(DateTime startDate, DateTime endDate) {
        if (this.isCancelled()) {
            throw new DomainException("error.accounting.Event.cannot.calculatePayedAmountBetween.on.invalid.events", new String[0]);
        }
        Money payedAmount = Money.ZERO;
        for (AccountingTransaction transaction : this.getNonAdjustingTransactions()) {
            if (transaction.getWhenRegistered().isBefore((ReadableInstant)startDate) || transaction.getWhenRegistered().isAfter((ReadableInstant)endDate)) continue;
            payedAmount = payedAmount.add(transaction.getToAccountEntry().getAmountWithAdjustment());
        }
        return payedAmount;
    }

    private Money getPayedAmountUntil(int civilYear) {
        if (this.isCancelled()) {
            throw new DomainException("error.accounting.Event.cannot.calculatePayedAmountUntil.on.invalid.events", new String[0]);
        }
        Money result = Money.ZERO;
        for (AccountingTransaction transaction : this.getNonAdjustingTransactions()) {
            if (transaction.getWhenRegistered().getYear() > civilYear) continue;
            result = result.add(transaction.getToAccountEntry().getAmountWithAdjustment());
        }
        return result;
    }

    public Money getPayedAmountFor(int civilYear) {
        if (this.isCancelled()) {
            throw new DomainException("error.accounting.Event.cannot.calculatePayedAmount.on.invalid.events", new String[0]);
        }
        Money amountForCivilYear = Money.ZERO;
        for (AccountingTransaction accountingTransaction : this.getNonAdjustingTransactions()) {
            if (!accountingTransaction.isPayed(civilYear)) continue;
            amountForCivilYear = amountForCivilYear.add(accountingTransaction.getToAccountEntry().getAmountWithAdjustment());
        }
        return amountForCivilYear;
    }

    public Money getMaxDeductableAmountForLegalTaxes(int civilYear) {
        if (this.isCancelled()) {
            throw new DomainException("error.accounting.Event.cannot.calculate.max.deductable.amount.for.legal.taxes.on.invalid.events", new String[0]);
        }
        if (this.isOpen() || !this.hasEventCloseDate()) {
            return this.calculatePayedAmountByPersonFor(civilYear);
        }
        Money maxAmountForCivilYear = this.calculateTotalAmountToPay(this.getEventCloseDate()).subtract(this.getPayedAmountUntil(civilYear - 1)).subtract(this.calculatePayedAmountByOtherPartiesFor(civilYear));
        if (maxAmountForCivilYear.isPositive()) {
            Money payedAmoutForPersonOnCivilYear = this.calculatePayedAmountByPersonFor(civilYear);
            return payedAmoutForPersonOnCivilYear.lessOrEqualThan(maxAmountForCivilYear) ? payedAmoutForPersonOnCivilYear : maxAmountForCivilYear;
        }
        return Money.ZERO;
    }

    private Money calculatePayedAmountByPersonFor(int civilYear) {
        Money result = Money.ZERO;
        for (AccountingTransaction transaction : this.getNonAdjustingTransactions()) {
            if (!transaction.isPayed(civilYear) || !transaction.isSourceAccountFromParty((Party)((Object)this.getPerson()))) continue;
            result = result.add(transaction.getToAccountEntry().getAmountWithAdjustment());
        }
        return result;
    }

    public boolean hasPaymentsByPersonForCivilYear(int civilYear) {
        for (AccountingTransaction transaction : this.getNonAdjustingTransactions()) {
            if (!transaction.isSourceAccountFromParty((Party)((Object)this.getPerson())) || !transaction.isPayed(civilYear)) continue;
            return true;
        }
        return false;
    }

    private Money calculatePayedAmountByOtherPartiesFor(int civilYear) {
        Money result = Money.ZERO;
        for (AccountingTransaction transaction : this.getNonAdjustingTransactions()) {
            if (!transaction.isPayed(civilYear) || transaction.isSourceAccountFromParty((Party)((Object)this.getPerson()))) continue;
            result = result.add(transaction.getToAccountEntry().getAmountWithAdjustment());
        }
        return result;
    }

    public boolean hasPaymentsForCivilYear(int civilYear) {
        for (AccountingTransaction accountingTransaction : this.getNonAdjustingTransactions()) {
            if (!accountingTransaction.isPayed(civilYear)) continue;
            return true;
        }
        return false;
    }

    public final void recalculateState(DateTime whenRegistered) {
        if (this.isCancelled()) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.Event.cannot.recalculate.state.on.cancelled.events", new String[0]);
        }
        this.internalRecalculateState(whenRegistered);
    }

    protected void internalRecalculateState(DateTime whenRegistered) {
        DateTime previousStateDate = this.getEventStateDate();
        EventState previousState = super.getEventState();
        if (this.isOpen()) {
            if (this.canCloseEvent(whenRegistered)) {
                this.closeNonProcessedCodes();
                this.closeEvent();
            }
        } else if (!this.canCloseEvent(this.hasEventCloseDate() ? this.getEventCloseDate() : whenRegistered)) {
            this.changeState(EventState.OPEN, new DateTime());
            this.reopenCancelledCodes();
        }
        if (previousState == super.getEventState()) {
            super.setEventStateDate(previousStateDate);
        }
    }

    protected void reopenCancelledCodes() {
        for (AccountingEventPaymentCode paymentCode : this.getCancelledPaymentCodes()) {
            paymentCode.setState(PaymentCodeState.NEW);
        }
    }

    protected void closeNonProcessedCodes() {
        for (AccountingEventPaymentCode paymentCode : this.getNonProcessedPaymentCodes()) {
            paymentCode.setState(PaymentCodeState.CANCELLED);
        }
    }

    public Money calculateAmountToPay(DateTime whenRegistered) {
        Money totalAmountToPay = this.calculateTotalAmountToPay(whenRegistered);
        if (totalAmountToPay == null) {
            return Money.ZERO;
        }
        Money remainingAmount = totalAmountToPay.subtract(this.getPayedAmount(whenRegistered));
        return remainingAmount.isPositive() ? remainingAmount : Money.ZERO;
    }

    private Money calculateTotalAmountToPay(DateTime whenRegistered) {
        return this.getPostingRule().calculateTotalAmountToPay(this, whenRegistered);
    }

    public Money getAmountToPay() {
        return this.calculateAmountToPay(new DateTime());
    }

    public Money getTotalAmountToPay(DateTime whenRegistered) {
        Money totalAmountToPay = this.calculateTotalAmountToPay(whenRegistered);
        return totalAmountToPay;
    }

    public Money getTotalAmountToPay() {
        return this.getTotalAmountToPay(new DateTime());
    }

    public Money getOriginalAmountToPay() {
        return this.getTotalAmountToPay(this.getWhenOccured().plusSeconds(1));
    }

    public List<EntryDTO> calculateEntries() {
        return this.calculateEntries(new DateTime());
    }

    public List<EntryDTO> calculateEntries(DateTime when) {
        return this.getPostingRule().calculateEntries(this, when);
    }

    public void open() {
        this.changeState(EventState.OPEN, new DateTime());
        super.setResponsibleForCancel(null);
        super.setCancelJustification(null);
    }

    public void cancel(Person responsible) {
        this.cancel(responsible, null);
    }

    public void cancel(Person responsible, String cancelJustification) {
        if (this.isCancelled()) {
            return;
        }
        this.checkRulesToCancel(responsible);
        this.changeState(EventState.CANCELLED, new DateTime());
        super.setResponsibleForCancel(responsible);
        super.setCancelJustification(cancelJustification);
        this.closeNonProcessedCodes();
    }

    public void cancel(String cancelJustification) {
        if (this.isCancelled()) {
            return;
        }
        if (this.getPayedAmount().isPositive()) {
            throw new DomainException("error.accounting.Event.cannot.cancel.events.with.payed.amount.greater.than.zero", new String[0]);
        }
        this.changeState(EventState.CANCELLED, new DateTime());
        super.setCancelJustification(cancelJustification);
        this.closeNonProcessedCodes();
    }

    private void checkRulesToCancel(Person responsible) {
        if (!RoleType.MANAGER.isMember(responsible.getUser()) && !this.isOpen()) {
            throw new DomainException("error.accounting.Event.only.open.events.can.be.cancelled", new String[0]);
        }
        if (this.getPayedAmount().isPositive()) {
            throw new DomainException("error.accounting.Event.cannot.cancel.events.with.payed.amount.greater.than.zero", new String[0]);
        }
    }

    protected Set<Entry> internalProcess(User responsibleUser, Collection<EntryDTO> entryDTOs, AccountingTransactionDetailDTO transactionDetail) {
        return this.getPostingRule().process(responsibleUser, entryDTOs, this, this.getFromAccount(), this.getToAccount(), transactionDetail);
    }

    public boolean hasInstallments() {
        return false;
    }

    public List<AccountingEventPaymentCode> calculatePaymentCodes() {
        return this.getAllPaymentCodes().isEmpty() ? this.createPaymentCodes() : this.updatePaymentCodes();
    }

    protected List<AccountingEventPaymentCode> updatePaymentCodes() {
        return Collections.EMPTY_LIST;
    }

    protected List<AccountingEventPaymentCode> createPaymentCodes() {
        return Collections.EMPTY_LIST;
    }

    public List<AccountingEventPaymentCode> getNonProcessedPaymentCodes() {
        ArrayList<AccountingEventPaymentCode> result = new ArrayList<AccountingEventPaymentCode>();
        for (AccountingEventPaymentCode paymentCode : super.getPaymentCodesSet()) {
            if (!paymentCode.isNew()) continue;
            result.add(paymentCode);
        }
        return result;
    }

    public boolean hasNonProcessedPaymentCodes() {
        for (AccountingEventPaymentCode paymentCode : super.getPaymentCodesSet()) {
            if (!paymentCode.isNew()) continue;
            return true;
        }
        return false;
    }

    public List<AccountingEventPaymentCode> getCancelledPaymentCodes() {
        ArrayList<AccountingEventPaymentCode> result = new ArrayList<AccountingEventPaymentCode>();
        for (AccountingEventPaymentCode paymentCode : super.getPaymentCodesSet()) {
            if (!paymentCode.isCancelled()) continue;
            result.add(paymentCode);
        }
        return result;
    }

    public Set<AccountingEventPaymentCode> getAllPaymentCodes() {
        return Collections.unmodifiableSet(super.getPaymentCodesSet());
    }

    public void addPaymentCodes(AccountingEventPaymentCode paymentCode) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.Event.cannot.add.paymentCode", new String[0]);
    }

    @Deprecated
    public Set<AccountingEventPaymentCode> getPaymentCodesSet() {
        return super.getPaymentCodesSet();
    }

    public void removePaymentCodes(AccountingEventPaymentCode paymentCode) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.Event.cannot.remove.paymentCode", new String[0]);
    }

    public static List<Event> readNotCancelled() {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event event : Bennu.getInstance().getAccountingEventsSet()) {
            if (event.isCancelled()) continue;
            result.add(event);
        }
        return result;
    }

    public PaymentCodeState getPaymentCodeStateFor(PaymentMode paymentMode) {
        return paymentMode == PaymentMode.ATM ? PaymentCodeState.PROCESSED : PaymentCodeState.CANCELLED;
    }

    public LabelFormatter getDescription() {
        LabelFormatter result = new LabelFormatter();
        result.appendLabel(this.getEventType().getQualifiedName(), "resources.EnumerationResources");
        return result;
    }

    protected YearMonthDay calculateNextEndDate(YearMonthDay yearMonthDay) {
        YearMonthDay nextMonth = yearMonthDay.plusMonths(1);
        return new YearMonthDay(nextMonth.getYear(), nextMonth.getMonthOfYear(), 1).minusDays(1);
    }

    public Money getReimbursableAmount() {
        if (!this.isClosed() || !this.hasEventCloseDate()) {
            return Money.ZERO;
        }
        Money extraPayedAmount = this.getPayedAmount().subtract(this.calculateTotalAmountToPay(this.getEventCloseDate()));
        if (extraPayedAmount.isPositive()) {
            Money amountPayedByPerson = this.calculatePayedAmountByPerson();
            return amountPayedByPerson.lessOrEqualThan(extraPayedAmount) ? amountPayedByPerson : extraPayedAmount;
        }
        return Money.ZERO;
    }

    protected boolean hasEventCloseDate() {
        return this.getEventCloseDate() != null;
    }

    protected DateTime getEventCloseDate() {
        for (AccountingTransaction transaction : this.getSortedNonAdjustingTransactions()) {
            if (!this.canCloseEvent(transaction.getWhenRegistered())) continue;
            return transaction.getWhenRegistered();
        }
        return null;
    }

    private Money calculatePayedAmountByPerson() {
        Money result = Money.ZERO;
        for (AccountingTransaction transaction : this.getNonAdjustingTransactions()) {
            if (!transaction.isSourceAccountFromParty((Party)((Object)this.getPerson()))) continue;
            result = result.add(transaction.getToAccountEntry().getAmountWithAdjustment());
        }
        return result;
    }

    public final void forceChangeState(EventState state, DateTime when) {
        AccessControl.check(this, AcademicPredicates.MANAGE_PAYMENTS);
        this.changeState(state, when);
    }

    protected void changeState(EventState state, DateTime when) {
        super.setEventState(state);
        super.setEventStateDate(when);
    }

    public boolean isOtherPartiesPaymentsSupported() {
        return false;
    }

    public final void addOtherPartyAmount(User responsibleUser, Party party, Money amount, AccountingTransactionDetailDTO transactionDetailDTO) {
        this.getPostingRule().addOtherPartyAmount(responsibleUser, this, party.getAccountBy(AccountType.EXTERNAL), this.getToAccount(), amount, transactionDetailDTO);
        this.recalculateState(transactionDetailDTO.getWhenRegistered());
    }

    public final AccountingTransaction depositAmount(User responsibleUser, Money amount, AccountingTransactionDetailDTO transactionDetailDTO) {
        AccountingTransaction result = this.getPostingRule().depositAmount(responsibleUser, this, this.getParty().getAccountBy(AccountType.EXTERNAL), this.getToAccount(), amount, transactionDetailDTO);
        this.recalculateState(transactionDetailDTO.getWhenRegistered());
        return result;
    }

    public final AccountingTransaction depositAmount(User responsibleUser, Money amount, EntryType entryType, AccountingTransactionDetailDTO transactionDetailDTO) {
        AccountingTransaction result = this.getPostingRule().depositAmount(responsibleUser, this, this.getParty().getAccountBy(AccountType.EXTERNAL), this.getToAccount(), amount, entryType, transactionDetailDTO);
        this.recalculateState(transactionDetailDTO.getWhenRegistered());
        return result;
    }

    public Money calculateOtherPartiesPayedAmount() {
        Money result = Money.ZERO;
        for (AccountingTransaction accountingTransaction : this.getNonAdjustingTransactions()) {
            if (accountingTransaction.isSourceAccountFromParty(this.getParty())) continue;
            result = result.add(accountingTransaction.getToAccountEntry().getAmountWithAdjustment());
        }
        return result;
    }

    public Set<Entry> getOtherPartyEntries() {
        HashSet<Entry> result = new HashSet<Entry>();
        for (AccountingTransaction transaction : this.getNonAdjustingTransactions()) {
            if (transaction.isSourceAccountFromParty((Party)((Object)this.getPerson()))) continue;
            result.add(transaction.getToAccountEntry());
        }
        return result;
    }

    public void rollbackCompletly() {
        AccessControl.check(this, AcademicPredicates.MANAGE_PAYMENTS);
        while (!this.getNonAdjustingTransactions().isEmpty()) {
            this.getNonAdjustingTransactions().iterator().next().delete();
        }
        this.changeState(EventState.OPEN, new DateTime());
        for (PaymentCode paymentCode : this.getExistingPaymentCodes()) {
            paymentCode.setState(PaymentCodeState.NEW);
        }
    }

    public Set<AccountingEventPaymentCode> getExistingPaymentCodes() {
        AccessControl.check(this, AcademicPredicates.MANAGE_PAYMENTS);
        return Collections.unmodifiableSet(super.getPaymentCodesSet());
    }

    protected abstract Account getFromAccount();

    public abstract Account getToAccount();

    public abstract LabelFormatter getDescriptionForEntryType(EntryType var1);

    public abstract PostingRule getPostingRule();

    public final void delete() {
        this.checkRulesToDelete();
        this.disconnect();
    }

    protected void disconnect() {
        while (!super.getPaymentCodesSet().isEmpty()) {
            ((AccountingEventPaymentCode)((Object)super.getPaymentCodesSet().iterator().next())).delete();
        }
        while (!this.getExemptionsSet().isEmpty()) {
            this.getExemptionsSet().iterator().next().delete(false);
        }
        super.setParty(null);
        super.setResponsibleForCancel(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    protected void checkRulesToDelete() {
        if (this.isClosed() || !this.getNonAdjustingTransactions().isEmpty()) {
            throw new DomainException("error.accounting.Event.cannot.delete.because.event.is.already.closed.or.has.transactions.associated", new String[0]);
        }
    }

    public static List<Event> readBy(EventType eventType) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event event : Bennu.getInstance().getAccountingEventsSet()) {
            if (event.getEventType() != eventType) continue;
            result.add(event);
        }
        return result;
    }

    public static List<Event> readWithPaymentsByPersonForCivilYear(int civilYear) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event event : Event.readNotCancelled()) {
            if (!event.hasPaymentsByPersonForCivilYear(civilYear)) continue;
            result.add(event);
        }
        return result;
    }

    public void addExemptions(Exemption exemption) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.Event.cannot.add.exemption", new String[0]);
    }

    public Set<Exemption> getExemptionsSet() {
        return Collections.unmodifiableSet(super.getExemptionsSet());
    }

    public void removeExemptions(Exemption exemption) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.Event.cannot.remove.exemption", new String[0]);
    }

    public boolean isExemptionAppliable() {
        return false;
    }

    public List<PenaltyExemption> getPenaltyExemptions() {
        ArrayList<PenaltyExemption> result = new ArrayList<PenaltyExemption>();
        for (Exemption exemption : this.getExemptionsSet()) {
            if (!(exemption instanceof PenaltyExemption)) continue;
            result.add((PenaltyExemption)((Object)exemption));
        }
        return result;
    }

    public boolean hasAnyPenaltyExemptionsFor(Class type) {
        for (Exemption exemption : this.getExemptionsSet()) {
            if (!((Object)((Object)exemption)).getClass().equals(type)) continue;
            return true;
        }
        return false;
    }

    public List<PenaltyExemption> getPenaltyExemptionsFor(Class type) {
        ArrayList<PenaltyExemption> result = new ArrayList<PenaltyExemption>();
        for (Exemption exemption : this.getExemptionsSet()) {
            if (!((Object)((Object)exemption)).getClass().equals(type)) continue;
            result.add((PenaltyExemption)((Object)exemption));
        }
        return result;
    }

    public DateTime getLastPaymentDate() {
        AccountingTransaction transaction = this.getLastNonAdjustingAccountingTransaction();
        return transaction != null ? transaction.getWhenRegistered() : null;
    }

    public boolean isLetterSent() {
        return this.getWhenSentLetter() != null;
    }

    public void markLetterSent() {
        this.setWhenSentLetter(new LocalDate());
    }

    public void transferPaymentsAndCancel(Person responsible, Event targetEvent, String justification) {
        this.checkConditionsToTransferPaymentsAndCancel(targetEvent);
        for (Entry entryToTransfer : this.getPositiveEntries()) {
            AccountingTransactionDetailDTO transactionDetail = this.createAccountingTransactionDetailForTransfer(entryToTransfer.getAccountingTransaction());
            targetEvent.depositAmount(responsible.getUser(), entryToTransfer.getAmountWithAdjustment(), transactionDetail);
            entryToTransfer.getAccountingTransaction().reimburseWithoutRules(responsible.getUser(), PaymentMode.CASH, entryToTransfer.getAmountWithAdjustment());
        }
        this.cancel(responsible, justification);
    }

    protected void checkConditionsToTransferPaymentsAndCancel(Event targetEvent) {
        if (this.getEventType() != targetEvent.getEventType()) {
            throw new DomainException("error.accounting.Event.events.must.be.compatible", new String[0]);
        }
        if (this.isCancelled()) {
            throw new DomainException("error.accounting.Event.cannot.transfer.payments.from.cancelled.events", new String[0]);
        }
        if (this == targetEvent) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.Event.target.event.must.be.different.from.source", new String[0]);
        }
    }

    private AccountingTransactionDetailDTO createAccountingTransactionDetailForTransfer(AccountingTransaction transaction) {
        String comments = ((Object)((Object)transaction.getEvent())).getClass().getName() + ":" + transaction.getEvent().getExternalId() + "," + ((Object)((Object)transaction)).getClass().getName() + ":" + transaction.getExternalId();
        return new AccountingTransactionDetailDTO(transaction.getTransactionDetail().getWhenRegistered(), PaymentMode.CASH, comments);
    }

    public boolean isNotCancelled() {
        return !this.isCancelled();
    }

    public boolean isAnnual() {
        return false;
    }

    public boolean canApplyReimbursement(Money amount) {
        return this.getReimbursableAmount().greaterOrEqualThan(amount);
    }

    public boolean isPayableOnAdministrativeOffice(AdministrativeOffice administrativeOffice) {
        return false;
    }

    public Set<EntryType> getPossibleEntryTypesForDeposit() {
        return Collections.EMPTY_SET;
    }

    public boolean isDepositSupported() {
        return !this.isCancelled() && !this.getPossibleEntryTypesForDeposit().isEmpty();
    }

    public void addDiscount(Person responsible, Money amount) {
        this.addDiscounts(new Discount(responsible, amount));
    }

    public Money getTotalDiscount() {
        Money result = Money.ZERO;
        for (Discount discount : this.getDiscountsSet()) {
            result = result.add(discount.getAmount());
        }
        return result;
    }

    public boolean isPaymentPlanChangeAllowed() {
        return false;
    }

    public boolean isGratuity() {
        return false;
    }

    public boolean isAcademicServiceRequestEvent() {
        return false;
    }

    public boolean isIndividualCandidacyEvent() {
        return false;
    }

    public boolean isResidenceEvent() {
        return false;
    }

    public boolean isPhdEvent() {
        return false;
    }

    public boolean isDfaRegistrationEvent() {
        return false;
    }

    public boolean isEnrolmentOutOfPeriod() {
        return false;
    }

    public boolean isSpecializationDegreeRegistrationEvent() {
        return false;
    }

    public boolean isFctScholarshipPhdGratuityContribuitionEvent() {
        return false;
    }

    public abstract Unit getOwnerUnit();

    public SortedSet<AccountingTransaction> getSortedTransactionsForPresentation() {
        TreeSet<AccountingTransaction> result = new TreeSet<AccountingTransaction>(AccountingTransaction.COMPARATOR_BY_WHEN_REGISTERED);
        result.addAll(this.getAdjustedTransactions());
        return result;
    }

    public Person getPerson() {
        return (Person)((Object)this.getParty());
    }
}

