/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import com.google.common.collect.Ordering;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.space.LessonSpaceOccupation;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.dto.InfoLesson;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.RAMApplication;
import org.fenixedu.academic.util.HourMinuteSecond;
import org.fenixedu.academic.util.WeekDay;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.SpaceClassification;
import org.joda.time.DateTime;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=RAMApplication.RAMSchedulesApp.class, path="room-schedules", titleKey="link.schedules.listAllByRoom")
@Mapping(path="/viewAllRoomsSchedulesDA", module="resourceAllocationManager")
@Forwards(value={@Forward(name="choose", path="/resourceAllocationManager/choosePavillionsToViewRoomsSchedules.jsp"), @Forward(name="list", path="/resourceAllocationManager/viewAllRoomsSchedules.jsp")})
public class ViewAllRoomsSchedulesDA
extends FenixDispatchAction {
    private static final int WEEKDAY_COUNT = 6;
    private static final int HOUR_COUNT = 32;

    @EntryPoint
    public ActionForward choose(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ChooseBuildingBean bean = (ChooseBuildingBean)this.getRenderedObject();
        if (bean == null) {
            bean = new ChooseBuildingBean();
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("choose");
    }

    public ActionForward list(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ChooseBuildingBean bean = (ChooseBuildingBean)this.getRenderedObject();
        ArrayList<Space> rooms = new ArrayList<Space>();
        for (Space building : bean.getSelectedBuildings()) {
            rooms.addAll(SpaceUtils.getAllActiveSubRoomsForEducation(building));
        }
        ArrayList<RoomLessonsBean> beans = new ArrayList<RoomLessonsBean>();
        for (Space room : rooms) {
            if (StringUtils.isEmpty((String)room.getName())) continue;
            List<Lesson> lessons = SpaceUtils.getAssociatedLessons(room, bean.getAcademicInterval());
            ArrayList<InfoLesson> infoLessons = new ArrayList<InfoLesson>(lessons.size());
            for (Lesson lesson : lessons) {
                infoLessons.add(InfoLesson.newInfoFromDomain(lesson));
            }
            beans.add(new RoomLessonsBean(room, infoLessons));
        }
        request.setAttribute("academicInterval", (Object)bean.getAcademicInterval());
        request.setAttribute("beans", beans);
        return mapping.findForward("list");
    }

    public ActionForward downloadRoomLessonOccupationInfo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ExecutionSemester executionSemester = this.getExecutionSemester(request);
        ExecutionYear executionYear = executionSemester.getExecutionYear();
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=occupationMap" + executionYear.getYear().replace('/', '_') + "_" + executionSemester.getSemester() + ".xls");
        RoomMap occupationMap = new RoomMap();
        Space.getSpaces().forEach(s -> occupationMap.register((Space)s));
        for (ExecutionCourse executionCourse : executionSemester.getAssociatedExecutionCoursesSet()) {
            for (CourseLoad courseLoad : executionCourse.getCourseLoadsSet()) {
                for (Shift shift : courseLoad.getShiftsSet()) {
                    for (Lesson lesson : shift.getAssociatedLessonsSet()) {
                        occupationMap.register(lesson);
                    }
                }
            }
        }
        Spreadsheet spreadsheet = new Spreadsheet("OccupationMap");
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.building", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.identification", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.blueprintNumber", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.doorNumber", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.description", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.classification", (String[])new String[0]));
        DateTime now = new DateTime();
        for (int weekDay = 0; weekDay < 6; ++weekDay) {
            DateTime dateTime = now.withDayOfWeek(weekDay + 1);
            String weekDayString = dateTime.dayOfWeek().getAsText(I18N.getLocale());
            for (int hour = 0; hour < 16; ++hour) {
                spreadsheet.setHeader(weekDayString + " " + (hour + 8) + ":00");
                spreadsheet.setHeader(weekDayString + " " + (hour + 8) + ":30");
            }
        }
        for (Map.Entry entry : occupationMap.entrySet()) {
            Space space = (Space)entry.getKey();
            String identification = space.getName();
            Space building = SpaceUtils.getSpaceBuilding(space);
            String buildingName = building == null ? "" : building.getPresentationName();
            boolean[][] slots = (boolean[][])entry.getValue();
            Spreadsheet.Row row = spreadsheet.addRow();
            row.setCell(buildingName);
            row.setCell(identification == null ? " " : identification);
            String blueprintNumber = this.findClosestBlueprintNumber(space);
            row.setCell(blueprintNumber);
            if (SpaceUtils.isRoom(space)) {
                Optional doorNumber = space.getMetadata("doorNumber");
                Optional description = space.getMetadata("description");
                row.setCell(doorNumber.isPresent() ? (String)doorNumber.get() : " ");
                row.setCell(description.isPresent() ? (String)description.get() : " ");
            } else if (SpaceUtils.isRoomSubdivision(space)) {
                Space room = this.findSurroundingRoom(space);
                if (room == null) {
                    row.setCell(" ");
                    row.setCell(" ");
                } else {
                    Optional doorNumber = space.getMetadata("doorNumber");
                    Optional description = space.getMetadata("description");
                    row.setCell(doorNumber.isPresent() ? (String)doorNumber.get() : " ");
                    row.setCell(description.isPresent() ? (String)description.get() : " ");
                }
            } else {
                row.setCell(" ");
                row.setCell(" ");
            }
            SpaceClassification classification = space.getClassification();
            if (classification == null) {
                row.setCell(" ");
            } else {
                row.setCell(classification.getAbsoluteCode() + " " + classification.getName().getContent());
            }
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 32; ++j) {
                    row.setCell(Boolean.toString(slots[i][j]));
                }
            }
        }
        ServletOutputStream writer = response.getOutputStream();
        spreadsheet.exportToXLSSheet((OutputStream)writer);
        writer.flush();
        response.flushBuffer();
        return null;
    }

    private ExecutionSemester getExecutionSemester(HttpServletRequest request) {
        String academicIntervalString = (String)this.getFromRequest(request, "academicIntervalString");
        AcademicInterval academicInterval = AcademicInterval.getAcademicIntervalFromString(academicIntervalString);
        ExecutionSemester executionSemester = (ExecutionSemester)((Object)ExecutionInterval.getExecutionInterval(academicInterval));
        return executionSemester;
    }

    private String findClosestBlueprintNumber(Space space) {
        if (space == null) {
            return null;
        }
        return space.getBlueprintNumber().isPresent() ? (String)space.getBlueprintNumber().get() : this.findClosestBlueprintNumber(space.getParent());
    }

    private Space findSurroundingRoom(Space space) {
        Space suroundingSpace = space.getParent();
        return suroundingSpace == null ? null : (SpaceUtils.isRoom(space) ? suroundingSpace : this.findSurroundingRoom(suroundingSpace));
    }

    public ActionForward downloadScheduleList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ExecutionSemester executionSemester = this.getExecutionSemester(request);
        Integer semester = executionSemester.getSemester();
        String executionYear = executionSemester.getExecutionYear().getYear();
        Spreadsheet spreadsheet = new Spreadsheet("ScheduleMap");
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.executionPeriod", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.executionYear", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.executionCourse", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.executionDegree", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.curricular.year", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.shift", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.shift.schedule", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.shift.schedule.hasAllocatedRooms", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.teacher.emails", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.comments", (String[])new String[0]));
        for (ExecutionCourse executionCourse : executionSemester.getAssociatedExecutionCoursesSet()) {
            StringBuilder executionDegreeBuilder = new StringBuilder();
            for (ExecutionDegree executionDegree : executionCourse.getExecutionDegrees()) {
                if (executionDegreeBuilder.length() > 0) {
                    executionDegreeBuilder.append("\n");
                }
                executionDegreeBuilder.append(executionDegree.getDegree().getSigla());
            }
            StringBuilder emailBuilder = new StringBuilder();
            for (Professorship professorship : executionCourse.getProfessorshipsSet()) {
                if (emailBuilder.length() > 0) {
                    emailBuilder.append("\n");
                }
                emailBuilder.append(professorship.getPerson().getEmailForSendingEmails());
            }
            for (CourseLoad courseLoad : executionCourse.getCourseLoadsSet()) {
                for (Shift shift : courseLoad.getShiftsSet()) {
                    Object schoolClass2;
                    TreeSet<Integer> curricularYears = new TreeSet<Integer>();
                    for (Object schoolClass2 : shift.getAssociatedClassesSet()) {
                        curricularYears.add(schoolClass2.getAnoCurricular());
                    }
                    StringBuilder curricularYearBuilder = new StringBuilder();
                    schoolClass2 = curricularYears.iterator();
                    while (schoolClass2.hasNext()) {
                        Integer curricularYear = (Integer)schoolClass2.next();
                        if (curricularYearBuilder.length() > 0) {
                            curricularYearBuilder.append(", ");
                        }
                        curricularYearBuilder.append(curricularYear);
                    }
                    Spreadsheet.Row row = spreadsheet.addRow();
                    row.setCell(semester);
                    row.setCell(executionYear);
                    row.setCell(executionCourse.getName());
                    row.setCell(executionDegreeBuilder.toString());
                    row.setCell(curricularYearBuilder.toString());
                    row.setCell(shift.getNome());
                    row.setCell(shift.getLessonPresentationString().replace(';', '\n'));
                    row.setCell(this.hasRoomsAttributed(shift));
                    row.setCell(emailBuilder.toString());
                    row.setCell(shift.getComment() == null ? "" : shift.getComment());
                }
            }
        }
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=scheduleMap" + executionYear.replace('/', '_') + "_" + executionSemester.getSemester() + ".xls");
        ServletOutputStream writer = response.getOutputStream();
        spreadsheet.exportToXLSSheet((OutputStream)writer);
        writer.flush();
        response.flushBuffer();
        return null;
    }

    public ActionForward downloadShiftAttendence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ExecutionSemester executionSemester = this.getExecutionSemester(request);
        String executionYear = executionSemester.getExecutionYear().getYear();
        Spreadsheet spreadsheet = new Spreadsheet("ShiftAttendenceMap");
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.shift", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.executionCourse", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.executionDegree", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.shift.schedule", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.lesson.room", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.number.students.enrolled", (String[])new String[0]));
        for (ExecutionCourse executionCourse : executionSemester.getAssociatedExecutionCoursesSet()) {
            StringBuilder executionDegreeBuilder = new StringBuilder();
            for (ExecutionDegree executionDegree : executionCourse.getExecutionDegrees()) {
                if (executionDegreeBuilder.length() > 0) {
                    executionDegreeBuilder.append("\n");
                }
                executionDegreeBuilder.append(executionDegree.getDegree().getSigla());
            }
            StringBuilder emailBuilder = new StringBuilder();
            for (Professorship professorship : executionCourse.getProfessorshipsSet()) {
                if (emailBuilder.length() > 0) {
                    emailBuilder.append("\n");
                }
                emailBuilder.append(professorship.getPerson().getEmailForSendingEmails());
            }
            for (CourseLoad courseLoad : executionCourse.getCourseLoadsSet()) {
                for (Shift shift : courseLoad.getShiftsSet()) {
                    Spreadsheet.Row row = spreadsheet.addRow();
                    StringBuilder roomBuilder = new StringBuilder();
                    StringBuilder scheduleBuilder = new StringBuilder();
                    if (!shift.getAssociatedLessonsSet().isEmpty()) {
                        Iterator iterator = shift.getAssociatedLessonsSet().iterator();
                        while (iterator.hasNext()) {
                            Lesson lesson = (Lesson)((Object)iterator.next());
                            scheduleBuilder.append(WeekDay.getWeekDay(lesson.getDiaSemana()).getLabelShort());
                            scheduleBuilder.append(" ");
                            scheduleBuilder.append(lesson.getBeginHourMinuteSecond().toString("HH:mm"));
                            scheduleBuilder.append(" - ");
                            scheduleBuilder.append(lesson.getEndHourMinuteSecond().toString("HH:mm"));
                            if (lesson.hasSala()) {
                                roomBuilder.append(lesson.getSala().getName());
                            }
                            if (!iterator.hasNext()) continue;
                            scheduleBuilder.append(" ; ");
                            roomBuilder.append(" ; ");
                        }
                    }
                    row.setCell(shift.getNome());
                    row.setCell(executionCourse.getName());
                    row.setCell(executionDegreeBuilder.toString());
                    row.setCell(scheduleBuilder.toString().replace(';', '\n'));
                    row.setCell(roomBuilder.toString().replace(';', '\n'));
                    row.setCell(Integer.valueOf(shift.getStudentsSet().size()));
                }
            }
        }
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=shiftAttendenceMap" + executionYear.replace('/', '_') + "_" + executionSemester.getSemester() + ".xls");
        ServletOutputStream writer = response.getOutputStream();
        spreadsheet.exportToXLSSheet((OutputStream)writer);
        writer.flush();
        response.flushBuffer();
        return null;
    }

    private String hasRoomsAttributed(Shift shift) {
        if (shift.getAssociatedLessonsSet().isEmpty()) {
            return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.no", (String[])new String[0]);
        }
        for (Lesson lesson : shift.getAssociatedLessonsSet()) {
            if (this.hasRoomsAttributed(lesson)) continue;
            return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.no", (String[])new String[0]);
        }
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.yes", (String[])new String[0]);
    }

    private boolean hasRoomsAttributed(Lesson lesson) {
        return lesson.getSala() != null;
    }

    private static class RoomMap
    extends HashMap<Space, boolean[][]> {
        private RoomMap() {
        }

        @Override
        public boolean[][] get(Object key) {
            boolean[][] value = (boolean[][])super.get(key);
            if (value == null) {
                value = new boolean[6][32];
                this.put((Space)key, value);
            }
            return value;
        }

        public void register(Space allocatableSpace) {
            if (allocatableSpace != null) {
                this.get(allocatableSpace);
            }
        }

        public void register(Lesson lesson) {
            Space allocatableSpace;
            LessonSpaceOccupation lessonSpaceOccupation = lesson.getLessonSpaceOccupation();
            if (lessonSpaceOccupation != null && (allocatableSpace = lessonSpaceOccupation.getRoom()) != null) {
                boolean[][] slots = this.get(allocatableSpace);
                int weekDayOffSet = lesson.getDiaSemana().getDiaSemana() - 2;
                int startOffSet = this.getHourOffSet(lesson.getBeginHourMinuteSecond());
                int endOffSet = this.getHourOffSet(lesson.getEndHourMinuteSecond());
                int i = startOffSet;
                while (i < endOffSet) {
                    slots[weekDayOffSet][i++] = true;
                }
            }
            for (LessonInstance lessonInstance : lesson.getLessonInstancesSet()) {
                Space allocatableSpace2 = lessonInstance.getRoom();
                if (allocatableSpace2 == null) continue;
                boolean[][] slots = this.get(allocatableSpace2);
                int weekDayOffSet = lessonInstance.getBeginDateTime().getDayOfWeek() - 1;
                int startOffSet = this.getHourOffSet(lessonInstance.getBeginDateTime());
                int endOffSet = this.getHourOffSet(lessonInstance.getEndDateTime());
                int i = startOffSet;
                while (i < endOffSet) {
                    slots[weekDayOffSet][i++] = true;
                }
            }
        }

        private int getHourOffSet(HourMinuteSecond hourMinuteSecond) {
            int hour = hourMinuteSecond.getHour();
            int minutes = hourMinuteSecond.getMinuteOfHour();
            int minutesOffSet = minutes < 30 ? 0 : 1;
            return (hour - 8) * 2 + minutesOffSet;
        }

        private int getHourOffSet(DateTime dateTime) {
            int hour = dateTime.getHourOfDay();
            int minutes = dateTime.getMinuteOfHour();
            int minutesOffSet = minutes < 30 ? 0 : 1;
            return (hour - 8) * 2 + minutesOffSet;
        }
    }

    public static class RoomLessonsBean {
        private final Space room;
        private final List<InfoLesson> lessons;

        public RoomLessonsBean(Space room, List<InfoLesson> lessons) {
            this.room = room;
            this.lessons = lessons;
        }

        public Space getRoom() {
            return this.room;
        }

        public List<InfoLesson> getLessons() {
            return this.lessons;
        }
    }

    public static class ChooseBuildingBean
    implements Serializable {
        private static final long serialVersionUID = -663198492313971329L;
        private AcademicInterval academicInterval = AcademicInterval.readDefaultAcademicInterval(AcademicPeriod.SEMESTER);
        private List<Space> selectedBuildings;

        public AcademicInterval getAcademicInterval() {
            return this.academicInterval;
        }

        public void setAcademicInterval(AcademicInterval academicInterval) {
            this.academicInterval = academicInterval;
        }

        public List<Space> getAvailableBuildings() {
            return Ordering.from(SpaceUtils.COMPARATOR_BY_PRESENTATION_NAME).sortedCopy(SpaceUtils.buildings());
        }

        public List<AcademicInterval> getAvailableIntervals() {
            return Ordering.from(AcademicInterval.COMPARATOR_BY_BEGIN_DATE).reverse().sortedCopy(AcademicInterval.readAcademicIntervals(AcademicPeriod.SEMESTER));
        }

        public List<Space> getSelectedBuildings() {
            return this.selectedBuildings;
        }

        public void setSelectedBuildings(List<Space> selectedBuildings) {
            this.selectedBuildings = selectedBuildings;
        }
    }
}

