/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator.thesis;

import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.thesis.Thesis;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public enum ThesisPresentationState {
    UNEXISTING,
    DRAFT,
    SUBMITTED,
    REJECTED,
    APPROVED,
    DOCUMENTS_SUBMITTED,
    DOCUMENTS_CONFIRMED,
    CONFIRMED,
    EVALUATED_1ST,
    EVALUATED,
    UNKNOWN;


    public static ThesisPresentationState getThesisPresentationState(Enrolment enrolment) {
        return ThesisPresentationState.getThesisPresentationState(enrolment.getThesis());
    }

    public static ThesisPresentationState getThesisPresentationState(Thesis thesis) {
        if (thesis == null) {
            return UNEXISTING;
        }
        if (thesis.isRejected()) {
            return REJECTED;
        }
        if (thesis.isDraft()) {
            return DRAFT;
        }
        if (thesis.isSubmitted()) {
            return SUBMITTED;
        }
        if (thesis.isWaitingConfirmation()) {
            if (thesis.getConfirmmedDocuments() == null) {
                return ThesisPresentationState.areAllDocumentsSubmitted(thesis) ? DOCUMENTS_SUBMITTED : APPROVED;
            }
            return DOCUMENTS_CONFIRMED;
        }
        if (thesis.isConfirmed()) {
            return CONFIRMED;
        }
        if (thesis.isEvaluated()) {
            return thesis.isFinalThesis() ? EVALUATED : EVALUATED_1ST;
        }
        return UNKNOWN;
    }

    public static boolean areDocumentsSubmitted(Thesis thesis) {
        ThesisPresentationState state = ThesisPresentationState.getThesisPresentationState(thesis);
        return state == DOCUMENTS_SUBMITTED || state == DOCUMENTS_CONFIRMED || state == CONFIRMED || state == EVALUATED_1ST || state == EVALUATED;
    }

    private static boolean areAllDocumentsSubmitted(Thesis thesis) {
        return thesis.isThesisAbstractInBothLanguages() && thesis.isKeywordsInBothLanguages() && thesis.getExtendedAbstract() != null && thesis.getDissertation() != null && thesis.getDiscussed() != null;
    }

    public String getName() {
        return this.name();
    }

    public boolean isUnexisting() {
        return this == UNEXISTING;
    }

    public boolean isDraft() {
        return this == DRAFT;
    }

    public boolean isSubmitted() {
        return this == SUBMITTED;
    }

    public boolean isRejected() {
        return this == REJECTED;
    }

    public boolean isApproved() {
        return this == APPROVED;
    }

    public boolean isDocumentsSubmitted() {
        return this == DOCUMENTS_SUBMITTED;
    }

    public boolean isDocumentsConfirmed() {
        return this == DOCUMENTS_CONFIRMED;
    }

    public boolean isConfirmed() {
        return this == CONFIRMED;
    }

    public boolean isEvaluated1st() {
        return this == EVALUATED_1ST;
    }

    public boolean isEvaluated() {
        return this == EVALUATED;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public String getBundleLabel() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "." + this.name() + ".label";
    }

    public String getBundleSimpleLabel() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "." + this.name() + ".simple";
    }

    public String getLabel() {
        String simpleLabel = RenderUtils.getResourceString((String)"ENUMERATION_RESOURCES", (String)this.getBundleSimpleLabel());
        String label = RenderUtils.getResourceString((String)"APPLICATION_RESOURCES", (String)this.getBundleLabel());
        return String.format("%s - %s", simpleLabel, label);
    }
}

