/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.task;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.events.AccountingEventsManager;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.task.CreateAdministrativeOfficeFeeEvent$callable$createAdministrativeOfficeFeeEvent;
import org.fenixedu.academic.task.CreateAdministrativeOfficeFeeEvent$callable$createInsuranceEvent;
import org.fenixedu.academic.util.InvocationResult;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Task(englishTitle="CreateAdministrativeOfficeFeeEvent", readOnly=true)
public class CreateAdministrativeOfficeFeeEvent
extends CronTask {
    private int AdministrativeOfficeFee_TOTAL_CREATED = 0;
    private int InsuranceEvent_TOTAL_CREATED = 0;
    public static final Advice advice$createAdministrativeOfficeFeeEvent = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createInsuranceEvent = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    private void createAdministrativeOfficeFeeEvent(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        Object object = advice$createAdministrativeOfficeFeeEvent.perform((Callable)new CreateAdministrativeOfficeFeeEvent$callable$createAdministrativeOfficeFeeEvent(this, studentCurricularPlan, executionYear));
    }

    static /* synthetic */ void advised$createAdministrativeOfficeFeeEvent(CreateAdministrativeOfficeFeeEvent this_, StudentCurricularPlan scp, ExecutionYear executionYear) {
        try {
            InvocationResult result;
            AccountingEventsManager manager = new AccountingEventsManager();
            if (scp.getAdministrativeOffice().isDegree()) {
                result = manager.createAdministrativeOfficeFeeAndInsuranceEvent(scp, executionYear);
            } else if (scp.getAdministrativeOffice().isMasterDegree()) {
                result = manager.createInsuranceEvent(scp, executionYear);
            } else {
                throw new RuntimeException();
            }
            if (result.isSuccess()) {
                ++this_.AdministrativeOfficeFee_TOTAL_CREATED;
            }
        }
        catch (Exception e) {
            this_.taskLog("Exception on student curricular plan with oid : %s\n", new Object[]{scp.getExternalId()});
            e.printStackTrace(this_.getTaskLogWriter());
        }
    }

    private void createInsuranceEvent(Person person, ExecutionYear executionYear) {
        Object object = advice$createInsuranceEvent.perform((Callable)new CreateAdministrativeOfficeFeeEvent$callable$createInsuranceEvent(this, person, executionYear));
    }

    static /* synthetic */ void advised$createInsuranceEvent(CreateAdministrativeOfficeFeeEvent this_, Person person, ExecutionYear executionYear) {
        try {
            AccountingEventsManager manager = new AccountingEventsManager();
            InvocationResult result = manager.createInsuranceEvent(person, executionYear);
            if (result.isSuccess()) {
                ++this_.InsuranceEvent_TOTAL_CREATED;
            }
        }
        catch (Exception e) {
            this_.taskLog("Exception on person with oid : %s\n", new Object[]{person.getExternalId()});
            e.printStackTrace(this_.getTaskLogWriter());
        }
    }

    public void runTask() {
        ExecutionYear executionYear = ExecutionYear.readCurrentExecutionYear();
        block0: for (Student student : Bennu.getInstance().getStudentsSet()) {
            for (Registration registration : student.getRegistrationsSet()) {
                StudentCurricularPlan studentCurricularPlan = registration.getLastStudentCurricularPlan();
                if (studentCurricularPlan == null) continue;
                this.createAdministrativeOfficeFeeEvent(studentCurricularPlan, executionYear);
            }
            if (student.getPerson() == null) continue;
            for (PhdIndividualProgramProcess process2 : student.getPerson().getPhdIndividualProgramProcessesSet()) {
                if (process2.getActiveState() != PhdIndividualProgramProcessState.WORK_DEVELOPMENT) continue;
                this.createInsuranceEvent(student.getPerson(), executionYear);
                continue block0;
            }
        }
        this.taskLog("Created %s AdministrativeOfficeFee events\n", new Object[]{this.AdministrativeOfficeFee_TOTAL_CREATED});
        this.taskLog("Created %s InsuranceEvent events\n", new Object[]{this.InsuranceEvent_TOTAL_CREATED});
    }
}

