/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.accounting;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.Receipt;
import org.fenixedu.academic.report.FenixReport;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public class ReceiptDocument
extends FenixReport {
    private final Receipt receipt;
    private final boolean original;
    private static final long serialVersionUID = 1L;

    public ReceiptDocument(Receipt receipt, boolean original) {
        this.receipt = receipt;
        this.original = original;
        this.fillReport();
    }

    @Override
    protected void fillReport() {
        this.addParameter("ownerUnitPhone", Bennu.getInstance().getInstitutionUnit().getDefaultPhoneNumber());
        this.addParameter("documentIdType", this.receipt.getPerson().getIdDocumentType().getLocalizedName());
        this.addParameter("documentIdNumber", this.receipt.getPerson().getDocumentIdNumber());
        this.addParameter("name", this.receipt.getPerson().getName());
        this.addParameter("number", this.receipt.getNumberWithSeries());
        this.addParameter("year", this.receipt.getYear().toString());
        this.addParameter("secondPrintVersion", this.receipt.isSecondPrintVersion());
        this.addParameter("annulled", this.receipt.isAnnulled());
        this.addParameter("receiptDate", this.receipt.getReceiptDate().toString("dd MMMM yyyy", this.getLocale()));
        this.addParameter("total", this.receipt.getTotalAmount().toPlainString());
        this.addParameter("original", this.original);
        this.addParameter("contributorName", this.receipt.getContributorName());
        this.addParameter("contributorSocialSecurityNumber", Strings.isNullOrEmpty((String)this.receipt.getContributorNumber()) ? " " : this.receipt.getContributorNumber());
        this.addParameter("contributorAddress", this.receipt.getContributorAddress());
        this.addParameter("studentNumber", this.receipt.getPerson().getStudent() != null ? this.receipt.getPerson().getStudent().getNumber().toString() : null);
        this.addDataSourceElements(this.buildEntries());
    }

    private List<ReceiptDocumentEntry> buildEntries() {
        ArrayList<ReceiptDocumentEntry> result = new ArrayList<ReceiptDocumentEntry>();
        TreeSet<Entry> sortedEntries = new TreeSet<Entry>(Entry.COMPARATOR_BY_MOST_RECENT_WHEN_REGISTERED);
        sortedEntries.addAll(this.receipt.getEntriesSet());
        for (Entry entry : sortedEntries) {
            result.add(new ReceiptDocumentEntry(entry.getDescription().toString(), entry.getOriginalAmount().toPlainString()));
        }
        return result;
    }

    @Override
    public String getReportFileName() {
        return "Receipt-" + new DateTime().toString("yyyyMMddHHmmss", this.getLocale());
    }

    public static class ReceiptDocumentEntry {
        private String description;
        private String amount;

        public ReceiptDocumentEntry(String description, String amount) {
            this.description = description;
            this.amount = amount;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getAmount() {
            return this.amount;
        }

        public void setAmount(String amount) {
            this.amount = amount;
        }
    }
}

