/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ExamDateCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.Season;

public class ExamDateCertificate
extends AdministrativeOfficeDocument {
    private static final long serialVersionUID = 1L;

    protected ExamDateCertificate(IDocumentRequest documentRequest) {
        super(documentRequest);
    }

    @Override
    protected DocumentRequest getDocumentRequest() {
        return (DocumentRequest)super.getDocumentRequest();
    }

    @Override
    protected void fillReport() {
        super.fillReport();
        this.addDataSourceElements(this.getExamDateEntries());
        this.fillInstitutionAndStaffFields();
        this.addParameter("name", this.getDocumentRequest().getRegistration().getPerson().getName());
        this.addParameter("studentNumber", this.getStudentNumber());
    }

    private String getStudentNumber() {
        String agreementInformation;
        Registration registration = this.getDocumentRequest().getRegistration();
        if (registration.getRegistrationProtocol().isMilitaryAgreement() && !StringUtils.isEmpty((String)(agreementInformation = registration.getAgreementInformation()))) {
            return registration.getRegistrationProtocol().getCode() + " " + agreementInformation;
        }
        return registration.getStudent().getNumber().toString();
    }

    private List<ExamDateEntry> getExamDateEntries() {
        ArrayList<ExamDateEntry> result = new ArrayList<ExamDateEntry>();
        ExamDateCertificateRequest request = (ExamDateCertificateRequest)((Object)this.getDocumentRequest());
        for (Enrolment enrolment : request.getEnrolmentsSet()) {
            ExamDateEntry entry = new ExamDateEntry();
            entry.setCurricularCourseName(enrolment.getCurricularCourse().getName());
            this.fillFirstSeasonExam(request, enrolment, entry);
            this.fillSecondSeasonExam(request, enrolment, entry);
            this.fillSpecialSeasonExam(request, enrolment, entry);
            result.add(entry);
        }
        return result;
    }

    private void fillSpecialSeasonExam(ExamDateCertificateRequest request, Enrolment enrolment, ExamDateEntry entry) {
        Exam specialSeasonExam = request.getExamFor(enrolment, Season.SPECIAL_SEASON_OBJ);
        if (specialSeasonExam != null) {
            entry.setSpecialSeasonDate(specialSeasonExam.getDayDateYearMonthDay().toString("dd/MM/yyyy", this.getLocale()));
            entry.setSpecialSeasonHour(specialSeasonExam.getBeginningDateHourMinuteSecond().toString("HH:mm"));
        }
    }

    private void fillSecondSeasonExam(ExamDateCertificateRequest request, Enrolment enrolment, ExamDateEntry entry) {
        Exam secondSeasonExam = request.getExamFor(enrolment, Season.SEASON2_OBJ);
        if (secondSeasonExam != null) {
            entry.setSecondSeasonDate(secondSeasonExam.getDayDateYearMonthDay().toString("dd/MM/yyyy", this.getLocale()));
            entry.setSecondSeasonHour(secondSeasonExam.getBeginningDateHourMinuteSecond().toString("HH:mm"));
        }
    }

    private void fillFirstSeasonExam(ExamDateCertificateRequest request, Enrolment enrolment, ExamDateEntry entry) {
        Exam firstSeasonExam = request.getExamFor(enrolment, Season.SEASON1_OBJ);
        if (firstSeasonExam != null) {
            entry.setFirstSeasonDate(firstSeasonExam.getDayDateYearMonthDay().toString("dd/MM/yyyy", this.getLocale()));
            entry.setFirstSeasonHour(firstSeasonExam.getBeginningDateHourMinuteSecond().toString("HH:mm"));
        }
    }

    @Override
    protected boolean showPriceFields() {
        return false;
    }

    @Override
    protected String getDegreeDescription() {
        Registration registration = this.getDocumentRequest().getRegistration();
        DegreeType degreeType = registration.getDegreeType();
        CycleType cycleType = degreeType.hasExactlyOneCycleType() ? degreeType.getCycleType() : registration.getCycleType(this.getExecutionYear());
        return registration.getDegreeDescription(this.getExecutionYear(), cycleType, this.getLocale());
    }

    public static class ExamDateEntry {
        private String curricularCourseName;
        private String firstSeasonDate;
        private String firstSeasonHour;
        private String secondSeasonDate;
        private String secondSeasonHour;
        private String specialSeasonDate;
        private String specialSeasonHour;

        public String getCurricularCourseName() {
            return this.curricularCourseName;
        }

        public void setCurricularCourseName(String curricularCourseName) {
            this.curricularCourseName = curricularCourseName;
        }

        public String getFirstSeasonDate() {
            return this.firstSeasonDate;
        }

        public void setFirstSeasonDate(String firstSeasonDate) {
            this.firstSeasonDate = firstSeasonDate;
        }

        public String getFirstSeasonHour() {
            return this.firstSeasonHour;
        }

        public void setFirstSeasonHour(String firstSeasonHour) {
            this.firstSeasonHour = firstSeasonHour;
        }

        public String getSecondSeasonDate() {
            return this.secondSeasonDate;
        }

        public void setSecondSeasonDate(String secondSeasonDate) {
            this.secondSeasonDate = secondSeasonDate;
        }

        public String getSecondSeasonHour() {
            return this.secondSeasonHour;
        }

        public void setSecondSeasonHour(String secondSeasonHour) {
            this.secondSeasonHour = secondSeasonHour;
        }

        public String getSpecialSeasonDate() {
            return this.specialSeasonDate;
        }

        public void setSpecialSeasonDate(String specialSeasonDate) {
            this.specialSeasonDate = specialSeasonDate;
        }

        public String getSpecialSeasonHour() {
            return this.specialSeasonHour;
        }

        public void setSpecialSeasonHour(String specialSeasonHour) {
            this.specialSeasonHour = specialSeasonHour;
        }

        public Boolean getAnyExamAvailable() {
            return !StringUtils.isEmpty((String)this.specialSeasonDate) && !StringUtils.isEmpty((String)this.specialSeasonHour) || !StringUtils.isEmpty((String)this.secondSeasonDate) && !StringUtils.isEmpty((String)this.secondSeasonHour) || !StringUtils.isEmpty((String)this.firstSeasonDate) && !StringUtils.isEmpty((String)this.firstSeasonHour);
        }
    }
}

