/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.administrativeOffice.externalUnits;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.ExternalCurricularCourse;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.dto.LinkObject;
import org.fenixedu.academic.dto.administrativeOffice.externalUnits.AbstractExternalUnitResultBean;

public class ExternalCurricularCourseResultBean
extends AbstractExternalUnitResultBean {
    private ExternalCurricularCourse externalCurricularCourse;

    public ExternalCurricularCourseResultBean(ExternalCurricularCourse externalCurricularCourse, PartyTypeEnum parentUnitType) {
        this.setExternalCurricularCourse(externalCurricularCourse);
        this.setParentUnitType(parentUnitType);
    }

    public ExternalCurricularCourseResultBean(ExternalCurricularCourse externalCurricularCourse) {
        this(externalCurricularCourse, null);
    }

    public ExternalCurricularCourse getExternalCurricularCourse() {
        return this.externalCurricularCourse;
    }

    public void setExternalCurricularCourse(ExternalCurricularCourse externalCurricularCourse) {
        this.externalCurricularCourse = externalCurricularCourse;
    }

    @Override
    public Unit getUnit() {
        return this.getExternalCurricularCourse().getUnit();
    }

    @Override
    public ExternalDegreeModuleType getType() {
        return ExternalDegreeModuleType.CURRICULAR_COURSE;
    }

    public int getNumberOfExternalEnrolments() {
        return this.getExternalCurricularCourse().getExternalEnrolmentsSet().size();
    }

    @Override
    public List<LinkObject> getFullPath() {
        ArrayList<LinkObject> result = new ArrayList<LinkObject>();
        for (Unit unit : this.searchFullPath()) {
            LinkObject linkObject = new LinkObject();
            linkObject.setId(unit.getExternalId());
            linkObject.setLabel(unit.getName());
            linkObject.setMethod("viewUnit");
            result.add(linkObject);
        }
        LinkObject linkObject = new LinkObject();
        linkObject.setId(this.getExternalCurricularCourse().getExternalId());
        linkObject.setLabel(this.getExternalCurricularCourse().getName());
        linkObject.setMethod("viewExternalCurricularCourse");
        result.add(linkObject);
        return result;
    }

    @Override
    public String getName() {
        return this.getExternalCurricularCourse().getName();
    }

    public static List<ExternalCurricularCourseResultBean> buildFrom(Unit unit) {
        ArrayList<ExternalCurricularCourseResultBean> result = new ArrayList<ExternalCurricularCourseResultBean>();
        for (ExternalCurricularCourse each : ExternalCurricularCourseResultBean.getChildExternalCurricularCoursesFor(unit)) {
            result.add(new ExternalCurricularCourseResultBean(each, unit.getType()));
        }
        return result;
    }

    private static List<ExternalCurricularCourse> getChildExternalCurricularCoursesFor(Unit unit) {
        ArrayList<ExternalCurricularCourse> result = new ArrayList<ExternalCurricularCourse>();
        ExternalCurricularCourseResultBean.getChildsWithType(result, unit);
        return result;
    }

    private static void getChildsWithType(List<ExternalCurricularCourse> result, Unit unit) {
        result.addAll(unit.getExternalCurricularCoursesSet());
        switch (unit.getType()) {
            case COUNTRY: {
                ExternalCurricularCourseResultBean.addChildExternalCurricularCourses(result, unit, PartyTypeEnum.UNIVERSITY);
                ExternalCurricularCourseResultBean.addChildExternalCurricularCourses(result, unit, PartyTypeEnum.SCHOOL);
                break;
            }
            case UNIVERSITY: {
                ExternalCurricularCourseResultBean.addChildExternalCurricularCourses(result, unit, PartyTypeEnum.SCHOOL);
                ExternalCurricularCourseResultBean.addChildExternalCurricularCourses(result, unit, PartyTypeEnum.DEPARTMENT);
                break;
            }
            case SCHOOL: {
                ExternalCurricularCourseResultBean.addChildExternalCurricularCourses(result, unit, PartyTypeEnum.DEPARTMENT);
                break;
            }
        }
    }

    private static void addChildExternalCurricularCourses(List<ExternalCurricularCourse> result, Unit unit, PartyTypeEnum parentUnitType) {
        for (Unit each : unit.getSubUnits(parentUnitType)) {
            ExternalCurricularCourseResultBean.getChildsWithType(result, each);
        }
    }

    private static enum ExternalDegreeModuleType {
        CURRICULAR_COURSE;


        public String getName() {
            return this.name();
        }
    }
}

