/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import org.fenixedu.academic.domain.DocumentType;
import org.fenixedu.academic.domain.GraduationType;
import org.fenixedu.academic.domain.GuideEntry;
import org.fenixedu.academic.dto.InfoGuide;
import org.fenixedu.academic.dto.InfoObject;
import pt.ist.fenixframework.DomainObject;

public class InfoGuideEntry
extends InfoObject {
    protected GraduationType graduationType;
    protected DocumentType documentType;
    protected String description;
    protected Double price;
    protected Integer quantity;
    protected InfoGuide infoGuide;

    public InfoGuideEntry() {
    }

    public InfoGuideEntry(GraduationType graduationType, DocumentType documentType, String description, Double price, Integer quantity, InfoGuide infoGuide) {
        this.description = description;
        this.documentType = documentType;
        this.graduationType = graduationType;
        this.infoGuide = infoGuide;
        this.price = price;
        this.quantity = quantity;
    }

    @Override
    public boolean equals(Object obj) {
        boolean resultado = false;
        if (obj instanceof InfoGuideEntry) {
            InfoGuideEntry infoGuideEntry = (InfoGuideEntry)obj;
            resultado = this.getInfoGuide().equals(infoGuideEntry.getInfoGuide()) && this.getGraduationType().equals((Object)infoGuideEntry.getGraduationType()) && this.getDocumentType().equals((Object)infoGuideEntry.getDocumentType()) && this.getDescription().equals(infoGuideEntry.getDescription());
        }
        return resultado;
    }

    public String toString() {
        String result = "[GUIDE ENTRY";
        result = result + ", description=" + this.description;
        result = result + ", infoGuide=" + this.infoGuide.getExternalId();
        result = result + ", documentType=" + (Object)((Object)this.documentType);
        result = result + ", graduationType=" + (Object)((Object)this.graduationType);
        result = result + ", price=" + this.price;
        result = result + ", quantity=" + this.quantity;
        result = result + "]";
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public GraduationType getGraduationType() {
        return this.graduationType;
    }

    public InfoGuide getInfoGuide() {
        return this.infoGuide;
    }

    public Double getPrice() {
        return this.price;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDocumentType(DocumentType type) {
        this.documentType = type;
    }

    public void setGraduationType(GraduationType type) {
        this.graduationType = type;
    }

    public void setInfoGuide(InfoGuide guide) {
        this.infoGuide = guide;
    }

    public void setPrice(Double double1) {
        this.price = double1;
    }

    public void setQuantity(Integer integer) {
        this.quantity = integer;
    }

    public void copyFromDomain(GuideEntry guideEntry) {
        super.copyFromDomain((DomainObject)guideEntry);
        if (guideEntry != null) {
            this.setDescription(guideEntry.getDescription());
            this.setDocumentType(guideEntry.getDocumentType());
            this.setGraduationType(guideEntry.getGraduationType());
            this.setPrice(guideEntry.getPrice());
            this.setQuantity(guideEntry.getQuantity());
        }
    }

    public static InfoGuideEntry newInfoFromDomain(GuideEntry guideEntry) {
        InfoGuideEntry infoGuideEntry = null;
        if (guideEntry != null) {
            infoGuideEntry = new InfoGuideEntry();
            infoGuideEntry.copyFromDomain(guideEntry);
        }
        return infoGuideEntry;
    }

    public void copyToDomain(InfoGuideEntry infoGuideEntry, GuideEntry guideEntry) {
        guideEntry.setDescription(infoGuideEntry.getDescription());
        guideEntry.setDocumentType(infoGuideEntry.getDocumentType());
        guideEntry.setGraduationType(infoGuideEntry.getGraduationType());
        guideEntry.setPrice(infoGuideEntry.getPrice());
        guideEntry.setQuantity(infoGuideEntry.getQuantity());
    }
}

