/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.Locale;
import org.fenixedu.academic.domain.DegreeInfo;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.dto.InfoDegree;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.util.MultiLanguageString;
import pt.ist.fenixframework.DomainObject;

public class InfoDegreeInfo
extends InfoObject {
    private InfoDegree infoDegree;
    private ExecutionYear executionYearDomainReference;
    private String description;
    private String history;
    private String objectives;
    private String designedFor;
    private String professionalExits;
    private String operationalRegime;
    private String gratuity;
    private String schoolCalendar;
    private String candidacyPeriod;
    private String selectionResultDeadline;
    private String enrolmentPeriod;
    private String additionalInfo;
    private String links;
    private String testIngression;
    private String classifications;
    private String accessRequisites;
    private String candidacyDocuments;
    private Integer driftsInitial;
    private Integer driftsFirst;
    private Integer driftsSecond;
    private Double markMin;
    private Double markMax;
    private Double markAverage;
    private String qualificationLevel;
    private String recognitions;
    private String descriptionEn;
    private String historyEn;
    private String objectivesEn;
    private String designedForEn;
    private String professionalExitsEn;
    private String operationalRegimeEn;
    private String gratuityEn;
    private String schoolCalendarEn;
    private String candidacyPeriodEn;
    private String selectionResultDeadlineEn;
    private String enrolmentPeriodEn;
    private String additionalInfoEn;
    private String linksEn;
    private String testIngressionEn;
    private String classificationsEn;
    private String accessRequisitesEn;
    private String candidacyDocumentsEn;
    private String qualificationLevelEn;
    private String recognitionsEn;

    public void prepareEnglishPresentation(Locale locale) {
        if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            this.description = this.descriptionEn;
            this.history = this.historyEn;
            this.objectives = this.objectivesEn;
            this.designedFor = this.designedForEn;
            this.professionalExits = this.professionalExitsEn;
            this.operationalRegime = this.operationalRegimeEn;
            this.gratuity = this.gratuityEn;
            this.schoolCalendar = this.schoolCalendarEn;
            this.candidacyPeriod = this.candidacyPeriodEn;
            this.selectionResultDeadline = this.selectionResultDeadlineEn;
            this.enrolmentPeriod = this.enrolmentPeriodEn;
            this.additionalInfo = this.additionalInfoEn;
            this.links = this.linksEn;
            this.testIngression = this.testIngressionEn;
            this.classifications = this.classificationsEn;
            this.accessRequisites = this.accessRequisitesEn;
            this.candidacyDocuments = this.candidacyDocumentsEn;
            this.qualificationLevel = this.qualificationLevelEn;
            this.recognitions = this.recognitionsEn;
        }
    }

    public void copyFromDomain(DegreeInfo degreeInfo) {
        super.copyFromDomain((DomainObject)degreeInfo);
        if (degreeInfo != null) {
            this.setInfoDegree(InfoDegree.newInfoFromDomain(degreeInfo.getDegree()));
            this.setDescription(degreeInfo.getDescription() != null ? degreeInfo.getDescription().getContent(MultiLanguageString.pt) : null);
            this.setHistory(degreeInfo.getHistory() != null ? degreeInfo.getHistory().getContent(MultiLanguageString.pt) : null);
            this.setObjectives(degreeInfo.getObjectives() != null ? degreeInfo.getObjectives().getContent(MultiLanguageString.pt) : null);
            this.setDesignedFor(degreeInfo.getDesignedFor() != null ? degreeInfo.getDesignedFor().getContent(MultiLanguageString.pt) : null);
            this.setProfessionalExits(degreeInfo.getProfessionalExits() != null ? degreeInfo.getProfessionalExits().getContent(MultiLanguageString.pt) : null);
            this.setOperationalRegime(degreeInfo.getOperationalRegime() != null ? degreeInfo.getOperationalRegime().getContent(MultiLanguageString.pt) : null);
            this.setGratuity(degreeInfo.getGratuity() != null ? degreeInfo.getGratuity().getContent(MultiLanguageString.pt) : null);
            this.setSchoolCalendar(degreeInfo.getSchoolCalendar() != null ? degreeInfo.getSchoolCalendar().getContent(MultiLanguageString.pt) : null);
            this.setCandidacyPeriod(degreeInfo.getCandidacyPeriod() != null ? degreeInfo.getCandidacyPeriod().getContent(MultiLanguageString.pt) : null);
            this.setSelectionResultDeadline(degreeInfo.getSelectionResultDeadline() != null ? degreeInfo.getSelectionResultDeadline().getContent(MultiLanguageString.pt) : null);
            this.setEnrolmentPeriod(degreeInfo.getEnrolmentPeriod() != null ? degreeInfo.getEnrolmentPeriod().getContent(MultiLanguageString.pt) : null);
            this.setAdditionalInfo(degreeInfo.getAdditionalInfo() != null ? degreeInfo.getAdditionalInfo().getContent(MultiLanguageString.pt) : null);
            this.setLinks(degreeInfo.getLinks() != null ? degreeInfo.getLinks().getContent(MultiLanguageString.pt) : null);
            this.setTestIngression(degreeInfo.getTestIngression() != null ? degreeInfo.getTestIngression().getContent(MultiLanguageString.pt) : null);
            this.setClassifications(degreeInfo.getClassifications() != null ? degreeInfo.getClassifications().getContent(MultiLanguageString.pt) : null);
            this.setAccessRequisites(degreeInfo.getAccessRequisites() != null ? degreeInfo.getAccessRequisites().getContent(MultiLanguageString.pt) : null);
            this.setCandidacyDocuments(degreeInfo.getCandidacyDocuments() != null ? degreeInfo.getCandidacyDocuments().getContent(MultiLanguageString.pt) : null);
            this.setDriftsInitial(degreeInfo.getDriftsInitial());
            this.setDriftsFirst(degreeInfo.getDriftsFirst());
            this.setDriftsSecond(degreeInfo.getDriftsSecond());
            this.setMarkMin(degreeInfo.getMarkMin());
            this.setMarkMax(degreeInfo.getMarkMax());
            this.setMarkAverage(degreeInfo.getMarkAverage());
            this.setQualificationLevel(degreeInfo.getQualificationLevel() != null ? degreeInfo.getQualificationLevel().getContent(MultiLanguageString.pt) : null);
            this.setRecognitions(degreeInfo.getRecognitions() != null ? degreeInfo.getRecognitions().getContent(MultiLanguageString.pt) : null);
            this.setDescriptionEn(degreeInfo.getDescription() != null ? degreeInfo.getDescription().getContent(MultiLanguageString.en) : null);
            this.setHistoryEn(degreeInfo.getHistory() != null ? degreeInfo.getHistory().getContent(MultiLanguageString.en) : null);
            this.setObjectivesEn(degreeInfo.getObjectives() != null ? degreeInfo.getObjectives().getContent(MultiLanguageString.en) : null);
            this.setDesignedForEn(degreeInfo.getDesignedFor() != null ? degreeInfo.getDesignedFor().getContent(MultiLanguageString.en) : null);
            this.setProfessionalExitsEn(degreeInfo.getProfessionalExits() != null ? degreeInfo.getProfessionalExits().getContent(MultiLanguageString.en) : null);
            this.setOperationalRegimeEn(degreeInfo.getOperationalRegime() != null ? degreeInfo.getOperationalRegime().getContent(MultiLanguageString.en) : null);
            this.setGratuityEn(degreeInfo.getGratuity() != null ? degreeInfo.getGratuity().getContent(MultiLanguageString.en) : null);
            this.setSchoolCalendarEn(degreeInfo.getSchoolCalendar() != null ? degreeInfo.getSchoolCalendar().getContent(MultiLanguageString.en) : null);
            this.setCandidacyPeriodEn(degreeInfo.getCandidacyPeriod() != null ? degreeInfo.getCandidacyPeriod().getContent(MultiLanguageString.en) : null);
            this.setSelectionResultDeadlineEn(degreeInfo.getSelectionResultDeadline() != null ? degreeInfo.getSelectionResultDeadline().getContent(MultiLanguageString.en) : null);
            this.setEnrolmentPeriodEn(degreeInfo.getEnrolmentPeriod() != null ? degreeInfo.getEnrolmentPeriod().getContent(MultiLanguageString.en) : null);
            this.setAdditionalInfoEn(degreeInfo.getAdditionalInfo() != null ? degreeInfo.getAdditionalInfo().getContent(MultiLanguageString.en) : null);
            this.setLinksEn(degreeInfo.getLinks() != null ? degreeInfo.getLinks().getContent(MultiLanguageString.en) : null);
            this.setTestIngressionEn(degreeInfo.getTestIngression() != null ? degreeInfo.getTestIngression().getContent(MultiLanguageString.en) : null);
            this.setClassificationsEn(degreeInfo.getClassifications() != null ? degreeInfo.getClassifications().getContent(MultiLanguageString.en) : null);
            this.setAccessRequisitesEn(degreeInfo.getAccessRequisites() != null ? degreeInfo.getAccessRequisites().getContent(MultiLanguageString.en) : null);
            this.setCandidacyDocumentsEn(degreeInfo.getCandidacyDocuments() != null ? degreeInfo.getCandidacyDocuments().getContent(MultiLanguageString.en) : null);
            this.setQualificationLevelEn(degreeInfo.getQualificationLevel() != null ? degreeInfo.getQualificationLevel().getContent(MultiLanguageString.en) : null);
            this.setRecognitionsEn(degreeInfo.getRecognitions() != null ? degreeInfo.getRecognitions().getContent(MultiLanguageString.en) : null);
        }
    }

    public static InfoDegreeInfo newInfoFromDomain(DegreeInfo degreeInfo) {
        InfoDegreeInfo infoDegreeInfo = null;
        if (degreeInfo != null) {
            infoDegreeInfo = new InfoDegreeInfo();
            infoDegreeInfo.copyFromDomain(degreeInfo);
        }
        return infoDegreeInfo;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof InfoDegreeInfo) {
            InfoDegreeInfo infoDegreeInfo = (InfoDegreeInfo)obj;
            result = this.getInfoDegree().equals(infoDegreeInfo.getInfoDegree());
        }
        return result;
    }

    public String toString() {
        String result = "[INFODEGREE_INFO:";
        result = result + " codigo interno= " + this.getExternalId();
        result = result + " degree= " + this.getInfoDegree();
        result = result + " descri\ufffd\ufffdo= " + this.getDescription();
        result = result + " objectivos= " + this.getObjectives();
        result = result + " historial= " + this.getHistory();
        result = result + " saidas profissionais=" + this.getProfessionalExits();
        result = result + " informa\ufffd\ufffdo adicional= " + this.getAdditionalInfo();
        result = result + " links= " + this.getLinks();
        result = result + " provas de ingresso= " + this.getTestIngression();
        result = result + " classifica\ufffd\ufffdes= " + this.getClassifications();
        result = result + " descri\ufffd\ufffdo(En)= " + this.getDescriptionEn();
        result = result + " objectivos(En)= " + this.getObjectivesEn();
        result = result + " historial(En)= " + this.getHistoryEn();
        result = result + " saidas profissionais(En)=" + this.getProfessionalExitsEn();
        result = result + " informa\ufffd\ufffdo adicional(En)= " + this.getAdditionalInfoEn();
        result = result + " links(En)= " + this.getLinksEn();
        result = result + " provas de ingresso(En)= " + this.getTestIngressionEn();
        result = result + " classifica\ufffd\ufffdes(En)= " + this.getClassificationsEn();
        result = result + " vagas iniciais= " + this.getDriftsInitial();
        result = result + " vagas 1\ufffd fase= " + this.getDriftsFirst();
        result = result + " vagas 2\ufffdfase= " + this.getDriftsSecond();
        result = result + " nota minima= " + this.getMarkMin();
        result = result + " nota m\ufffdxima= " + this.getMarkMax();
        result = result + " nota m\ufffddia= " + this.getMarkAverage();
        result = result + "]";
        return result;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public String getClassifications() {
        return this.classifications;
    }

    public void setClassifications(String classifications) {
        this.classifications = classifications;
    }

    public Integer getDriftsFirst() {
        return this.driftsFirst;
    }

    public void setDriftsFirst(Integer driftsFirst) {
        this.driftsFirst = driftsFirst;
    }

    public Integer getDriftsInitial() {
        return this.driftsInitial;
    }

    public void setDriftsInitial(Integer driftsInitial) {
        this.driftsInitial = driftsInitial;
    }

    public Integer getDriftsSecond() {
        return this.driftsSecond;
    }

    public void setDriftsSecond(Integer driftsSecond) {
        this.driftsSecond = driftsSecond;
    }

    public String getHistory() {
        return this.history;
    }

    public void setHistory(String history) {
        this.history = history;
    }

    public InfoDegree getInfoDegree() {
        return this.infoDegree;
    }

    public void setInfoDegree(InfoDegree infoDegree) {
        this.infoDegree = infoDegree;
    }

    public String getLinks() {
        return this.links;
    }

    public void setLinks(String links) {
        this.links = links;
    }

    public Double getMarkAverage() {
        return this.markAverage;
    }

    public void setMarkAverage(Double markAverage) {
        this.markAverage = markAverage;
    }

    public Double getMarkMax() {
        return this.markMax;
    }

    public void setMarkMax(Double markMax) {
        this.markMax = markMax;
    }

    public Double getMarkMin() {
        return this.markMin;
    }

    public void setMarkMin(Double markMin) {
        this.markMin = markMin;
    }

    public String getObjectives() {
        return this.objectives;
    }

    public void setObjectives(String objectives) {
        this.objectives = objectives;
    }

    public String getProfessionalExits() {
        return this.professionalExits;
    }

    public void setProfessionalExits(String professionalExits) {
        this.professionalExits = professionalExits;
    }

    public String getTestIngression() {
        return this.testIngression;
    }

    public void setTestIngression(String testIngression) {
        this.testIngression = testIngression;
    }

    public String getAdditionalInfoEn() {
        return this.additionalInfoEn;
    }

    public void setAdditionalInfoEn(String additionalInfoEn) {
        this.additionalInfoEn = additionalInfoEn;
    }

    public String getClassificationsEn() {
        return this.classificationsEn;
    }

    public void setClassificationsEn(String classificationsEn) {
        this.classificationsEn = classificationsEn;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescriptionEn() {
        return this.descriptionEn;
    }

    public void setDescriptionEn(String descriptionEn) {
        this.descriptionEn = descriptionEn;
    }

    public String getHistoryEn() {
        return this.historyEn;
    }

    public void setHistoryEn(String historyEn) {
        this.historyEn = historyEn;
    }

    public String getLinksEn() {
        return this.linksEn;
    }

    public void setLinksEn(String linksEn) {
        this.linksEn = linksEn;
    }

    public String getObjectivesEn() {
        return this.objectivesEn;
    }

    public void setObjectivesEn(String objectivesEn) {
        this.objectivesEn = objectivesEn;
    }

    public String getProfessionalExitsEn() {
        return this.professionalExitsEn;
    }

    public void setProfessionalExitsEn(String professionalExitsEn) {
        this.professionalExitsEn = professionalExitsEn;
    }

    public String getTestIngressionEn() {
        return this.testIngressionEn;
    }

    public void setTestIngressionEn(String testIngressionEn) {
        this.testIngressionEn = testIngressionEn;
    }

    public String getQualificationLevel() {
        return this.qualificationLevel;
    }

    public void setQualificationLevel(String qualificationLevel) {
        this.qualificationLevel = qualificationLevel;
    }

    public String getQualificationLevelEn() {
        return this.qualificationLevelEn;
    }

    public void setQualificationLevelEn(String qualificationLevelEn) {
        this.qualificationLevelEn = qualificationLevelEn;
    }

    public String getRecognitions() {
        return this.recognitions;
    }

    public void setRecognitions(String recognitions) {
        this.recognitions = recognitions;
    }

    public String getRecognitionsEn() {
        return this.recognitionsEn;
    }

    public void setRecognitionsEn(String recognitionsEn) {
        this.recognitionsEn = recognitionsEn;
    }

    public String getAccessRequisites() {
        return this.accessRequisites;
    }

    public void setAccessRequisites(String accessRequisites) {
        this.accessRequisites = accessRequisites;
    }

    public String getAccessRequisitesEn() {
        return this.accessRequisitesEn;
    }

    public void setAccessRequisitesEn(String accessRequisitesEn) {
        this.accessRequisitesEn = accessRequisitesEn;
    }

    public String getCandidacyDocuments() {
        return this.candidacyDocuments;
    }

    public void setCandidacyDocuments(String candidacyDocuments) {
        this.candidacyDocuments = candidacyDocuments;
    }

    public String getCandidacyDocumentsEn() {
        return this.candidacyDocumentsEn;
    }

    public void setCandidacyDocumentsEn(String candidacyDocumentsEn) {
        this.candidacyDocumentsEn = candidacyDocumentsEn;
    }

    public String getCandidacyPeriod() {
        return this.candidacyPeriod;
    }

    public void setCandidacyPeriod(String candidacyPeriod) {
        this.candidacyPeriod = candidacyPeriod;
    }

    public String getCandidacyPeriodEn() {
        return this.candidacyPeriodEn;
    }

    public void setCandidacyPeriodEn(String candidacyPeriodEn) {
        this.candidacyPeriodEn = candidacyPeriodEn;
    }

    public String getDesignedFor() {
        return this.designedFor;
    }

    public void setDesignedFor(String designedFor) {
        this.designedFor = designedFor;
    }

    public String getDesignedForEn() {
        return this.designedForEn;
    }

    public void setDesignedForEn(String designedForEn) {
        this.designedForEn = designedForEn;
    }

    public String getEnrolmentPeriod() {
        return this.enrolmentPeriod;
    }

    public void setEnrolmentPeriod(String enrolmentPeriod) {
        this.enrolmentPeriod = enrolmentPeriod;
    }

    public String getEnrolmentPeriodEn() {
        return this.enrolmentPeriodEn;
    }

    public void setEnrolmentPeriodEn(String enrolmentPeriodEn) {
        this.enrolmentPeriodEn = enrolmentPeriodEn;
    }

    public String getGratuity() {
        return this.gratuity;
    }

    public void setGratuity(String gratuity) {
        this.gratuity = gratuity;
    }

    public String getGratuityEn() {
        return this.gratuityEn;
    }

    public void setGratuityEn(String gratuityEn) {
        this.gratuityEn = gratuityEn;
    }

    public String getOperationalRegime() {
        return this.operationalRegime;
    }

    public void setOperationalRegime(String operationalRegime) {
        this.operationalRegime = operationalRegime;
    }

    public String getOperationalRegimeEn() {
        return this.operationalRegimeEn;
    }

    public void setOperationalRegimeEn(String operationalRegimeEn) {
        this.operationalRegimeEn = operationalRegimeEn;
    }

    public String getSchoolCalendar() {
        return this.schoolCalendar;
    }

    public void setSchoolCalendar(String schoolCalendar) {
        this.schoolCalendar = schoolCalendar;
    }

    public String getSchoolCalendarEn() {
        return this.schoolCalendarEn;
    }

    public void setSchoolCalendarEn(String schoolCalendarEn) {
        this.schoolCalendarEn = schoolCalendarEn;
    }

    public String getSelectionResultDeadline() {
        return this.selectionResultDeadline;
    }

    public void setSelectionResultDeadline(String selectionResultDeadline) {
        this.selectionResultDeadline = selectionResultDeadline;
    }

    public String getSelectionResultDeadlineEn() {
        return this.selectionResultDeadlineEn;
    }

    public void setSelectionResultDeadlineEn(String selectionResultDeadlineEn) {
        this.selectionResultDeadlineEn = selectionResultDeadlineEn;
    }
}

