/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.registrationStates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ListIterator;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.CanceledState;
import org.fenixedu.academic.domain.student.registrationStates.ConcludedState;
import org.fenixedu.academic.domain.student.registrationStates.ExternalAbandonState;
import org.fenixedu.academic.domain.student.registrationStates.FlunkedState;
import org.fenixedu.academic.domain.student.registrationStates.InactiveState;
import org.fenixedu.academic.domain.student.registrationStates.InternalAbandonState;
import org.fenixedu.academic.domain.student.registrationStates.InterruptedState;
import org.fenixedu.academic.domain.student.registrationStates.MobilityState;
import org.fenixedu.academic.domain.student.registrationStates.RegisteredState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateLog;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState_Base;
import org.fenixedu.academic.domain.student.registrationStates.SchoolPartConcludedState;
import org.fenixedu.academic.domain.student.registrationStates.StudyPlanConcludedState;
import org.fenixedu.academic.domain.student.registrationStates.TransitedState;
import org.fenixedu.academic.domain.student.registrationStates.TransitionalState;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.academic.domain.util.workflow.IState;
import org.fenixedu.academic.domain.util.workflow.StateBean;
import org.fenixedu.academic.domain.util.workflow.StateMachine;
import org.fenixedu.academic.dto.student.RegistrationStateBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RegistrationStatePredicates;
import org.fenixedu.academic.util.EnrolmentAction;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public abstract class RegistrationState
extends RegistrationState_Base
implements IState {
    public static Comparator<RegistrationState> DATE_COMPARATOR;
    public static Comparator<RegistrationState> DATE_AND_STATE_TYPE_COMPARATOR;

    public RegistrationState() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    private static RegistrationState createState(Registration registration, Person person, DateTime dateTime, RegistrationStateType stateType) {
        Object newState = null;
        switch (stateType) {
            case REGISTERED: {
                newState = new RegisteredState(registration, person, dateTime);
                break;
            }
            case CANCELED: {
                newState = new CanceledState(registration, person, dateTime);
                break;
            }
            case CONCLUDED: {
                newState = new ConcludedState(registration, person, dateTime);
                break;
            }
            case FLUNKED: {
                newState = new FlunkedState(registration, person, dateTime);
                break;
            }
            case INTERRUPTED: {
                newState = new InterruptedState(registration, person, dateTime);
                break;
            }
            case SCHOOLPARTCONCLUDED: {
                newState = new SchoolPartConcludedState(registration, person, dateTime);
                break;
            }
            case STUDYPLANCONCLUDED: {
                newState = new StudyPlanConcludedState(registration, person, dateTime);
                break;
            }
            case INTERNAL_ABANDON: {
                newState = new InternalAbandonState(registration, person, dateTime);
                break;
            }
            case EXTERNAL_ABANDON: {
                newState = new ExternalAbandonState(registration, person, dateTime);
                break;
            }
            case MOBILITY: {
                newState = new MobilityState(registration, person, dateTime);
                break;
            }
            case TRANSITION: {
                newState = new TransitionalState(registration, person, dateTime);
                break;
            }
            case TRANSITED: {
                newState = new TransitedState(registration, person, dateTime);
                break;
            }
            case INACTIVE: {
                newState = new InactiveState(registration, person, dateTime);
            }
        }
        registration.getStudent().updateStudentRole();
        return newState;
    }

    protected void init(Registration registration, Person responsiblePerson, DateTime stateDate) {
        this.setStateDate(stateDate != null ? stateDate : new DateTime());
        this.setRegistration(registration);
        this.setResponsiblePerson(this.selectPerson(responsiblePerson));
    }

    private Person selectPerson(Person responsiblePerson) {
        if (responsiblePerson != null) {
            return RoleType.MANAGER.isMember(responsiblePerson.getUser()) ? null : responsiblePerson;
        }
        Person loggedPerson = AccessControl.getPerson();
        return loggedPerson == null ? null : (RoleType.MANAGER.isMember(loggedPerson.getUser()) ? null : loggedPerson);
    }

    protected void init(Registration registration) {
        this.init(registration, null, null);
    }

    @Override
    public final IState nextState() {
        return this.nextState(new StateBean(this.defaultNextStateType().toString()));
    }

    protected RegistrationStateType defaultNextStateType() {
        throw new DomainException("error.no.default.nextState.defined", new String[0]);
    }

    @Override
    public IState nextState(StateBean bean) {
        return RegistrationState.createState(this.getRegistration(), bean.getResponsible(), bean.getStateDateTime(), RegistrationStateType.valueOf(bean.getNextState()));
    }

    @Override
    public final void checkConditionsToForward() {
        this.checkConditionsToForward(new RegistrationStateBean(this.defaultNextStateType()));
    }

    @Override
    public void checkConditionsToForward(StateBean bean) {
        this.checkCurriculumLinesForStateDate(bean);
    }

    private void checkCurriculumLinesForStateDate(StateBean bean) {
        ExecutionYear year = ExecutionYear.readByDateTime(bean.getStateDateTime());
        RegistrationStateType nextStateType = RegistrationStateType.valueOf(bean.getNextState());
        if (nextStateType.canHaveCurriculumLinesOnCreation()) {
            return;
        }
        if (this.getRegistration().hasAnyEnroledEnrolments(year)) {
            throw new DomainException("RegisteredState.error.registration.has.enroled.enrolments.for.execution.year", year.getName());
        }
    }

    @Override
    public Set<String> getValidNextStates() {
        return Collections.emptySet();
    }

    public abstract RegistrationStateType getStateType();

    public ExecutionYear getExecutionYear() {
        return ExecutionYear.readByDateTime(this.getStateDate());
    }

    public void delete() {
        AccessControl.check(this, RegistrationStatePredicates.deletePredicate);
        RegistrationState nextState = this.getNext();
        RegistrationState previousState = this.getPrevious();
        if (nextState != null && previousState != null && !previousState.getValidNextStates().contains(nextState.getStateType().name())) {
            throw new DomainException("error.cannot.delete.registrationState.incoherentState: " + previousState.getStateType().name() + " -> " + nextState.getStateType().name(), new String[0]);
        }
        this.deleteWithoutCheckRules();
    }

    public void deleteWithoutCheckRules() {
        Registration registration = this.getRegistration();
        try {
            if (this.getResponsiblePerson() != null) {
                String responsablePersonName = this.getResponsiblePerson().getPresentationName();
            } else {
                String responsablePersonName = "-";
            }
            org.fenixedu.academic.domain.student.RegistrationStateLog.createRegistrationStateLog(this.getRegistration(), "resources.MessagingResources", "log.registration.registrationstate.removed", this.getStateType().getDescription(), this.getRemarks());
            this.setRegistration(null);
            this.setResponsiblePerson(null);
            this.setRootDomainObject(null);
            super.deleteDomainObject();
        }
        finally {
            registration.getStudent().updateStudentRole();
        }
    }

    public RegistrationState getNext() {
        ArrayList sortedRegistrationsStates = new ArrayList(this.getRegistration().getRegistrationStatesSet());
        Collections.sort(sortedRegistrationsStates, DATE_COMPARATOR);
        ListIterator iter = sortedRegistrationsStates.listIterator();
        while (iter.hasNext()) {
            RegistrationState state = (RegistrationState)iter.next();
            if (!state.equals(this)) continue;
            if (iter.hasNext()) {
                return (RegistrationState)iter.next();
            }
            return null;
        }
        return null;
    }

    public RegistrationState getPrevious() {
        ArrayList sortedRegistrationsStates = new ArrayList(this.getRegistration().getRegistrationStatesSet());
        Collections.sort(sortedRegistrationsStates, DATE_COMPARATOR);
        ListIterator iter = sortedRegistrationsStates.listIterator(sortedRegistrationsStates.size());
        while (iter.hasPrevious()) {
            RegistrationState state = (RegistrationState)iter.previous();
            if (!state.equals(this)) continue;
            if (iter.hasPrevious()) {
                return (RegistrationState)iter.previous();
            }
            return null;
        }
        return null;
    }

    public DateTime getEndDate() {
        RegistrationState state = this.getNext();
        return state != null ? state.getStateDate() : null;
    }

    public void setStateDate(YearMonthDay yearMonthDay) {
        super.setStateDate(yearMonthDay.toDateTimeAtMidnight());
    }

    public static RegistrationState createRegistrationState(Registration registration, Person responsible, DateTime creation, RegistrationStateType stateType) {
        RegistrationStateBean bean = new RegistrationStateBean(registration);
        bean.setResponsible(responsible);
        bean.setStateDateTime(creation);
        bean.setStateType(stateType);
        return RegistrationState.createRegistrationState(bean);
    }

    public static RegistrationState createRegistrationState(RegistrationStateBean bean) {
        RegistrationState createdState = null;
        RegistrationState previousState = bean.getRegistration().getStateInDate(bean.getStateDateTime());
        createdState = previousState == null ? RegistrationState.createState(bean.getRegistration(), null, bean.getStateDateTime(), bean.getStateType()) : (RegistrationState)StateMachine.execute(previousState, bean);
        createdState.setRemarks(bean.getRemarks());
        RegistrationState nextState = createdState.getNext();
        if (nextState != null && !createdState.getValidNextStates().contains(nextState.getStateType().name())) {
            throw new DomainException("error.cannot.add.registrationState.incoherentState", new String[0]);
        }
        org.fenixedu.academic.domain.student.RegistrationStateLog.createRegistrationStateLog(bean.getRegistration(), "resources.MessagingResources", "log.registration.registrationstate.added", bean.getStateType().getDescription(), bean.getRemarks());
        return createdState;
    }

    public boolean isActive() {
        return this.getStateType().isActive();
    }

    public boolean includes(ExternalEnrolment externalEnrolment) {
        if (this.getStateType() == RegistrationStateType.MOBILITY) {
            DateTime mobilityDate = this.getStateDate();
            return externalEnrolment.hasExecutionPeriod() && externalEnrolment.getExecutionYear().containsDate(mobilityDate);
        }
        throw new DomainException("RegistrationState.external.enrolments.only.included.in.mobility.states", new String[0]);
    }

    public static boolean hasAnyState(Collection<RegistrationState> states, Collection<RegistrationStateType> types) {
        for (RegistrationState state : states) {
            if (!types.contains((Object)state.getStateType())) continue;
            return true;
        }
        return false;
    }

    static {
        RegistrationState.getRelationRegistrationStateRegistration().addListener((RelationListener)new RelationAdapter<RegistrationState, Registration>(){

            public void afterAdd(RegistrationState state, Registration registration) {
                super.afterAdd((DomainObject)state, (DomainObject)registration);
                if (registration != null && state != null) {
                    new RegistrationStateLog(state, EnrolmentAction.ENROL, AccessControl.getPerson());
                }
            }

            public void beforeRemove(RegistrationState state, Registration registration) {
                super.beforeRemove((DomainObject)state, (DomainObject)registration);
                if (registration != null && state != null) {
                    new RegistrationStateLog(state, EnrolmentAction.UNENROL, AccessControl.getPerson());
                }
            }
        });
        DATE_COMPARATOR = new Comparator<RegistrationState>(){

            @Override
            public int compare(RegistrationState leftState, RegistrationState rightState) {
                int comparationResult = leftState.getStateDate().compareTo((ReadableInstant)rightState.getStateDate());
                return comparationResult == 0 ? leftState.getExternalId().compareTo(rightState.getExternalId()) : comparationResult;
            }
        };
        DATE_AND_STATE_TYPE_COMPARATOR = new Comparator<RegistrationState>(){

            @Override
            public int compare(RegistrationState leftState, RegistrationState rightState) {
                int comparationResult = DATE_COMPARATOR.compare(leftState, rightState);
                if (comparationResult != 0) {
                    return comparationResult;
                }
                comparationResult = leftState.getStateType().compareTo(rightState.getStateType());
                return comparationResult == 0 ? leftState.getExternalId().compareTo(rightState.getExternalId()) : comparationResult;
            }
        };
    }
}

