/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.activities.PhdThesisActivity;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.LocalDate;

public class RatifyFinalThesis
extends PhdThesisActivity {
    @Override
    protected void activityPreConditions(PhdThesisProcess process2, User userView) {
        if (!process2.isAllowedToManageProcess(userView)) {
            throw new PreConditionNotValidException();
        }
        if (process2.getActiveState() != PhdThesisProcessStateType.WAITING_FOR_THESIS_RATIFICATION) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdThesisProcess executeActivity(PhdThesisProcess process2, User userView, Object object) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)object;
        this.checkParameters(bean);
        LocalDate whenFinalThesisRatified = bean.getWhenFinalThesisRatified();
        process2.setWhenFinalThesisRatified(whenFinalThesisRatified);
        for (PhdProgramDocumentUploadBean document : bean.getDocuments()) {
            if (!document.hasAnyInformation()) continue;
            process2.addDocument(document, userView.getPerson());
        }
        process2.createState(PhdThesisProcessStateType.WAITING_FOR_FINAL_GRADE, userView.getPerson(), bean.getRemarks());
        return process2;
    }

    private void checkParameters(PhdThesisProcessBean bean) {
        if (bean.getWhenFinalThesisRatified() == null) {
            throw new DomainException("error.RatifyFinalThesis.invalid.final.thesis.ratified.date", new String[0]);
        }
    }
}

