/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.migration;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramCollaborationType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.PhdParticipantBean;
import org.fenixedu.academic.domain.phd.PhdProgramCandidacyProcessState;
import org.fenixedu.academic.domain.phd.PhdProgramFocusArea;
import org.fenixedu.academic.domain.phd.PhdStudyPlanBean;
import org.fenixedu.academic.domain.phd.SearchPhdIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcessBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcessStateBean;
import org.fenixedu.academic.domain.phd.candidacy.RatifyCandidacyBean;
import org.fenixedu.academic.domain.phd.candidacy.RegistrationFormalizationBean;
import org.fenixedu.academic.domain.phd.candidacy.activities.RatifyCandidacy;
import org.fenixedu.academic.domain.phd.candidacy.activities.RegistrationFormalization;
import org.fenixedu.academic.domain.phd.candidacy.activities.RequestCandidacyReview;
import org.fenixedu.academic.domain.phd.candidacy.activities.RequestRatifyCandidacy;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddAssistantGuidingInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddGuidingInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddStudyPlan;
import org.fenixedu.academic.domain.phd.individualProcess.activities.CancelPhdProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditQualificationExams;
import org.fenixedu.academic.domain.phd.individualProcess.activities.ExemptPublicPresentationSeminarComission;
import org.fenixedu.academic.domain.phd.individualProcess.activities.RequestPublicThesisPresentation;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationGuiding;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationIndividualPersonalData;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationIndividualProcessData$callable$proceedWithMigration;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationIndividualProcessDataBean;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationIndividualProcessData_Base;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationProcessStateType;
import org.fenixedu.academic.domain.phd.migration.activities.SkipThesisJuryActivities;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.FinalEstimatedStateNotReachedException;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.PersonNotFoundException;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.PhdMigrationException;
import org.fenixedu.academic.domain.phd.seminar.PublicPresentationSeminarProcessBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.activities.RatifyFinalThesis;
import org.fenixedu.academic.domain.phd.thesis.activities.SetFinalGrade;
import org.fenixedu.academic.domain.phd.thesis.activities.SkipScheduleThesisDiscussion;
import org.fenixedu.academic.domain.phd.thesis.activities.SubmitThesis;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcess;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.ScheduleFirstThesisMeetingRequest;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.SkipScheduleFirstThesisMeeting;
import org.fenixedu.academic.service.services.caseHandling.CreateNewProcess;
import org.fenixedu.academic.service.services.caseHandling.ExecuteProcessActivity;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdMigrationIndividualProcessData
extends PhdMigrationIndividualProcessData_Base {
    public static final Advice advice$proceedWithMigration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected PhdMigrationIndividualProcessData(String data) {
        this.setData(data);
        this.setMigrationStatus(PhdMigrationProcessStateType.NOT_MIGRATED);
    }

    public PhdMigrationIndividualProcessDataBean getProcessBean() {
        return new PhdMigrationIndividualProcessDataBean(this);
    }

    public boolean hasMigrationParseLog() {
        return !StringUtils.isEmpty((String)this.getMigrationParseLog());
    }

    public String getMigrationException() {
        if (!this.hasMigrationParseLog()) {
            return null;
        }
        String exceptionLine = this.getMigrationParseLog();
        int messageStartIdx = exceptionLine.indexOf(" ");
        if (messageStartIdx == -1) {
            return exceptionLine;
        }
        return exceptionLine.substring(0, exceptionLine.indexOf(" ") - 1);
    }

    public String getMigrationExceptionMessage() {
        if (!this.hasMigrationParseLog()) {
            return null;
        }
        String exceptionLine = this.getMigrationParseLog();
        int messageStartIdx = exceptionLine.indexOf(" ");
        if (messageStartIdx == -1) {
            return null;
        }
        return exceptionLine.substring(exceptionLine.indexOf(" "));
    }

    public String getMigrationExceptionMessageFromBundle() {
        String exceptionString = this.getMigrationException();
        if (exceptionString == null) {
            return null;
        }
        String messageString = this.getMigrationExceptionMessage();
        String errorTranslated = null;
        if (exceptionString.contains(DomainException.class.getSimpleName())) {
            if (messageString == null) {
                errorTranslated = exceptionString + " " + messageString;
            } else {
                try {
                    errorTranslated = BundleUtil.getString((String)"resources.ApplicationResources", (String)messageString, (String[])new String[0]);
                }
                catch (Exception e) {
                    errorTranslated = exceptionString + " " + messageString;
                }
            }
            return errorTranslated;
        }
        try {
            errorTranslated = BundleUtil.getString((String)"resources.PhdResources", (String)("label.phd.migration.exception." + exceptionString), (String[])new String[0]);
        }
        catch (Exception e) {
            return exceptionString + " " + messageString;
        }
        errorTranslated = errorTranslated + " - " + this.getMigrationExceptionMessage();
        return errorTranslated;
    }

    public Person getGuidingPerson() {
        if (this.getProcessBean().getGuiderId().contains("E")) {
            throw new PersonNotFoundException();
        }
        return this.getPerson(this.getProcessBean().getGuiderId());
    }

    public Person getAssistantGuidingPerson() {
        if (this.getProcessBean().getAssistantGuiderId().contains("E")) {
            throw new PersonNotFoundException();
        }
        return this.getPerson(this.getProcessBean().getAssistantGuiderId());
    }

    public Person getPerson(String identification) {
        Teacher teacher = User.findByUsername((String)identification).getPerson().getTeacher();
        if (teacher == null) {
            throw new PersonNotFoundException();
        }
        return teacher.getPerson();
    }

    public boolean isMigratedToIndividualProgramProcess() {
        return this.getMigratedIndividualProgramProcess() != null;
    }

    public boolean isNotMigrated() {
        return this.getMigrationStatus().equals((Object)PhdMigrationProcessStateType.NOT_MIGRATED) && this.getMigratedIndividualProgramProcess() == null;
    }

    public boolean isRegistered() {
        if (this.getPhdMigrationIndividualPersonalData() != null) {
            try {
                if (this.getPhdMigrationIndividualPersonalData().isPersonRegisteredOnFenix()) {
                    return true;
                }
            }
            catch (PhdMigrationException phdMigrationException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isNotRegisteredAndNoSimilarsExist() {
        if (this.getPhdMigrationIndividualPersonalData() != null) {
            try {
                if (!this.getPhdMigrationIndividualPersonalData().isPersonRegisteredOnFenix()) {
                    return true;
                }
            }
            catch (PhdMigrationException phdMigrationException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isThereAnySimilarRegistration() {
        if (this.getPhdMigrationIndividualPersonalData() != null) {
            try {
                this.getPhdMigrationIndividualPersonalData().isPersonRegisteredOnFenix();
            }
            catch (PhdMigrationException e) {
                return true;
            }
        }
        return false;
    }

    public PhdIndividualProgramProcess getMigratedIndividualProgramProcess() {
        SearchPhdIndividualProgramProcessBean searchBean = new SearchPhdIndividualProgramProcessBean();
        searchBean.setFilterPhdPrograms(false);
        searchBean.setFilterPhdProcesses(false);
        for (PhdIndividualProgramProcess process2 : PhdIndividualProgramProcess.search(searchBean.getPredicates())) {
            if (process2.getPhdStudentNumber() == null || !process2.getPhdStudentNumber().equals(this.getNumber())) continue;
            return process2;
        }
        return null;
    }

    public boolean hasExistingIndividualProgramProcess() {
        return this.getPhdIndividualProgramProcess() != null;
    }

    public PhdIndividualProgramProcess getPhdIndividualProgramProcess() {
        PhdMigrationIndividualPersonalData personalData = this.getPhdMigrationIndividualPersonalData();
        if (personalData == null) {
            return null;
        }
        if (!personalData.isPersonRegisteredOnFenix()) {
            return null;
        }
        Person student = personalData.getPerson();
        if (!student.getPhdIndividualProgramProcessesSet().isEmpty()) {
            return (PhdIndividualProgramProcess)((Object)student.getPhdIndividualProgramProcessesSet().iterator().next());
        }
        return null;
    }

    public ExecutionYear getExecutionYear() {
        LocalDate date = this.retrieveDateForExecutionYear();
        if (date != null) {
            return ExecutionYear.readByDateTime(date);
        }
        return null;
    }

    private LocalDate retrieveDateForExecutionYear() {
        if (this.getProcessBean().getStartDevelopmentDate() != null) {
            return this.getProcessBean().getStartDevelopmentDate();
        }
        if (this.getProcessBean().getRatificationDate() != null) {
            return this.getProcessBean().getRatificationDate();
        }
        if (this.getProcessBean().getStartProcessDate() != null) {
            return this.getProcessBean().getStartProcessDate();
        }
        return null;
    }

    public PhdMigrationProcessStateType estimatedFinalMigrationStatus() {
        if (this.isProcessCanceled()) {
            return PhdMigrationProcessStateType.CANCELED;
        }
        if (this.getProcessBean().getEdictDate() != null || this.getProcessBean().getClassification() != null) {
            return PhdMigrationProcessStateType.CONCLUDED;
        }
        if (this.getProcessBean().getFirstDiscussionDate() != null || this.getProcessBean().getSecondDiscussionDate() != null) {
            return PhdMigrationProcessStateType.COMPLETED_THESIS_DISCUSSION;
        }
        if (this.getProcessBean().getRequirementDate() != null) {
            return PhdMigrationProcessStateType.REQUESTED_THESIS_DISCUSSION;
        }
        if (this.getProcessBean().getStartDevelopmentDate() != null || this.getProcessBean().getRatificationDate() != null) {
            return PhdMigrationProcessStateType.WORK_DEVELOPMENT;
        }
        if (this.getProcessBean().getRatificationDate() != null) {
            return PhdMigrationProcessStateType.CANDIDACY_RATIFIED;
        }
        if (this.getProcessBean().getStartProcessDate() != null) {
            return PhdMigrationProcessStateType.CANDIDACY_CREATED;
        }
        return PhdMigrationProcessStateType.NOT_MIGRATED;
    }

    public boolean possibleToCompleteNextState() {
        PhdMigrationProcessStateType activeState = this.getMigrationStatus();
        if (activeState.equals((Object)PhdMigrationProcessStateType.CANCELED) || activeState.equals((Object)PhdMigrationProcessStateType.CONCLUDED)) {
            return false;
        }
        if (this.getProcessBean().getClassification() != null) {
            return true;
        }
        if (activeState.equals((Object)PhdMigrationProcessStateType.COMPLETED_THESIS_DISCUSSION) && this.getProcessBean().getEdictDate() != null) {
            return true;
        }
        if (activeState.equals((Object)PhdMigrationProcessStateType.REQUESTED_THESIS_DISCUSSION) && (this.getProcessBean().getFirstDiscussionDate() != null || this.getProcessBean().getSecondDiscussionDate() != null)) {
            return true;
        }
        if (activeState.equals((Object)PhdMigrationProcessStateType.WORK_DEVELOPMENT) && this.getProcessBean().getRequirementDate() != null) {
            return true;
        }
        if (activeState.equals((Object)PhdMigrationProcessStateType.CANDIDACY_RATIFIED) && (this.getProcessBean().getStartDevelopmentDate() != null || this.getProcessBean().getRatificationDate() != null)) {
            return true;
        }
        if (activeState.equals((Object)PhdMigrationProcessStateType.CANDIDACY_CREATED) && this.getProcessBean().getRatificationDate() != null) {
            return true;
        }
        return activeState.equals((Object)PhdMigrationProcessStateType.NOT_MIGRATED) && this.getProcessBean().getStartProcessDate() != null;
    }

    private boolean isProcessCanceled() {
        return this.getProcessBean().getAnnulmentDate() != null;
    }

    public Boolean proceedWithMigration(User user) {
        return (Boolean)advice$proceedWithMigration.perform((Callable)new PhdMigrationIndividualProcessData$callable$proceedWithMigration(this, user));
    }

    static /* synthetic */ Boolean advised$proceedWithMigration(PhdMigrationIndividualProcessData this_, User userView) {
        PhdMigrationProcessStateType activeState;
        PhdIndividualProgramProcess individualProcess = null;
        boolean returnVal = false;
        while (this_.possibleToCompleteNextState()) {
            activeState = this_.getMigrationStatus();
            returnVal = true;
            if (activeState.equals((Object)PhdMigrationProcessStateType.NOT_MIGRATED)) {
                individualProcess = this_.createCandidacyProcess(userView);
                this_.sendCandidacyToCoordinator(userView, individualProcess);
                this_.setMigrationStatus(PhdMigrationProcessStateType.CANDIDACY_CREATED);
                continue;
            }
            if (activeState.equals((Object)PhdMigrationProcessStateType.CANDIDACY_CREATED)) {
                this_.ratifyCandidacyProcess(userView, individualProcess);
                this_.setMigrationStatus(PhdMigrationProcessStateType.CANDIDACY_RATIFIED);
                continue;
            }
            if (activeState.equals((Object)PhdMigrationProcessStateType.CANDIDACY_RATIFIED)) {
                this_.formalizeRegistration(userView, individualProcess);
                this_.setMigrationStatus(PhdMigrationProcessStateType.WORK_DEVELOPMENT);
                continue;
            }
            if (activeState.equals((Object)PhdMigrationProcessStateType.WORK_DEVELOPMENT)) {
                this_.requirePublicThesisPresentation(userView, individualProcess);
                this_.setMigrationStatus(PhdMigrationProcessStateType.REQUESTED_THESIS_DISCUSSION);
                continue;
            }
            if (activeState.equals((Object)PhdMigrationProcessStateType.REQUESTED_THESIS_DISCUSSION)) {
                this_.skipJuryActivities(userView, individualProcess);
                this_.manageMeetingsAndFinalThesis(userView, individualProcess);
                this_.setMigrationStatus(PhdMigrationProcessStateType.COMPLETED_THESIS_DISCUSSION);
                continue;
            }
            if (!activeState.equals((Object)PhdMigrationProcessStateType.COMPLETED_THESIS_DISCUSSION)) break;
            this_.ratifyFinalThesis(userView, individualProcess);
            this_.setMigrationStatus(PhdMigrationProcessStateType.CONCLUDED);
        }
        if (this_.isProcessCanceled()) {
            this_.cancelPhdProgram(userView, individualProcess, this_.getProcessBean().getAnnulmentDate());
            this_.setMigrationStatus(PhdMigrationProcessStateType.CANCELED);
        }
        if (!(activeState = this_.getMigrationStatus()).equals((Object)this_.estimatedFinalMigrationStatus())) {
            throw new FinalEstimatedStateNotReachedException("Estimated: " + (Object)((Object)this_.estimatedFinalMigrationStatus()) + "\treached: " + (Object)((Object)activeState));
        }
        this_.setMigrationDate(new DateTime());
        return returnVal;
    }

    private PhdIndividualProgramProcess createCandidacyProcess(User userView) {
        PhdProgramCandidacyProcessBean candidacyBean = new PhdProgramCandidacyProcessBean();
        candidacyBean.setCandidacyDate(this.getProcessBean().getStartProcessDate());
        candidacyBean.setState(PhdProgramCandidacyProcessState.STAND_BY_WITH_COMPLETE_INFORMATION);
        candidacyBean.setPersonBean(this.getPhdMigrationIndividualPersonalData().getPersonBean());
        candidacyBean.setMigratedProcess(true);
        candidacyBean.setProgram(this.getProcessBean().getPhdProgram());
        candidacyBean.setThesisTitle(this.getProcessBean().getTitle());
        candidacyBean.setPhdStudentNumber(this.getPhdMigrationIndividualPersonalData().getNumber());
        candidacyBean.setCollaborationType(PhdIndividualProgramCollaborationType.NONE);
        candidacyBean.setExecutionYear(this.getExecutionYear());
        candidacyBean.setFocusArea(this.getProcessBean().getPhdProgram().getPhdProgramFocusAreasSet().size() == 1 ? (PhdProgramFocusArea)((Object)this.getProcessBean().getPhdProgram().getPhdProgramFocusAreasSet().iterator().next()) : null);
        PhdIndividualProgramProcess individualProcess = (PhdIndividualProgramProcess)((Object)CreateNewProcess.run(PhdIndividualProgramProcess.class, (Object)candidacyBean));
        return individualProcess;
    }

    private void sendCandidacyToCoordinator(User userView, PhdIndividualProgramProcess individualProcess) {
        PhdProgramCandidacyProcess candidacyProcess = individualProcess.getCandidacyProcess();
        PhdProgramCandidacyProcessStateBean reviewBean = new PhdProgramCandidacyProcessStateBean(candidacyProcess.getIndividualProgramProcess());
        reviewBean.setState(PhdProgramCandidacyProcessState.PENDING_FOR_COORDINATOR_OPINION);
        reviewBean.setGenerateAlert(false);
        ExecuteProcessActivity.run((Process)((Object)candidacyProcess), RequestCandidacyReview.class.getSimpleName(), (Object)reviewBean);
        PhdProgramCandidacyProcessStateBean requestRatifyBean = new PhdProgramCandidacyProcessStateBean(individualProcess);
        requestRatifyBean.setGenerateAlert(false);
        requestRatifyBean.setState(PhdProgramCandidacyProcessState.WAITING_FOR_SCIENTIFIC_COUNCIL_RATIFICATION);
        ExecuteProcessActivity.run((Process)((Object)candidacyProcess), RequestRatifyCandidacy.class.getSimpleName(), (Object)requestRatifyBean);
    }

    private void ratifyCandidacyProcess(User userView, PhdIndividualProgramProcess individualProcess) {
        PhdProgramCandidacyProcess candidacyProcess = individualProcess.getCandidacyProcess();
        RatifyCandidacyBean ratifyBean = new RatifyCandidacyBean(candidacyProcess);
        ratifyBean.setWhenRatified(this.getProcessBean().getRatificationDate());
        ExecuteProcessActivity.run((Process)((Object)candidacyProcess), RatifyCandidacy.class.getSimpleName(), (Object)ratifyBean);
    }

    private void formalizeRegistration(User userView, PhdIndividualProgramProcess individualProcess) {
        PhdIndividualProgramProcessBean individualProcessBean = new PhdIndividualProgramProcessBean(individualProcess);
        individualProcessBean.setQualificationExamsPerformed(PhdIndividualProgramProcessBean.QualificationExamsResult.NO);
        individualProcessBean.setQualificationExamsRequired(PhdIndividualProgramProcessBean.QualificationExamsResult.NO);
        ExecuteProcessActivity.run((Process)((Object)individualProcess), EditQualificationExams.class.getSimpleName(), (Object)individualProcessBean);
        PhdStudyPlanBean planBean = new PhdStudyPlanBean(individualProcess);
        planBean.setExempted(true);
        ExecuteProcessActivity.run((Process)((Object)individualProcess), AddStudyPlan.class.getSimpleName(), (Object)planBean);
        PhdProgramCandidacyProcess candidacyProcess = individualProcess.getCandidacyProcess();
        RegistrationFormalizationBean formalizationBean = new RegistrationFormalizationBean(candidacyProcess);
        formalizationBean.setWhenStartedStudies(this.getMostAccurateStartDevelopmentDate());
        formalizationBean.setSelectRegistration(false);
        ExecuteProcessActivity.run((Process)((Object)candidacyProcess), RegistrationFormalization.class.getSimpleName(), (Object)formalizationBean);
    }

    private LocalDate getMostAccurateStartDevelopmentDate() {
        if (this.getProcessBean().getStartDevelopmentDate() != null) {
            return this.getProcessBean().getStartDevelopmentDate();
        }
        return this.getProcessBean().getRatificationDate();
    }

    private void requirePublicThesisPresentation(User userView, PhdIndividualProgramProcess individualProcess) {
        PhdMigrationGuiding migrationAssistantGuiding;
        PhdMigrationGuiding migrationGuiding;
        ExecuteProcessActivity.run((Process)((Object)individualProcess), ExemptPublicPresentationSeminarComission.class.getSimpleName(), (Object)new PublicPresentationSeminarProcessBean());
        if (!StringUtils.isEmpty((String)this.getProcessBean().getGuiderId()) && (migrationGuiding = this.getGuiding(this.getProcessBean().getGuiderId())) != null) {
            PhdParticipantBean guidingBean = migrationGuiding.getPhdParticipantBean(individualProcess);
            ExecuteProcessActivity.run((Process)((Object)individualProcess), AddGuidingInformation.class.getSimpleName(), (Object)guidingBean);
        }
        if (!StringUtils.isEmpty((String)this.getProcessBean().getAssistantGuiderId()) && (migrationAssistantGuiding = this.getGuiding(this.getProcessBean().getAssistantGuiderId())) != null) {
            PhdParticipantBean assistantGuidingBean = migrationAssistantGuiding.getPhdParticipantBean(individualProcess);
            ExecuteProcessActivity.run((Process)((Object)individualProcess), AddAssistantGuidingInformation.class.getSimpleName(), (Object)assistantGuidingBean);
        }
        PhdThesisProcessBean thesisBean = new PhdThesisProcessBean(individualProcess);
        thesisBean.setWhenThesisDiscussionRequired(this.getProcessBean().getRequirementDate());
        thesisBean.setGenerateAlert(false);
        thesisBean.setToNotify(false);
        ExecuteProcessActivity.run((Process)((Object)individualProcess), RequestPublicThesisPresentation.class.getSimpleName(), (Object)thesisBean);
    }

    private PhdMigrationGuiding getGuiding(String guidingNumber) {
        String alternativeGuidingNumber = "0".concat(guidingNumber);
        for (PhdMigrationGuiding migrationGuiding : this.getPhdMigrationProcess().getPhdMigrationGuidingSet()) {
            if (!guidingNumber.equals(migrationGuiding.getTeacherId()) && !alternativeGuidingNumber.equals(migrationGuiding.getTeacherId())) continue;
            return migrationGuiding;
        }
        return null;
    }

    private void skipJuryActivities(User userView, PhdIndividualProgramProcess individualProcess) {
        PhdThesisProcess thesisProcess = individualProcess.getThesisProcess();
        PhdThesisProcessBean thesisBean = new PhdThesisProcessBean();
        thesisBean.setThesisProcess(thesisProcess);
        thesisBean.setToNotify(false);
        thesisBean.setGenerateAlert(false);
        ExecuteProcessActivity.run((Process)((Object)individualProcess.getThesisProcess()), SkipThesisJuryActivities.class.getSimpleName(), (Object)thesisBean);
    }

    private void manageMeetingsAndFinalThesis(User userView, PhdIndividualProgramProcess individualProcess) {
        PhdThesisProcess thesisProcess = individualProcess.getThesisProcess();
        PhdThesisProcessBean thesisBean = new PhdThesisProcessBean();
        thesisBean.setThesisProcess(thesisProcess);
        thesisBean.setToNotify(false);
        thesisBean.setGenerateAlert(false);
        PhdMeetingSchedulingProcess meetingProcess = thesisProcess.getMeetingProcess();
        ExecuteProcessActivity.run((Process)((Object)meetingProcess), ScheduleFirstThesisMeetingRequest.class, (Object)thesisBean);
        thesisBean.setScheduledDate(this.getMeetingDate());
        thesisBean.setScheduledPlace("");
        ExecuteProcessActivity.run((Process)((Object)meetingProcess), SkipScheduleFirstThesisMeeting.class, (Object)thesisBean);
        thesisBean.setScheduledDate(this.getMostAccurateDiscussionDateTime());
        thesisBean.setScheduledPlace("");
        ExecuteProcessActivity.run((Process)((Object)thesisProcess), SkipScheduleThesisDiscussion.class, (Object)thesisBean);
        ExecuteProcessActivity.run((Process)((Object)thesisProcess), SubmitThesis.class, (Object)thesisBean);
    }

    private DateTime getMostAccurateDiscussionDateTime() {
        if (this.getProcessBean().getSecondDiscussionDate() != null) {
            return this.getProcessBean().getSecondDiscussionDate().toDateTimeAtCurrentTime();
        }
        if (this.getProcessBean().getFirstDiscussionDate() != null) {
            return this.getProcessBean().getFirstDiscussionDate().toDateTimeAtCurrentTime();
        }
        return null;
    }

    private DateTime getMeetingDate() {
        if (this.getProcessBean().getMeetingDate() != null) {
            return this.getProcessBean().getMeetingDate().toDateTimeAtCurrentTime();
        }
        return null;
    }

    private void ratifyFinalThesis(User userView, PhdIndividualProgramProcess individualProcess) {
        PhdThesisProcess thesisProcess = individualProcess.getThesisProcess();
        PhdThesisProcessBean thesisBean = new PhdThesisProcessBean();
        thesisBean.setThesisProcess(thesisProcess);
        thesisBean.setToNotify(false);
        thesisBean.setGenerateAlert(false);
        thesisBean.setWhenFinalThesisRatified(this.getProcessBean().getEdictDate());
        ExecuteProcessActivity.run((Process)((Object)thesisProcess), RatifyFinalThesis.class, (Object)thesisBean);
        thesisBean.setConclusionDate(this.getProcessBean().getEdictDate());
        thesisBean.setFinalGrade(this.getProcessBean().getClassification());
        ExecuteProcessActivity.run((Process)((Object)thesisProcess), SetFinalGrade.class, (Object)thesisBean);
    }

    private void cancelPhdProgram(User userView, PhdIndividualProgramProcess individualProcess, LocalDate anullmentDate) {
        PhdIndividualProgramProcessBean processBean = new PhdIndividualProgramProcessBean(individualProcess);
        processBean.setStateDate(anullmentDate);
        ExecuteProcessActivity.run((Process)((Object)individualProcess), CancelPhdProgramProcess.class.getSimpleName(), (Object)processBean);
    }
}

