/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.email;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.email.PhdEmailBean;
import org.fenixedu.academic.domain.phd.email.PhdProgramEmail;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.academic.util.predicates.AndPredicate;
import org.fenixedu.academic.util.predicates.InlinePredicate;
import org.joda.time.DateTime;

public class PhdProgramEmailBean
extends PhdEmailBean {
    private static final long serialVersionUID = 1L;
    private PhdProgram phdProgram;
    private List<PhdIndividualProgramProcess> selectedElements;
    private boolean showProgramsChoice = true;

    public PhdProgramEmailBean() {
    }

    public PhdProgramEmailBean(PhdProgram phdProgram) {
        this.phdProgram = phdProgram;
    }

    public PhdProgramEmailBean(PhdProgramEmail email) {
        this.subject = email.getFormattedSubject().getContent(MultiLanguageString.pt);
        this.message = email.getFormattedBody().getContent(MultiLanguageString.pt);
        this.bccs = email.getBccs();
        this.creationDate = email.getWhenCreated();
        this.creator = email.getPerson();
    }

    public PhdProgram getPhdProgram() {
        return this.phdProgram;
    }

    public void setPhdProgram(PhdProgram phdProgram) {
        this.phdProgram = phdProgram;
    }

    public List<PhdIndividualProgramProcess> getSelectedElements() {
        if (this.selectedElements != null) {
            return this.selectedElements;
        }
        return new ArrayList<PhdIndividualProgramProcess>();
    }

    public void setSelectedElements(List<PhdIndividualProgramProcess> selectedElements) {
        this.selectedElements = selectedElements;
    }

    public AndPredicate<PhdIndividualProgramProcess> getManagedPhdProgramsPredicate() {
        AndPredicate<PhdIndividualProgramProcess> result = new AndPredicate<PhdIndividualProgramProcess>();
        if (this.getPhdProgram() != null) {
            result.add(new InlinePredicate<PhdIndividualProgramProcess, PhdProgram>(this.getPhdProgram()){

                @Override
                public boolean test(PhdIndividualProgramProcess toEval) {
                    if (toEval.getPhdProgram() != null) {
                        return ((PhdProgram)((Object)this.getValue())).equals((Object)toEval.getPhdProgram());
                    }
                    if (toEval.getPhdProgramFocusArea() != null) {
                        return !CollectionUtils.intersection(Collections.singleton(this.getValue()), (Collection)toEval.getPhdProgramFocusArea().getPhdProgramsSet()).isEmpty();
                    }
                    return false;
                }
            });
        }
        return result;
    }

    public void updateBean() {
        this.setCreationDate(new DateTime());
        this.setCreator(AccessControl.getPerson());
    }

    public String getBccsWithSelectedParticipants() {
        String bccs;
        String string = bccs = this.getBccs() == null ? null : this.getBccs().replace(" ", "");
        if (!StringUtils.isEmpty(bccs)) {
            bccs = bccs + ",";
        }
        for (PhdIndividualProgramProcess process2 : this.getSelectedElements()) {
            if (process2.getPerson().getEmailForSendingEmails() == null) continue;
            bccs = bccs + process2.getPerson().getEmailForSendingEmails();
            bccs = bccs + ",";
        }
        if (bccs.endsWith(",")) {
            bccs = bccs.substring(0, bccs.length() - 1);
        }
        return bccs;
    }

    public boolean isShowProgramsChoice() {
        return this.showProgramsChoice;
    }

    public void setShowProgramsChoice(boolean showProgramsChoice) {
        this.showProgramsChoice = showProgramsChoice;
    }
}

