/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.debts;

import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramCalendarUtil;
import org.fenixedu.academic.domain.phd.debts.PhdRegistrationFee;
import org.fenixedu.academic.domain.phd.debts.PhdRegistrationFeePR_Base;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class PhdRegistrationFeePR
extends PhdRegistrationFeePR_Base {
    private PhdRegistrationFeePR() {
    }

    public PhdRegistrationFeePR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount, Money fixedAmountPenalty) {
        this();
        super.init(EntryType.PHD_REGISTRATION_FEE, EventType.PHD_REGISTRATION_FEE, startDate, endDate, serviceAgreementTemplate, fixedAmount, fixedAmountPenalty);
    }

    public PhdRegistrationFeePR edit(Money fixedAmount, Money penaltyAmount) {
        this.deactivate();
        return new PhdRegistrationFeePR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), fixedAmount, penaltyAmount);
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        Money total = super.doCalculationForAmountToPay(event, when, applyDiscount).add(this.hasPenalty(event, when) ? this.getFixedAmountPenalty() : Money.ZERO);
        return total;
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        PhdRegistrationFee feeEvent = (PhdRegistrationFee)((Object)event);
        if (feeEvent.hasPhdEventExemption()) {
            amountToPay = amountToPay.subtract(feeEvent.getPhdEventExemption().getValue());
        }
        return amountToPay.isPositive() ? amountToPay : Money.ZERO;
    }

    protected boolean hasPenalty(Event event, DateTime when) {
        PhdRegistrationFee phdEvent = (PhdRegistrationFee)((Object)event);
        if (phdEvent.hasPhdRegistrationFeePenaltyExemption()) {
            return false;
        }
        PhdIndividualProgramProcess process2 = phdEvent.getProcess();
        return PhdProgramCalendarUtil.countWorkDaysBetween(process2.getCandidacyProcess().getWhenRatified(), process2.getWhenFormalizedRegistration()) > 20;
    }
}

