/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.messaging;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.messaging.ConversationMessage_Base;
import org.fenixedu.academic.domain.messaging.ConversationThread;
import org.fenixedu.academic.util.MultiLanguageString;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ConversationMessage
extends ConversationMessage_Base
implements Comparable<ConversationMessage> {
    public ConversationMessage(ConversationThread conversationThread, Person creator, MultiLanguageString body) {
        this.setCreationDate(new DateTime());
        this.init(conversationThread, creator, body);
    }

    private void init(ConversationThread conversationThread, Person creator, MultiLanguageString body) {
        this.setConversationThread(conversationThread);
        this.setBody(body);
        this.setCreator(creator);
    }

    public void setCreator(Person creator) {
        if (creator == null) {
            throw new DomainException("conversationMessage.creator.cannot.be.null", new String[0]);
        }
        super.setCreator(creator);
    }

    public void setBody(MultiLanguageString body) {
        if (body == null) {
            throw new DomainException("conversationMessage.body.cannot.be.null", new String[0]);
        }
        super.setBody(body);
    }

    public void setConversationThread(ConversationThread conversationThread) {
        if (conversationThread == null) {
            throw new DomainException("conversationMessage.conversationThread.cannot.be.null", new String[0]);
        }
        super.setConversationThread(conversationThread);
    }

    public void delete() {
        this.setCreator(null);
        this.setConversationThread(null);
        this.deleteDomainObject();
    }

    @Override
    public int compareTo(ConversationMessage o) {
        return this.getCreationDate().compareTo((ReadableInstant)o.getCreationDate());
    }
}

